/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import net.jxta.impl.index.xpath.DocumentParserCallback;
import net.jxta.impl.index.xpath.Expression;
import net.jxta.impl.index.xpath.XPath;
import net.jxta.impl.xml.XmlParser;
import net.jxta.index.IndexService;

public class IndexServiceImpl
implements IndexService {
    static int totalSplitStrings;
    static int totalChars;
    static int totalInternedChars;
    static int totalSuffixChars;
    static HashMap internTable;
    String[] STRING_ARR = new String[0];

    static String intern(String s) {
        String interned = (String)internTable.get(s);
        if (interned == null) {
            internTable.put(s, s);
            interned = s;
            totalInternedChars += s.length();
        }
        return interned;
    }

    public IndexService.Index getIndex(File dir) throws IOException {
        return new ForwardIndex();
    }

    public IndexService.ReverseIndex getReverseIndex(File dir) throws IOException {
        return new ReverseIndex();
    }

    public void printStats() {
        System.out.println("Split Strings:        " + totalSplitStrings);
        System.out.println("Total Chars:          " + totalChars);
        System.out.println("Total Interned Chars: " + totalInternedChars);
        System.out.println("Total Suffix Chars:   " + totalSuffixChars);
    }

    Expression.Clause getLogicalExpression(InputStream doc, byte[] buf) throws IOException, IndexService.BadDocumentException {
        DocumentParserCallback cb = new DocumentParserCallback();
        Expression.Clause cnf = new Expression.Clause("and");
        Expression.Clause disjunction = new Expression.Clause("or");
        try {
            long start = System.currentTimeMillis();
            long dataSize = XmlParser.parse(doc, buf, cb);
            long end = System.currentTimeMillis();
            TreeSet paths = cb.getPaths();
            Iterator i = paths.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                disjunction.addSubexpression(new Expression.Literal(new SplitString(path)));
            }
            cnf.addSubexpression((Expression.LogicalExpression)disjunction);
            return cnf;
        }
        catch (XmlParser.Exception e) {
            throw new IndexService.BadDocumentException("Unable to parse document.", e);
        }
    }

    static {
        internTable = new HashMap();
    }

    class ReadWriteLock {
        boolean inWrite;
        int readers;

        ReadWriteLock() {
        }

        synchronized void enterWrite() throws IndexService.IndexException {
            while (this.inWrite) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IndexService.IndexException("Unable to acquire write lock.", e);
                }
            }
            this.inWrite = true;
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IndexService.IndexException("Unable to acquire write lock.", e);
                }
            }
        }

        synchronized void leaveWrite() {
            if (this.inWrite) {
                this.inWrite = false;
                this.notifyAll();
            }
        }

        synchronized void enterRead() throws IndexService.IndexException {
            while (this.inWrite) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IndexService.IndexException("Unable to acquire read lock.", e);
                }
            }
            ++this.readers;
        }

        synchronized void leaveRead() {
            if (--this.readers == 0) {
                this.notifyAll();
            }
        }
    }

    class PossibleMatch {
        String predicateId;
        int disjunctionCount;
        HashMap disjunctions;

        PossibleMatch(String predicateId, int disjunctionCount) {
            this.predicateId = predicateId;
            this.disjunctionCount = disjunctionCount;
        }

        boolean isMatch() {
            return this.disjunctionCount == 0;
        }

        void matchedClause() {
            --this.disjunctionCount;
        }

        void matchedClause(Integer disjunctionId, Expression.Clause disjunction) {
            if (this.disjunctions == null) {
                this.disjunctions = new HashMap();
            }
            this.disjunctions.put(disjunctionId, disjunction);
            --this.disjunctionCount;
        }
    }

    class Index {
        HashMap literalsTable = new HashMap();
        HashMap disjunctionInfoTable = new HashMap();
        HashMap predicateInfoTable = new HashMap();
        int nextDisjunctionId;

        Index() {
        }

        int getDisjunctionCount(String conjunctionId) {
            PredicateInfo info = (PredicateInfo)this.predicateInfoTable.get(conjunctionId);
            return info == null ? -1 : info.disjunctionCount;
        }

        String getConjunctionId(Integer disjunctionId) {
            DisjunctionInfo info = (DisjunctionInfo)this.disjunctionInfoTable.get(disjunctionId);
            return info == null ? null : info.predicateId;
        }

        int getLiteralCount(Integer disjunctionId) {
            DisjunctionInfo info = (DisjunctionInfo)this.disjunctionInfoTable.get(disjunctionId);
            return info.literalCount;
        }

        void add(String id, Expression.Clause predicate) {
            Enumeration disjunctions = predicate.getSubexpressions();
            int firstDisjunctionId = this.nextDisjunctionId;
            int disjunctionCount = 0;
            while (disjunctions.hasMoreElements()) {
                int literalCount = 0;
                Expression.Clause disjunction = (Expression.Clause)disjunctions.nextElement();
                Enumeration literals = disjunction.getSubexpressions();
                Integer disjunctionId = new Integer(this.nextDisjunctionId++);
                while (literals.hasMoreElements()) {
                    Object literal = ((Expression.Literal)literals.nextElement()).getName();
                    this.literalsTablePut(literal, disjunctionId);
                    ++literalCount;
                }
                this.disjunctionInfoTable.put(disjunctionId, new DisjunctionInfo(id, literalCount));
                ++disjunctionCount;
            }
            this.predicateInfoTable.put(id, new PredicateInfo(firstDisjunctionId, disjunctionCount));
        }

        void remove(String id, Expression.Clause predicate) {
            Enumeration disjunctions = predicate.getSubexpressions();
            HashMap<String, PossibleMatch> possibleMatches = new HashMap<String, PossibleMatch>();
            TreeSet matches = new TreeSet();
            while (disjunctions.hasMoreElements()) {
                int literalCount = 0;
                Expression.Clause disjunction = (Expression.Clause)disjunctions.nextElement();
                Enumeration literals = disjunction.getSubexpressions();
                TreeSet disjunctionSet = new TreeSet();
                while (literals.hasMoreElements()) {
                    Object literal = ((Expression.Literal)literals.nextElement()).getName();
                    TreeSet occurrences = this.literalsTableGet(literal, false);
                    if (occurrences == null) {
                        return;
                    }
                    if (disjunctionSet.size() == 0) {
                        disjunctionSet.addAll(occurrences);
                    } else {
                        disjunctionSet.retainAll(occurrences);
                    }
                    ++literalCount;
                }
                Iterator matchedDisjunctions = disjunctionSet.iterator();
                while (matchedDisjunctions.hasNext()) {
                    Integer disjunctionId = (Integer)matchedDisjunctions.next();
                    String conjunctionId = this.getConjunctionId(disjunctionId);
                    if (!id.equals(conjunctionId) || this.getLiteralCount(disjunctionId) != literalCount) continue;
                    PossibleMatch pm = (PossibleMatch)possibleMatches.get(conjunctionId);
                    if (pm == null) {
                        pm = new PossibleMatch(conjunctionId, this.getDisjunctionCount(conjunctionId));
                        possibleMatches.put(conjunctionId, pm);
                    }
                    pm.matchedClause(disjunctionId, disjunction);
                    if (!pm.isMatch()) continue;
                    Iterator ids = pm.disjunctions.keySet().iterator();
                    while (ids.hasNext()) {
                        disjunctionId = (Integer)ids.next();
                        disjunction = (Expression.Clause)pm.disjunctions.get(disjunctionId);
                        this.removeDisjunctionLiterals(disjunctionId, disjunction);
                        this.disjunctionInfoTable.remove(disjunctionId);
                    }
                    this.predicateInfoTable.remove(conjunctionId);
                }
            }
        }

        void removeDisjunctionLiterals(Integer disjunctionId, Expression.Clause disjunction) {
            Enumeration literals = disjunction.getSubexpressions();
            while (literals.hasMoreElements()) {
                Expression.Literal literal = (Expression.Literal)literals.nextElement();
                TreeSet occurrences = this.literalsTableGet(literal.getName(), false);
                occurrences.remove(disjunctionId);
                if (occurrences.size() != 0) continue;
                this.literalsTable.remove(literal);
            }
        }

        void literalsTablePut(Object literal, Integer disjunctionId) {
            Object occurrence = this.literalsTable.get(literal);
            if (occurrence == null) {
                this.literalsTable.put(literal, disjunctionId);
            } else if (occurrence instanceof TreeSet) {
                ((TreeSet)occurrence).add(disjunctionId);
            } else {
                TreeSet<Object> occurrences = new TreeSet<Object>();
                occurrences.add(occurrence);
                occurrences.add(disjunctionId);
                this.literalsTable.put(literal, occurrences);
            }
        }

        TreeSet literalsTableGet(Object literal, boolean forward) {
            Object occurrence = forward ? this.literalsTable.get(new SplitString((String)literal)) : this.literalsTable.get(literal);
            if (occurrence == null || occurrence instanceof TreeSet) {
                return (TreeSet)occurrence;
            }
            TreeSet occurrences = new TreeSet();
            occurrences.add(occurrence);
            return occurrences;
        }

        TreeSet query(Expression.LogicalExpression predicate, boolean forward) {
            if (predicate instanceof Expression.Literal) {
                return this.query((Expression.Literal)predicate, forward);
            }
            return this.query((Expression.Clause)predicate, forward);
        }

        void remove(Expression.Literal literal) {
        }

        TreeSet query(Expression.Literal literal, boolean forward) {
            TreeSet disjunctionSet = this.literalsTableGet(literal.getName().toString(), forward);
            TreeSet<String> conjunctionSet = new TreeSet<String>();
            if (disjunctionSet != null) {
                Iterator i = disjunctionSet.iterator();
                while (i.hasNext()) {
                    Integer disjunctionId = (Integer)i.next();
                    String conjunctionId = this.getConjunctionId(disjunctionId);
                    if (conjunctionId == null) continue;
                    conjunctionSet.add(conjunctionId);
                }
            }
            return conjunctionSet;
        }

        TreeSet query(Expression.Clause predicate, boolean forward) {
            Enumeration disjunctions = predicate.getSubexpressions();
            TreeSet conjunctionSet = null;
            HashMap<String, PossibleMatch> possibleMatches = new HashMap<String, PossibleMatch>();
            TreeSet<String> matches = new TreeSet<String>();
            while (disjunctions.hasMoreElements()) {
                Expression.Clause disjunction = (Expression.Clause)disjunctions.nextElement();
                Enumeration literals = disjunction.getSubexpressions();
                TreeSet disjunctionSet = new TreeSet();
                while (literals.hasMoreElements()) {
                    Expression.Literal literal = (Expression.Literal)literals.nextElement();
                    TreeSet occurrences = this.literalsTableGet(literal.getName().toString(), forward);
                    if (occurrences == null) continue;
                    disjunctionSet.addAll(occurrences);
                }
                if (conjunctionSet == null) {
                    conjunctionSet = disjunctionSet;
                    continue;
                }
                conjunctionSet.retainAll(disjunctionSet);
            }
            Iterator matchedDisjunctions = conjunctionSet.iterator();
            while (matchedDisjunctions.hasNext()) {
                Integer disjunctionId = (Integer)matchedDisjunctions.next();
                String conjunctionId = this.getConjunctionId(disjunctionId);
                PossibleMatch pm = null;
                if (conjunctionId != null) {
                    pm = (PossibleMatch)possibleMatches.get(conjunctionId);
                }
                if (pm == null) {
                    int disjunctionCount = this.getDisjunctionCount(conjunctionId);
                    pm = new PossibleMatch(conjunctionId, disjunctionCount);
                    possibleMatches.put(conjunctionId, pm);
                }
                pm.matchedClause();
                if (!pm.isMatch()) continue;
                matches.add(conjunctionId);
            }
            return matches;
        }
    }

    class DisjunctionInfo {
        String predicateId;
        int literalCount;

        DisjunctionInfo(String predicateId, int literalCount) {
            this.predicateId = predicateId;
            this.literalCount = literalCount;
        }
    }

    class PredicateInfo {
        int firstDisjunctionId;
        int disjunctionCount;

        PredicateInfo(int firstDisjunctionId, int disjunctionCount) {
            this.firstDisjunctionId = firstDisjunctionId;
            this.disjunctionCount = disjunctionCount;
        }
    }

    class ForwardIndex
    implements IndexService.Index {
        File dir;
        byte[] buf = new byte[8192];
        Index index;
        ReadWriteLock lock;

        ForwardIndex() {
            this.index = new Index();
            this.lock = new ReadWriteLock();
        }

        public synchronized void add(String id, InputStream doc) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
            try {
                Expression.Clause paths = IndexServiceImpl.this.getLogicalExpression(doc, this.buf);
                this.lock.enterWrite();
                this.index.add(id, paths);
                Object var5_4 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        public synchronized void remove(String id, InputStream doc) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
            try {
                Expression.Clause paths = IndexServiceImpl.this.getLogicalExpression(doc, this.buf);
                this.lock.enterWrite();
                this.index.remove(id, paths);
                Object var5_4 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String[] query(String xpath) throws IndexService.BadQueryException, IndexService.IndexException {
            String[] stringArray;
            block6: {
                try {
                    String[] stringArray2;
                    block5: {
                        try {
                            String[] retVal;
                            XPath compiledXPath = new XPath(xpath.toUpperCase());
                            Expression.LogicalExpression paths = compiledXPath.unroll();
                            this.lock.enterRead();
                            TreeSet res = this.index.query(paths, true);
                            if (res == null) {
                                stringArray2 = null;
                                Object var8_8 = null;
                                break block5;
                            }
                            stringArray = retVal = res.toArray(IndexServiceImpl.this.STRING_ARR);
                            break block6;
                        }
                        catch (IllegalArgumentException e) {
                            throw new IndexService.BadQueryException("Invalid XPath.", e);
                        }
                    }
                    this.lock.leaveRead();
                    return stringArray2;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.lock.leaveRead();
                    throw throwable;
                }
            }
            Object var8_9 = null;
            this.lock.leaveRead();
            return stringArray;
        }
    }

    class ReverseIndex
    implements IndexService.ReverseIndex {
        File dir;
        byte[] buf = new byte[8192];
        Index index;
        ReadWriteLock lock;

        ReverseIndex() {
            this.index = new Index();
            this.lock = new ReadWriteLock();
        }

        public void add(String id, String xpath) throws IndexService.BadQueryException, IndexService.IndexException {
            try {
                try {
                    XPath compiledXPath = new XPath(xpath.toUpperCase());
                    Expression.LogicalExpression paths = compiledXPath.unroll();
                    this.lock.enterWrite();
                    this.index.add(id, (Expression.Clause)paths);
                }
                catch (IllegalArgumentException e) {
                    throw new IndexService.BadQueryException("Invalid xpath.", e);
                }
                Object var6_6 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        public void remove(String id, String xpath) throws IndexService.BadQueryException, IndexService.IndexException {
            try {
                try {
                    XPath compiledXPath = new XPath(xpath.toUpperCase());
                    Expression.LogicalExpression paths = compiledXPath.unroll();
                    this.lock.enterWrite();
                    this.index.remove(id, (Expression.Clause)paths);
                }
                catch (IllegalArgumentException e) {
                    throw new IndexService.BadQueryException("Invalid xpath.", e);
                }
                Object var6_6 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        public String[] query(InputStream doc) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
            try {
                String[] res;
                Expression.Clause paths = IndexServiceImpl.this.getLogicalExpression(doc, this.buf);
                this.lock.enterRead();
                String[] stringArray = res = this.index.query(paths, false).toArray(IndexServiceImpl.this.STRING_ARR);
                Object var6_5 = null;
                this.lock.leaveRead();
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.lock.leaveRead();
                throw throwable;
            }
        }
    }

    static final class SplitString {
        final String prefix;
        final String suffix;
        int hashCode;

        SplitString(String whole) {
            int prefixLen = SplitString.findPrefixLength(whole);
            this.prefix = IndexServiceImpl.intern(SplitString.substring(whole, 0, prefixLen));
            this.suffix = SplitString.substring(whole, prefixLen, whole.length());
            this.hashCode = whole.hashCode();
            ++totalSplitStrings;
            totalChars += whole.length();
            totalSuffixChars += this.suffix.length();
        }

        static int findPrefixLength(String s1) {
            int amp = s1.indexOf(64);
            int len = amp == -1 ? s1.indexOf(39) : s1.indexOf(91);
            if (len == -1) {
                len = s1.lastIndexOf(47);
            }
            return len + 1;
        }

        static String substring(String original, int from, int to) {
            char[] value = original.toCharArray();
            return new String(value, from, to - from);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof SplitString) {
                SplitString other = (SplitString)o;
                return this.prefix == other.prefix && this.suffix.equals(other.suffix);
            }
            if (o instanceof String) {
                String other = (String)o;
                return other.length() == this.prefix.length() + this.suffix.length() && other.startsWith(this.prefix) && other.endsWith(this.suffix);
            }
            return false;
        }

        public String toString() {
            return this.prefix + " " + this.suffix;
        }
    }

    static class SplitStringComparator
    implements Comparator {
        SplitStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            SplitString ss1 = (SplitString)o1;
            SplitString ss2 = (SplitString)o2;
            int ret = ss1.prefix.compareTo(ss2.prefix);
            if (ret == 0) {
                ret = ss2.suffix.compareTo(ss2.suffix);
            }
            return ret;
        }

        public boolean equals(Object o) {
            return o instanceof SplitStringComparator;
        }
    }
}

