/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.math.BigInteger;
import jxta.security.hash.Hash;
import jxta.security.impl.hash.MD5Hash;
import net.jxta.impl.index.BloomFilterProperties;

public class BloomFilter {
    private static final int INT_MASK = 255;
    Hash hash;
    int hashLength;
    int capacityFactor = 8;
    boolean DEBUGFLAG = false;
    BloomFilterProperties bfProperties;

    public BloomFilter(int capacity) {
        this.bfProperties = new BloomFilterProperties();
        this.bfProperties.setLength(capacity * this.capacityFactor);
        this.hash = new MD5Hash();
        this.hashLength = this.hash.getDigestLength();
    }

    public BloomFilter(BloomFilterProperties p) {
        this.bfProperties = p;
        if (this.bfProperties == null) {
            this.bfProperties = new BloomFilterProperties();
        }
        this.hash = new MD5Hash();
        this.hashLength = this.hash.getDigestLength();
    }

    public int getBitsPerEntry() {
        return this.bfProperties.nFunctionsPerEntry;
    }

    public int getLength() {
        return this.bfProperties.length;
    }

    public int[] getBitPositions(String key) {
        int[] result = new int[this.bfProperties.nFunctionsPerEntry];
        byte[] digest = new byte[this.hashLength];
        byte[] inBuf = key.getBytes();
        this.hash.doFinal(inBuf, 0, inBuf.length, digest, 0);
        this.debug("key = " + key + "\n" + "digest=" + new BigInteger(1, digest).toString(16));
        int offset = 0;
        int i = 0;
        while (i < this.bfProperties.nFunctionsPerEntry) {
            result[i] = this.getBitPosition(digest, offset);
            offset += this.bfProperties.nBitsPerFunction;
            this.debug("Position" + i + "=" + result[i]);
            ++i;
        }
        return result;
    }

    public BloomFilterProperties getProperties() {
        return this.bfProperties;
    }

    private int getBitPosition(byte[] buffer, int offset) {
        int startByte = offset / 8;
        int startByteOffset = offset % 8;
        int endByte = (offset + this.bfProperties.nBitsPerFunction - 1) / 8;
        int endByteOffset = (offset + this.bfProperties.nBitsPerFunction - 1) % 8;
        int sum = (buffer[startByte] & 0xFF) >>> startByteOffset;
        int counter = 1;
        int i = startByte + 1;
        while (i < endByte) {
            sum += (buffer[i] & 0xFF) << counter * 8 - startByteOffset;
            ++i;
            ++counter;
        }
        return (sum += (buffer[endByte] & 255 >>> 8 - (endByteOffset + 1) & 0xFF) << (endByte - startByte) * 8 - startByteOffset) % this.bfProperties.length;
    }

    public void debug(String message) {
        if (this.DEBUGFLAG) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) {
        System.out.println(8334);
        BloomFilter x = new BloomFilter(100);
        int[] nArray = x.getBitPositions("Sherif");
    }
}

