/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.util.Random;
import jxta.security.impl.random.JRandom;
import net.jxta.impl.id.UUID.UUID;

public class UUIDFactory {
    private static boolean inited = false;
    private static Random randNum = null;
    private static byte[] randBuf16 = new byte[16];

    public static synchronized UUID newUUID() {
        if (!inited) {
            try {
                randNum = new JRandom();
            }
            catch (Throwable everything) {
                randNum = new Random();
            }
            inited = true;
        }
        randNum.nextBytes(randBuf16);
        randBuf16[6] = (byte)(randBuf16[6] & 0xF);
        randBuf16[6] = (byte)(randBuf16[6] | 0x40);
        randBuf16[8] = (byte)(randBuf16[8] & 0x3F);
        randBuf16[8] = (byte)(randBuf16[8] | 0x80);
        randBuf16[10] = (byte)(randBuf16[10] & 0x3F);
        randBuf16[10] = (byte)(randBuf16[10] | 0x80);
        long mostSig = 0L;
        int i = 0;
        while (i < 8) {
            mostSig = mostSig << 8 | (long)(randBuf16[i] & 0xFF);
            ++i;
        }
        long leastSig = 0L;
        int i2 = 8;
        while (i2 < 16) {
            leastSig = leastSig << 8 | (long)(randBuf16[i2] & 0xFF);
            ++i2;
        }
        return new UUID(mostSig, leastSig);
    }
}

