/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URL;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public final class PipeID
extends net.jxta.pipe.PipeID {
    static final int groupIdOffset = 0;
    static final int idOffset = 16;
    static final int padOffset = 32;
    static final int padSize = 31;
    protected IDBytes id;

    PipeID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 4;
    }

    PipeID(IDBytes id) {
        this.id = id;
    }

    public PipeID(UUID groupUUID, UUID idUUID) {
        this();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, idUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, idUUID.getLeastSignificantBits());
    }

    public PipeID(PeerGroupID groupID) {
        this(new UUID(groupID.id.bytesIntoLong(0), groupID.id.bytesIntoLong(8)), UUIDFactory.newUUID());
    }

    public PipeID(PeerGroupID groupID, byte[] seed) {
        this();
        UUID groupUUID = new UUID(groupID.id.bytesIntoLong(0), groupID.id.bytesIntoLong(8));
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        int copySeed = Math.min(16, seed.length) - 1;
        while (copySeed >= 0) {
            this.id.bytes[copySeed + 16] = seed[copySeed];
            --copySeed;
        }
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof String) {
            return target.equals(this.toString());
        }
        if (target instanceof PipeID) {
            return this.id.equals(((PipeID)target).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public ID getPeerGroupID() {
        UUID groupUUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return IDFormat.translateToWellKnown(groupID);
    }
}

