/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.UUID.CodatID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.ModuleClassID;
import net.jxta.impl.id.UUID.ModuleSpecID;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.PeerID;
import net.jxta.impl.id.UUID.PipeID;

final class Instantiator
implements IDFactory.Instantiator {
    static final String UUIDEncoded = "uuid";

    Instantiator() {
    }

    public String getSupportedIDFormat() {
        return UUIDEncoded;
    }

    public ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        ID result = null;
        IDBytes id = new IDBytes();
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        int colonAt = encoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(encoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        int dashAt = (encoded = encoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        if (!encoded.substring(0, dashAt).equals(UUIDEncoded)) {
            throw new UnknownServiceException("JXTA id format was not as expected.");
        }
        if (0 != (encoded = encoded.substring(dashAt + 1)).length() % 2) {
            throw new MalformedURLException("URN contains an odd number of chars");
        }
        if (encoded.length() < 2) {
            throw new MalformedURLException("URN does not contain enough chars");
        }
        if (64 < encoded.length() % 2) {
            throw new MalformedURLException("URN contains too many chars");
        }
        try {
            int eachByte = 0;
            while (eachByte < encoded.length() / 2 - 1) {
                int index = eachByte * 2;
                String twoChars = encoded.substring(index, index + 2);
                id.bytes[eachByte] = (byte)Integer.parseInt(twoChars, 16);
                ++eachByte;
            }
            id.bytes[63] = (byte)Integer.parseInt(encoded.substring(encoded.length() - 2), 16);
        }
        catch (NumberFormatException caught) {
            throw new MalformedURLException("Invalid Character in jxta URI");
        }
        switch (id.bytes[63]) {
            case 1: {
                result = new CodatID(id);
                break;
            }
            case 2: {
                result = new PeerGroupID(id);
                if (!net.jxta.peergroup.PeerGroupID.worldPeerGroupID.equals(result)) break;
                result = net.jxta.peergroup.PeerGroupID.worldPeerGroupID;
                break;
            }
            case 3: {
                result = new PeerID(id);
                break;
            }
            case 4: {
                result = new PipeID(id);
                break;
            }
            case 5: {
                result = new ModuleClassID(id);
                break;
            }
            case 6: {
                result = new ModuleSpecID(id);
                break;
            }
            default: {
                throw new MalformedURLException("jxta ID type not recognized");
            }
        }
        return result;
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID groupID) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatID(peerGroupID);
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID groupID, InputStream in) throws IOException {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatID(peerGroupID, in);
    }

    public net.jxta.peer.PeerID newPeerID(net.jxta.peergroup.PeerGroupID groupID) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PeerID(peerGroupID);
    }

    public net.jxta.peergroup.PeerGroupID newPeerGroupID() {
        return new PeerGroupID();
    }

    public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID groupID) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PipeID(peerGroupID);
    }

    public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID groupID, byte[] seed) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PipeID(peerGroupID, seed);
    }

    public net.jxta.platform.ModuleClassID newModuleClassID() {
        return new ModuleClassID();
    }

    public net.jxta.platform.ModuleClassID newModuleClassID(net.jxta.platform.ModuleClassID classID) {
        return new ModuleClassID(classID);
    }

    public net.jxta.platform.ModuleSpecID newModuleSpecID(net.jxta.platform.ModuleClassID classID) {
        return new ModuleSpecID(classID);
    }
}

