/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.cert.CertVerify;
import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.sslg.DistinguishedName;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jxta.security.cipher.Cipher;
import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.cipher.KeyBuilder;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.util.URLBase64;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.PeerCerts;
import org.apache.log4j.Category;

public class JTlsUtil {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$JTlsUtil == null ? (class$net$jxta$impl$endpoint$tls$JTlsUtil = JTlsUtil.class$("net.jxta.impl.endpoint.tls.JTlsUtil")) : class$net$jxta$impl$endpoint$tls$JTlsUtil).getName());
    static final int SALTSIZE = 8;
    static final int PASSES = 11;
    static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsUtil;

    public static void removeElements(Message jmsg) {
        MessageElementEnumeration e = jmsg.getElements();
        while (e.hasMoreElements()) {
            MessageElement elt1 = (MessageElement)e.nextElement();
            jmsg.removeElement(elt1);
        }
    }

    public static MessageElement getNextElement(Message m, MessageElement elt) {
        MessageElementEnumeration e = ((MessageImpl)m).getElementsInFifoOrder();
        boolean theNext = false;
        while (e.hasMoreElements()) {
            MessageElement elt1 = (MessageElement)e.nextElement();
            if (elt == null || theNext) {
                return elt1;
            }
            if (elt != elt1) continue;
            theNext = true;
        }
        return null;
    }

    public static int getMessageLength(Message m) {
        int length = 4;
        ++length;
        length += 2;
        MessageElementEnumeration els = ((MessageImpl)m).getElementsInFifoOrder();
        while (els.hasMoreElements()) {
            MessageElement el = (MessageElement)els.nextElement();
            length += 4;
            ++length;
            ++length;
            String[] names = MessageElement.parseName(el.getName());
            String namespace = names[0];
            String name = names[1];
            length += JTlsUtil.stringLength(names[1]);
            MimeMediaType type = el.getType();
            if (type != null) {
                length += JTlsUtil.stringLength(type.toString());
            }
            length += 4;
            length += el.getLength();
        }
        return length;
    }

    private static int stringLength(String str) {
        int strlen = 2;
        try {
            byte[] b = str.getBytes("UTF8");
            strlen += b.length;
        }
        catch (IOException uex) {
            System.out.println("JXTATLSutil.stringLength: " + uex.getMessage());
            strlen += str.length();
        }
        return strlen;
    }

    /*
     * Unable to fully structure code
     */
    public static short[] parseCipherSuites(String suites) throws ArrayIndexOutOfBoundsException {
        block5: {
            t = new StringTokenizer(suites, ":", false);
            v = new Vector<Integer>();
            try {
                while (true) {
                    if ((num = SSLPolicyInt.getCipherSuiteNumber((String)(tok = t.nextToken()))) <= -1) {
                        continue;
                    }
                    v.addElement(new Integer(num));
                }
            }
            catch (NoSuchElementException e) {
                if (v.size() <= 0) break block5;
                retval = new short[v.size()];
                i = 0;
                ** while (i < v.size())
            }
lbl-1000:
            // 1 sources

            {
                x = (Integer)v.elementAt(i);
                retval[i] = x.shortValue();
                ++i;
                continue;
            }
lbl18:
            // 1 sources

            return retval;
        }
        return null;
    }

    public static String getPCEPath() {
        String path = JTlsDefs.PCEDIR + File.separator;
        File dir = new File(path);
        dir.mkdirs();
        return path;
    }

    public static String getPCERootPath() {
        String path = JTlsUtil.getPCEPath() + "root" + File.separator;
        new File(path).mkdirs();
        return path;
    }

    public static String getPCEClientPath() {
        String path = JTlsUtil.getPCEPath() + File.separator + "client" + File.separator;
        new File(path).mkdirs();
        return path;
    }

    public static String getPCEPasswdPath() {
        String path = JTlsUtil.getPCEPath() + File.separator + "etc" + File.separator;
        new File(path).mkdirs();
        return path;
    }

    public static String readPassPhrase(String path, String password) throws IOException {
        File f = new File(path);
        int size = (int)f.length();
        byte[] ciphertext = new byte[size];
        FileInputStream fr = new FileInputStream(f);
        fr.read(ciphertext, 0, size);
        fr.close();
        byte[] plaintext = null;
        try {
            plaintext = JTlsUtil.tlsCipher(ciphertext, password, (byte)2);
        }
        catch (CryptoException e) {
            throw new IOException("Could not decrypt " + path);
        }
        File tmp = File.createTempFile("yyj", null);
        FileOutputStream fout = new FileOutputStream(tmp);
        fout.write(plaintext, 0, plaintext.length);
        fout.close();
        FileReader ff = new FileReader(tmp);
        BufferedReader br = new BufferedReader(ff);
        byte[] str64 = WrappedObject.loadObject((BufferedReader)br, (String)"PASSPHRASE", null);
        br.close();
        tmp.delete();
        return new String(str64);
    }

    public static byte[] tlsCipher(byte[] data, String password, byte mode) throws CryptoException {
        JxtaCryptoSuite suite = new JxtaCryptoSuite(1, null, 0, 0);
        Cipher rc4 = suite.getJxtaCipher();
        SecretKey k1 = (SecretKey)KeyBuilder.buildKey((byte)8, (short)128, (boolean)false);
        byte[] pbytes = password.getBytes();
        byte[] forkey = new byte[16];
        int i = 0;
        int j = 0;
        while (i < forkey.length) {
            forkey[i] = pbytes[j++];
            if (j == pbytes.length) {
                j = 0;
            }
            ++i;
        }
        k1.setKey(forkey, 0);
        byte[] obuf = new byte[data.length];
        rc4.init((Key)k1, mode);
        rc4.doFinal(data, 0, data.length, obuf, 0);
        return obuf;
    }

    public static String loadObject(BufferedReader rdr, String end) throws IOException {
        if (JTlsUtil.findObject(rdr, end)) {
            return JTlsUtil.readBlock(rdr);
        }
        return null;
    }

    public static boolean findObject(BufferedReader br, String end) throws IOException {
        String line;
        String postfix;
        String prefix = "-----BEGIN ";
        String string = postfix = end == null ? "-----" : end + "-----";
        do {
            if ((line = br.readLine()) != null) continue;
            return false;
        } while (!line.startsWith(prefix) || !line.endsWith(postfix));
        return true;
    }

    public static String readBlock(BufferedReader br) throws IOException {
        String line;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter ow = new OutputStreamWriter(bos);
        while ((line = br.readLine()) != null && !line.startsWith("-----END ")) {
            ow.write(line, 0, line.length());
            ow.write(10);
        }
        ow.flush();
        byte[] b64data = bos.toByteArray();
        return new String(b64data);
    }

    public static void writeBase64Object(String object, String type, BufferedWriter out) throws IOException {
        String start = "-----BEGIN " + type + "-----";
        out.write(start);
        out.newLine();
        out.write(object);
        String finish = "-----END " + type + "-----";
        out.write(finish);
        out.newLine();
        out.flush();
    }

    public static void writeRootCert(String cert, String path) throws IOException {
        FileWriter fw = new FileWriter(path);
        BufferedWriter bw = new BufferedWriter(fw);
        JTlsUtil.writeBase64Object(cert, "CERTIFICATE", bw);
        fw.close();
    }

    public static boolean verifySignedCert(String root, String cert) {
        try {
            String[] args = new String[]{root, cert};
            CertVerify.main((String[])args);
        }
        catch (Exception e) {
            if (SSLDebug.getDebug((int)128)) {
                System.out.println("Exception: " + e.getMessage() + "\n  Cannot verify cert =" + cert + "\n  Root = " + root);
            }
            return false;
        }
        return true;
    }

    public static boolean passwdExists() {
        String path = JTlsUtil.getPCEPasswdPath();
        File f = new File(path);
        try {
            String pwfile;
            File g;
            if (f.exists() && (g = new File(pwfile = path + "passwd")).exists()) {
                return true;
            }
        }
        catch (SecurityException s) {
            LOG.debug((Object)"passwdExists, exception:", (Throwable)s);
            return false;
        }
        return false;
    }

    public static boolean validPasswd(String passwd) {
        if (JTlsUtil.passwdExists()) {
            String pwd = null;
            try {
                pwd = JTlsUtil.getPasswordEntry();
            }
            catch (IOException e) {
                LOG.debug((Object)"validPasswd:", (Throwable)e);
                return false;
            }
            int index = pwd.indexOf(44);
            String salt64 = pwd.substring(0, index);
            String thePwd = pwd.substring(index + 1);
            byte[] sb64 = salt64.getBytes();
            byte[] salt = null;
            try {
                salt = URLBase64.decode((byte[])sb64, (int)0, (int)sb64.length);
            }
            catch (CryptoException e) {
                LOG.debug((Object)"validPasswd:", (Throwable)e);
                return false;
            }
            String generated = null;
            try {
                generated = JTlsUtil.makePasswdEntry(passwd, salt);
            }
            catch (IOException e) {
                LOG.debug((Object)"validPasswd:", (Throwable)e);
                return false;
            }
            int gindex = generated.indexOf(44);
            String genPwd = generated.substring(gindex + 1);
            return genPwd.compareTo(thePwd) == 0;
        }
        return false;
    }

    public static void createPasswdFile(String password, boolean overwrite) throws SecurityException, IOException {
        if (!overwrite && JTlsUtil.passwdExists()) {
            throw new SecurityException("Cannot create password file. It already exists.");
        }
        String path = JTlsUtil.getPCEPasswdPath();
        File f = new File(path);
        File g = new File(path + "passwd");
        if (f.exists()) {
            if (g.exists()) {
                g.delete();
            }
        } else {
            f.mkdir();
        }
        String pwdentry = JTlsUtil.makePasswdEntry(password, null);
        FileWriter fw = new FileWriter(g);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(pwdentry, 0, pwdentry.length());
        bw.newLine();
        bw.flush();
        bw.close();
    }

    public static String getPasswordEntry() throws IOException {
        String path = JTlsUtil.getPCEPasswdPath() + "passwd";
        FileReader f = new FileReader(path);
        BufferedReader bis = new BufferedReader(f);
        String entry = bis.readLine();
        return entry;
    }

    public static String makePasswdEntry(String passwd, byte[] useThisSalt) throws IOException {
        byte[] salt = null;
        if (useThisSalt == null) {
            SecureRandom rng = null;
            try {
                rng = PeerCerts.seedSRN();
            }
            catch (CryptoException cex) {
                return null;
            }
            salt = new byte[8];
            rng.nextBytes(salt);
        } else {
            salt = useThisSalt;
        }
        byte[] str64 = null;
        byte[] buf = null;
        try {
            JxtaCryptoSuite suite = new JxtaCryptoSuite(4, null, 0, 0);
            Hash sha1 = suite.getJxtaHash((byte)1);
            int diglen = sha1.getDigestLength();
            byte[] digest = new byte[diglen];
            byte[] pbytes = passwd.getBytes();
            int pwlen = passwd.length() + 8;
            int buflen = pwlen < diglen ? diglen : pwlen;
            buf = new byte[buflen];
            System.arraycopy(salt, 0, buf, 0, 8);
            System.arraycopy(pbytes, 0, buf, 8, pbytes.length);
            int len = pwlen;
            int i = 0;
            while (i <= 11) {
                sha1.doFinal(buf, 0, len, digest, 0);
                System.arraycopy(digest, 0, buf, 0, digest.length);
                len = digest.length;
                ++i;
            }
            str64 = URLBase64.encode((byte[])digest);
        }
        catch (CryptoException cex) {
            throw new IOException("makePasswdEntry: Cannot generate password file");
        }
        byte[] salt64 = URLBase64.encode((byte[])salt);
        String saltStr = new String(salt64);
        String pwdStr = new String(str64);
        return new String(saltStr + "," + pwdStr);
    }

    public static boolean principalIsIssuer(String principal) {
        String rootfile = JTlsUtil.getPCERootPath() + "peer-root.pem";
        try {
            byte[] cert_ber = CertVerify.loadCert((String)rootfile);
            X509Cert cert = new X509Cert(cert_ber);
            DistinguishedName issuer = cert.getIssuerName();
            String name = issuer.getNameString();
            int cn = name.indexOf(principal);
            if (cn != -1 && cn >= 3) {
                String fstr;
                String cnstr = name.substring(cn - 3, cn);
                if (cnstr.compareTo("CN=") != 0) {
                    return false;
                }
                int endc = cn + principal.length();
                String endStr = name.substring(endc, endc + 3);
                if (endStr.compareTo("-CA") == 0 && (fstr = name.substring(cn, endc)).compareTo(principal) == 0) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            SSLDebug.debug((int)128, (String)("Exception validating principal:" + e.getMessage()));
            return false;
        }
    }

    static int getSequenceNumber(MessageElement elt) throws NumberFormatException {
        String[] names = MessageElement.parseName(elt.getName());
        String namespace = names[0];
        String sequenceStr = names[1];
        Integer i = new Integer(sequenceStr);
        return i;
    }

    public static String toHex(byte[] arr, int offset, int len) {
        StringBuffer str = new StringBuffer();
        int i = offset;
        while (i < len) {
            if (i > 0 && i % 12 == 0) {
                str.append("\n");
            }
            str.append(hex[arr[i] >> 4 & 0xF]);
            str.append(hex[arr[i] & 0xF]);
            str.append(" ");
            ++i;
        }
        return str.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

