/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLSocket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatBinary;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class JTlsOutputStream
extends OutputStream {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$JTlsOutputStream == null ? (class$net$jxta$impl$endpoint$tls$JTlsOutputStream = JTlsOutputStream.class$("net.jxta.impl.endpoint.tls.JTlsOutputStream")) : class$net$jxta$impl$endpoint$tls$JTlsOutputStream).getName());
    private MessageElement sentMelt = null;
    private MessageWireFormat wFout = new MessageWireFormatBinary(JTlsDefs.MTYPE);
    private int sequenceNumber = 0;
    private EndpointAddress destAddr = null;
    private TlsTransport tp = null;
    private TlsConn conn = null;
    private long aveRTT = 0L;
    private int nACKS = 0;
    long RTO = 0L;
    long minRTO = 0L;
    long maxRTO = 0L;
    private long lastACKTime = 0L;
    private static final long initRTT = 1000L;
    private static final long ONEMINUTE = 60000L;
    private static final int RETRMAXAGE = 10;
    private static final int MAXRETRQSIZE = 100;
    private int nIQTests = 0;
    private int aveIQSize = 0;
    private int mrrIQFreeSpace = 0;
    private int rmaxQSize = 0;
    private static final int RWINDOW = 5;
    Retransmitter retrThread = null;
    long sackRetransTime = 0L;
    static final boolean testRetrans = false;
    private OutputStream plaintext_out = null;
    static final int BOSIZE = 16000;
    Vector retrQ = new Vector(10, 1);
    private static final byte[] MARKText = new byte[]{84, 76, 83, 82, 69, 84};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsOutputStream;

    public JTlsOutputStream(TlsConn conn, TlsTransport tp, EndpointAddress destAddr) {
        this.setupJxtaMsgs();
        this.conn = conn;
        this.tp = tp;
        this.destAddr = destAddr;
        this.aveRTT = 1000L;
        this.RTO = this.minRTO = 1000L;
        this.maxRTO = 5L * this.minRTO;
        this.rmaxQSize = this.mrrIQFreeSpace = conn.jin.getMaxIQSize();
        this.lastACKTime = System.currentTimeMillis();
        this.retrThread = new Retransmitter();
    }

    private void setupJxtaMsgs() {
        this.wFout = new MessageWireFormatBinary(JTlsDefs.MTYPE);
        this.sequenceNumber = 1;
        this.sentMelt = null;
    }

    public void setPlaintextOutputStream(SSLSocket s) {
        this.plaintext_out = s.getOutputStream();
    }

    public OutputStream getPlaintextOutputStream() {
        return this.plaintext_out;
    }

    public synchronized void writeMessage(Message wmsg) throws IOException {
        BufferedOutputStream bo = new BufferedOutputStream(this.plaintext_out, 16000);
        this.wFout.writeMessage(bo, wmsg);
        bo.flush();
    }

    public void write(int c) throws IOException {
        byte[] a = new byte[]{(byte)(c & 0xFF)};
        this.write(a, 0, 1);
    }

    public synchronized void write(byte[] b, int offset, int length) throws IOException {
        byte[] data = new byte[length];
        System.arraycopy(b, offset, data, 0, length);
        String names = "jxtatls:" + this.sequenceNumber;
        MessageImpl jmsg = new MessageImpl();
        this.sentMelt = jmsg.newMessageElement(names, null, data, 0, length);
        jmsg.addElement(this.sentMelt);
        int maxwait = this.aveRTT < 200L ? (int)this.aveRTT : 200;
        int waitCt = maxwait / 60;
        if (waitCt < 1) {
            waitCt = 1;
        }
        int i = 0;
        while (this.mrrIQFreeSpace < this.rmaxQSize / 5 || this.retrQ.size() > this.rmaxQSize) {
            if (i++ == waitCt) {
                if (!LOG.isEnabledFor(Priority.INFO)) break;
                LOG.info((Object)"write() wait for ACK, maxwait timer expired");
                break;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("write() wait for ACK, remote IQ size = " + this.mrrIQFreeSpace));
                LOG.info((Object)("    MIN to continue = " + this.rmaxQSize / 5));
                LOG.info((Object)("    retQ.size() = " + this.retrQ.size()));
            }
            try {
                Thread.currentThread();
                Thread.sleep(60L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!LOG.isEnabledFor(Priority.INFO)) continue;
            LOG.info((Object)("write() woke up, remote IQ size = " + this.mrrIQFreeSpace));
        }
        this.retransEnqueue(this.sequenceNumber, (Message)jmsg.clone());
        this.tp.sendToRemoteTls(this.destAddr, jmsg);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! TLS Record sent, len = " + length + " Seq# = " + this.sequenceNumber));
            if (this.sequenceNumber < 6) {
                String hex = JTlsUtil.toHex(b, offset, length);
                LOG.info((Object)("HexDump:\n" + hex));
            }
        }
        ++this.sequenceNumber;
    }

    private synchronized void retransEnqueue(int seqN, Message msg) {
        RetrQElt r = new RetrQElt(seqN, msg);
        this.retrQ.add(r);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! retrans Enqueue, size = " + this.retrQ.size() + ", added seq#" + seqN));
        }
    }

    private int retrQfirstEntryAgeMins() {
        if (this.retrQ.size() == 0) {
            return 0;
        }
        RetrQElt r = (RetrQElt)this.retrQ.elementAt(0);
        long msage = System.currentTimeMillis() - r.enqueuedAt;
        int minage = (int)(msage / 60000L);
        return minage;
    }

    private void calcRTT(long enqueuedAt) {
        long dt = System.currentTimeMillis() - enqueuedAt;
        if (dt == 0L) {
            ++dt;
        }
        int n = this.nACKS++;
        this.aveRTT = ((long)n * this.aveRTT + dt) / (long)this.nACKS;
        this.RTO = (this.aveRTT << 1) + (this.aveRTT >> 1);
        if (this.RTO < this.minRTO) {
            this.RTO = this.minRTO;
        } else if (this.RTO > this.maxRTO) {
            this.RTO = this.maxRTO;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! RTT = " + dt + " aveRTT = " + this.aveRTT + "ms" + " RTO = " + this.RTO));
        }
    }

    private Vector sortSackList(String slist) {
        Vector<Integer> v = new Vector<Integer>(1, 1);
        while (slist != null) {
            Integer i_seqnum = new Integer(0);
            int i1 = slist.indexOf(",");
            if (i1 == -1) {
                i_seqnum = new Integer(slist);
                slist = null;
            } else {
                String s = slist.substring(0, i1);
                i_seqnum = new Integer(s);
                slist = slist.substring(i1 + 1);
            }
            boolean inserted = false;
            int i = 0;
            while (i < v.size()) {
                if (i_seqnum.compareTo((Integer)v.elementAt(i)) < 0) {
                    v.insertElementAt(i_seqnum, i);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (inserted) continue;
            v.add(i_seqnum);
        }
        return v;
    }

    private int callAVEIQ(int iq) {
        int n = this.nIQTests++;
        this.aveIQSize = (n * this.aveIQSize + iq) / this.nIQTests;
        return this.aveIQSize;
    }

    synchronized void ackReceived(int seqnum, String sackList) {
        this.lastACKTime = System.currentTimeMillis();
        int n = 0;
        int i = this.retrQ.size();
        Vector sacs = null;
        int rqLen = 1;
        if (sackList != null) {
            sacs = this.sortSackList(sackList);
            rqLen = sacs.size();
        }
        this.mrrIQFreeSpace = this.rmaxQSize - rqLen;
        if (i == 0) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TLS!! RETRANS Q EMPTY");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! RETRQ(SIZE = " + i + "):"));
            int y = 0;
            while (y < i) {
                RetrQElt r = (RetrQElt)this.retrQ.elementAt(y);
                LOG.info((Object)("r(" + y + ")=" + r.seqnum));
                ++y;
            }
        }
        long enqueuetime = 0L;
        while (this.retrQ.size() > 0) {
            RetrQElt r = (RetrQElt)this.retrQ.elementAt(0);
            if (r.seqnum > seqnum) break;
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TLS!! SEQUENTIALLY ACKD SEQN = " + r.seqnum));
            }
            this.retrQ.remove(0);
            JTlsUtil.removeElements(r.msg);
            enqueuetime = r.enqueuedAt;
            if (enqueuetime != 0L) {
                this.calcRTT(enqueuetime);
            }
            r.msg = null;
            r = null;
            ++n;
        }
        if (sackList != null) {
            RetrQElt r;
            int j = 0;
            int l = 0;
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("SACK Vector(" + sackList + "):"));
                int z = 0;
                while (z < sacs.size()) {
                    LOG.info((Object)("v(" + z + ")=" + (Integer)sacs.elementAt(z)));
                    ++z;
                }
            }
            int sacnum = 0;
            while (l < sacs.size() && this.retrQ.size() > 0) {
                sacnum = (Integer)sacs.elementAt(l++);
                boolean ackedMsg = false;
                int k = j;
                while (k < this.retrQ.size()) {
                    r = (RetrQElt)this.retrQ.elementAt(k);
                    if (r.seqnum == sacnum) {
                        this.retrQ.remove(k);
                        j = k;
                        ++n;
                        enqueuetime = r.enqueuedAt;
                        if (enqueuetime != 0L) {
                            this.calcRTT(enqueuetime);
                        }
                        JTlsUtil.removeElements(r.msg);
                        r.msg = null;
                        r = null;
                        if (LOG.isEnabledFor(Priority.INFO)) {
                            LOG.info((Object)("TLS!! SACKD SEQN = " + sacnum));
                        }
                        ackedMsg = true;
                        break;
                    }
                    ++k;
                }
                if (ackedMsg || !LOG.isEnabledFor(Priority.INFO)) continue;
                LOG.info((Object)("TLS!! Duplicate SACK = " + sacnum));
            }
            int remoteIQ = sacs.size();
            int aveIQ = this.callAVEIQ(remoteIQ);
            if (this.retrQ.size() > 0) {
                r = (RetrQElt)this.retrQ.elementAt(0);
                if (seqnum < sacnum && r.seqnum < sacnum) {
                    int ackwin = 1;
                    int upper = 5 < this.retrQ.size() ? 5 : this.retrQ.size();
                    i = 1;
                    while (i < upper) {
                        r = (RetrQElt)this.retrQ.elementAt(i);
                        if (r.seqnum >= sacnum) break;
                        ++ackwin;
                        ++i;
                    }
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("RETR: Fill hole, SACK, Seqnum = " + seqnum + ", Max seqnum = " + sacnum + ", Window =" + ackwin));
                    }
                    this.retransmit(ackwin);
                    this.sackRetransTime = System.currentTimeMillis();
                }
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! N ACKED = " + n));
        }
    }

    private void markRetransmit(Message msg) {
        MessageElement elt = msg.newMessageElement("jxtatls:MARKRetr", null, MARKText, 0, MARKText.length);
        msg.addElement(elt);
    }

    synchronized int retransmit(int rwin) {
        int i;
        int i0 = i = this.retrQ.size() < rwin ? this.retrQ.size() : rwin;
        if (i > 0 && LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! RETRANSMITING [rwindow = " + i0 + "]:"));
        }
        int n = 0;
        int j = 0;
        while (j < i) {
            block6: {
                RetrQElt r = (RetrQElt)this.retrQ.elementAt(j);
                try {
                    if (!r.marked) {
                        this.markRetransmit(r.msg);
                        r.marked = true;
                    }
                    Message cmsg = (Message)r.msg.clone();
                    this.tp.sendToRemoteTls(this.destAddr, cmsg);
                    ++n;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("TLS!! RETRANSMIT SEQN = " + r.seqnum));
                    }
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor(Priority.INFO)) break block6;
                    LOG.info((Object)("TLS!! IOErr while RETRANS SEQN = " + r.seqnum));
                }
            }
            ++j;
        }
        return n;
    }

    void triggerRetransmission() {
        long realWait = System.currentTimeMillis() - this.lastACKTime;
        if (realWait >= this.RTO + this.minRTO) {
            this.retransmit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Retransmitter
    implements Runnable {
        Thread th = new Thread((Runnable)this, "TLS Retransmit thread");
        int nretransmitted = 0;
        int nAtThisRTO = 0;

        public Retransmitter() {
            this.th.setDaemon(true);
            this.th.start();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TLS!! STARTED TLS Retransmit thread, RTO = " + JTlsOutputStream.this.RTO));
            }
        }

        public int getRetransCount() {
            return this.nretransmitted;
        }

        public void run() {
            int idleCounter = 0;
            JTlsOutputStream.this.sackRetransTime = System.currentTimeMillis();
            while (true) {
                try {
                    Thread.currentThread();
                    Thread.sleep(JTlsOutputStream.this.RTO);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long lastSackRetr = System.currentTimeMillis() - JTlsOutputStream.this.sackRetransTime;
                if (lastSackRetr < JTlsOutputStream.this.RTO) {
                    if (!LOG.isEnabledFor(Priority.INFO)) continue;
                    LOG.info((Object)("RETR: No retrans, sack retrans " + lastSackRetr + " ms ago"));
                    continue;
                }
                long realWait = System.currentTimeMillis() - JTlsOutputStream.this.lastACKTime;
                long oldestWait = 0L;
                if (JTlsOutputStream.this.retrQ.size() > 0) {
                    oldestWait = System.currentTimeMillis() - ((RetrQElt)JTlsOutputStream.this.retrQ.elementAt((int)0)).enqueuedAt;
                }
                long l = realWait = realWait < oldestWait ? oldestWait : realWait;
                if (realWait >= JTlsOutputStream.this.RTO && oldestWait >= JTlsOutputStream.this.RTO) {
                    int i = JTlsOutputStream.this.retransmit(5);
                    this.nretransmitted += i;
                    this.nAtThisRTO += i == 0 ? 0 : i;
                    if (i > 0 && realWait >= 2L * JTlsOutputStream.this.RTO && this.nAtThisRTO >= 10) {
                        JTlsOutputStream.this.RTO = realWait > JTlsOutputStream.this.maxRTO ? JTlsOutputStream.this.maxRTO : 2L * JTlsOutputStream.this.RTO;
                        this.nAtThisRTO = 0;
                    }
                    if (!LOG.isEnabledFor(Priority.INFO)) continue;
                    LOG.info((Object)("TLS!! RETR: RTO(" + this.nAtThisRTO + ") = " + JTlsOutputStream.this.RTO + " N RETRANS = " + i));
                    continue;
                }
                if (++idleCounter == 2) {
                    JTlsOutputStream.this.RTO = JTlsOutputStream.this.minRTO;
                    idleCounter = 0;
                }
                if (!LOG.isEnabledFor(Priority.INFO)) continue;
                LOG.info((Object)("TLS!! RETR IDLE: RTO = " + JTlsOutputStream.this.RTO + " WAIT = " + realWait));
            }
        }
    }

    private class RetrQElt {
        int seqnum;
        long enqueuedAt;
        Message msg;
        boolean marked;

        public RetrQElt(int seqnum, Message msg) {
            this.seqnum = seqnum;
            this.msg = msg;
            this.enqueuedAt = System.currentTimeMillis();
            this.marked = false;
        }
    }
}

