/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

public class Header {
    public byte cmd;
    public byte[] srcAddr = new byte[4];
    public int srcPort;
    public int size;
    public int option;
    public int packetId;
    public static int length = 20;
    public static final int PROPAGATE = 1;
    public static final int UNICAST = 2;
    public static final int ACK = 3;
    public static final int NACK = 4;
    public static final int HANDCHECK = 1;
    public static final int NONBLOCKING = 2;

    private static void htonl(int v, byte[] buffer, int offset) {
        buffer[offset] = (byte)((v & 0xFF000000) >> 24);
        buffer[offset + 1] = (byte)((v & 0xFF0000) >> 16);
        buffer[offset + 2] = (byte)((v & 0xFF00) >> 8);
        buffer[offset + 3] = (byte)(v & 0xFF);
    }

    private static void htons(int v, byte[] buffer, int offset) {
        buffer[offset] = (byte)((v & 0xFF00) >> 8);
        buffer[offset + 1] = (byte)(v & 0xFF);
    }

    private static int ntohl(byte[] buffer, int offset) {
        return buffer[offset] << 24 & 0xFF000000 | buffer[offset + 1] << 16 & 0xFF0000 | buffer[offset + 2] << 8 & 0xFF00 | buffer[offset + 3] & 0xFF;
    }

    private static int ntohs(byte[] buffer, int offset) {
        return buffer[offset] << 24 & 0xFF000000 | buffer[offset + 1] << 16 & 0xFF0000 | buffer[offset + 2] << 8 & 0xFF00 | buffer[offset + 3] & 0xFF;
    }

    public boolean initFromNetwork(byte[] buffer, int offset) {
        this.cmd = buffer[offset];
        if (this.cmd != 1 && this.cmd != 2 && this.cmd != 3 && this.cmd != 4) {
            return false;
        }
        this.srcAddr[0] = buffer[offset + 1];
        this.srcAddr[1] = buffer[offset + 2];
        this.srcAddr[2] = buffer[offset + 3];
        this.srcAddr[3] = buffer[offset + 4];
        this.srcPort = Header.ntohs(buffer, offset + 5);
        this.size = Header.ntohl(buffer, offset + 7);
        this.option = buffer[offset + 11];
        this.packetId = Header.ntohl(buffer, offset + 12);
        return true;
    }

    public void buildForNetwork(byte[] buffer, int offset) {
        int tmpOffset = offset;
        buffer[tmpOffset++] = this.cmd;
        buffer[tmpOffset++] = this.srcAddr[0];
        buffer[tmpOffset++] = this.srcAddr[1];
        buffer[tmpOffset++] = this.srcAddr[2];
        buffer[tmpOffset++] = this.srcAddr[3];
        Header.htons(this.srcPort, buffer, tmpOffset);
        Header.htonl(this.size, buffer, tmpOffset += 2);
        tmpOffset += 4;
        buffer[tmpOffset++] = (byte)this.option;
        Header.htonl(this.packetId, buffer, tmpOffset);
        tmpOffset += 4;
    }
}

