/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpMessageReceiverServlet
extends HttpServlet
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet = HttpMessageReceiverServlet.class$("net.jxta.impl.endpoint.servlethttp.HttpMessageReceiverServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet).getName());
    private EndpointService endpoint = null;
    private static final int MAX_POST_CONTENT_LEN = 0xA00000;
    private EndpointReceiveQueue sendQueue = null;
    private Thread sendThread = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.endpoint = (EndpointService)this.getServletContext().getAttribute("endpoint");
            if (this.endpoint == null) {
                throw new ServletException("Servlet Context did not contain 'endpoint'");
            }
        }
        catch (ClassCastException e) {
            throw new ServletException("'endpoint' attribute was not of the proper type in the Servlet Context");
        }
        this.sendQueue = new EndpointReceiveQueue();
        this.sendThread = new Thread((Runnable)this, "HTTP Message Sender");
        this.sendThread.start();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uri = req.getRequestURI();
        if (uri.equals("/ping")) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  responding with 200 to ping request");
            }
            res.setStatus(200);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.validateMessage(req, res)) {
            String uri = req.getRequestURI();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("POSTed message is valid; uri=" + uri));
            }
            if (uri.equals("/")) {
                this.processMessage(req, res);
            }
        }
    }

    private boolean validateMessage(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int contentLen = req.getContentLength();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("HTTP POST received, Content-Length = " + contentLen));
        }
        if (contentLen <= 0 || contentLen > 0xA00000) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Rejected HTTP POST request; too long, not declared, or zero length; length=" + req.getContentLength()));
            }
            res.sendError(403, "Content-Length too long or not declared, or zero; max allowed is 10485760");
            return false;
        }
        return true;
    }

    private void processMessage(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processing posted message");
        }
        if (this.sendQueue.getNbOfQueuedMessages() == this.sendQueue.getMaxNbOfMessages()) {
            res.sendError(503, "Message queue is full, please try again later");
            return;
        }
        int contentLen = req.getContentLength();
        ServletInputStream in = req.getInputStream();
        try {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Constructing MessageImpl and calling EndpointService.demux()");
            }
            Message msg = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage((InputStream)in, msg);
            this.sendQueue.push(msg);
            Thread.yield();
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Malformed JXTA message, responding with BAD_REQUEST: ", (Throwable)e);
            }
            res.sendError(400, "Message was not a valid JXTA message");
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)" Sending OK in response to HTTP POST");
        }
        res.setStatus(200);
    }

    public void run() {
        Message msg = null;
        while (!this.sendQueue.isClosed()) {
            try {
                msg = this.sendQueue.waitForMessage();
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (msg == null) continue;
            try {
                this.endpoint.demux(msg);
            }
            catch (IOException ex) {
                if (!LOG.isEnabledFor(Priority.ERROR)) continue;
                LOG.error((Object)("Error sending message: " + ex));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

