/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.URL;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.servlethttp.HttpClientConnection;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessageSender;

public class HttpClientMessenger
implements EndpointMessenger {
    private URL url = null;
    private HttpClientMessageSender sender = null;
    private EndpointAddress destAddress = null;
    private EndpointAddress localAddress = null;

    public HttpClientMessenger(HttpClientMessageSender sender, URL url, EndpointAddress localAddress, EndpointAddress destAddress) throws IOException {
        this.sender = sender;
        this.url = url;
        this.destAddress = (EndpointAddress)destAddress.clone();
        this.localAddress = (EndpointAddress)localAddress.clone();
        HttpClientConnection conn = sender.getHttpClientConnection(url);
        if (conn == null) {
            throw new IOException();
        }
    }

    public void sendMessage(Message msg) throws IOException {
        msg.setDestinationAddress(this.destAddress);
        msg.setSourceAddress(this.localAddress);
        HttpClientConnection conn = this.sender.getHttpClientConnection(this.url);
        if (conn == null) {
            throw new IOException();
        }
        conn.sendMessage(msg);
    }

    public void close() {
    }
}

