/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.beep;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.document.Advertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.beep.BeepNonBlockingMessenger;
import net.jxta.impl.endpoint.beep.BeepSession;
import net.jxta.impl.endpoint.beep.JxtaBeepProfile;
import net.jxta.impl.protocol.BeepAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.transport.tcp.AutomatedTCPSessionCreator;
import org.beepcore.beep.transport.tcp.TCPSession;
import org.beepcore.beep.util.ConsoleLog;
import org.beepcore.beep.util.Log;
import org.beepcore.beep.util.LogService;

public class BeepTransport
implements EndpointProtocol {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$beep$BeepTransport == null ? (class$net$jxta$impl$endpoint$beep$BeepTransport = BeepTransport.class$("net.jxta.impl.endpoint.beep.BeepTransport")) : class$net$jxta$impl$endpoint$beep$BeepTransport).getName());
    private static final long PINGDELAY = 2000L;
    private EndpointService endpoint;
    private Advertisement implAdv;
    private BeepAdv beepAdv;
    private String localAddress;
    private InetAddress usingInterface;
    private int useTcpPort;
    private String publicAddress;
    private Address ourAddress;
    ProfileRegistry reg;
    HashMap activeSessions = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$beep$BeepTransport;

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] args) {
        return 1;
    }

    public void stopApp() {
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
        PeerAdvertisement configAdv = (PeerAdvertisement)group.getConfigAdvertisement();
        StructuredDocument param = configAdv.getServiceParam(assignedID);
        Enumeration beepChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
        if (beepChilds.hasMoreElements()) {
            this.beepAdv = (BeepAdv)beepChilds.nextElement();
        } else {
            beepChilds = param.getChildren(BeepAdv.getAdvertisementType());
            if (beepChilds.hasMoreElements()) {
                this.beepAdv = (BeepAdv)beepChilds.nextElement();
            }
        }
        this.useTcpPort = this.beepAdv.getPort();
        this.localAddress = this.beepAdv.getLocalAddress();
        this.publicAddress = this.beepAdv.getPublicAddress();
        try {
            this.usingInterface = this.localAddress == null || this.localAddress.equalsIgnoreCase("TBD") ? InetAddress.getLocalHost() : InetAddress.getByName(this.localAddress);
        }
        catch (UnknownHostException iDontExist) {
            throw new RuntimeException("Could not find IP address for local Host!");
        }
        if (this.publicAddress == null || this.publicAddress.equalsIgnoreCase("TBD")) {
            this.publicAddress = this.usingInterface.getHostAddress() + ":" + this.useTcpPort;
        }
        this.ourAddress = new Address();
        this.ourAddress.setProtocolName(this.getProtocolName());
        this.ourAddress.setProtocolAddress(this.publicAddress);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Configured  Beep Transport");
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("  Using Intf:" + this.usingInterface.getHostAddress()));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("  Using Port:" + this.useTcpPort));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("  Local Addr:" + this.ourAddress));
        }
        if (LOG.getChainedPriority().equals(Priority.DEBUG)) {
            ConsoleLog log = new ConsoleLog();
            log.setSeverity(8);
            Log.setLogService((LogService)log);
        }
        this.endpoint = group.getEndpointService();
        String classname = "net.jxta.impl.endpoint.beep.JxtaBeepProfile";
        this.reg = new ProfileRegistry();
        SessionTuningProperties tuning = new SessionTuningProperties();
        ProfileConfiguration profileConfig = new ProfileConfiguration();
        try {
            JxtaBeepProfile p;
            try {
                p = (JxtaBeepProfile)Class.forName(classname).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new Exception("Class " + classname + " cannot be constructed.");
            }
            catch (InstantiationException e) {
                throw new Exception("Class " + classname + " returned an error");
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Class " + classname + " not found");
            }
            catch (ClassCastException e) {
                throw new Exception("class " + classname + " does not " + "implement the org.beepcore.beep.profile.Profile interface");
            }
            p.SetEndpoint(this.endpoint);
            this.reg.addStartChannelListener("http://xml.resource.org/profiles/JXTA/Beep", p.init("http://xml.resource.org/profiles/JXTA/Beep", profileConfig), null);
        }
        catch (Exception caught) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"BeepTransport.init failure", (Throwable)caught);
            }
            return;
        }
        new IncomingBeepSeesionDaemon(this).start();
        new BeepSeesionIdleOutDaemon(this).start();
    }

    public EndpointMessenger getMessenger(EndpointAddress dst) throws IOException {
        if (!dst.getProtocolName().equals(this.getProtocolName())) {
            throw new IllegalArgumentException("Not a BEEP EndpointService address!");
        }
        String dstAddr = dst.getProtocolAddress();
        BeepSession dstSession = null;
        HashMap hashMap = this.activeSessions;
        synchronized (hashMap) {
            if (this.activeSessions.containsKey(dstAddr)) {
                dstSession = (BeepSession)this.activeSessions.get(dstAddr);
                dstSession.updateLastUsed();
            } else {
                dstSession = new BeepSession(this, dst);
                this.activeSessions.put(dstAddr, dstSession);
            }
        }
        return new BeepNonBlockingMessenger(dstSession);
    }

    public synchronized void propagate(Message message, String pName, String pParams, String prunePeer) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"propagate not supported");
        }
    }

    public String getProtocolName() {
        return BeepTransport.getSupportedProtocolName();
    }

    public static String getSupportedProtocolName() {
        return "BEEP";
    }

    public void close() {
        HashMap hashMap = this.activeSessions;
        synchronized (hashMap) {
            Iterator eachActive = this.activeSessions.values().iterator();
            while (eachActive.hasNext()) {
                BeepSession session = (BeepSession)eachActive.next();
                session.close();
                session = null;
                eachActive.remove();
            }
        }
        this.activeSessions = null;
    }

    public EndpointAddress getPublicAddress() {
        return this.ourAddress;
    }

    public boolean allowRouting() {
        return true;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean ping(EndpointAddress addr) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("ping to " + addr.toString()));
        }
        boolean res = true;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("ping (always) returns " + res));
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BeepSeesionIdleOutDaemon
    extends Thread {
        private static final int POLLINGINTERVAL = 10;
        private static final int IDLEINTERVAL = 120;
        private BeepTransport ourMaster;

        BeepSeesionIdleOutDaemon(BeepTransport ourMaster) {
            super("BeepTransport Session Idle Closer Daemon : " + ourMaster.toString());
            this.ourMaster = ourMaster;
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"BeepSeesionIdleOutDaemon.run");
            }
            while (true) {
                try {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"BeepSeesionIdleOutDaemon polling for idle session");
                    }
                    HashMap woken = this.ourMaster.activeSessions;
                    synchronized (woken) {
                        Iterator eachSession = this.ourMaster.activeSessions.values().iterator();
                        while (eachSession.hasNext()) {
                            BeepSession aSession = (BeepSession)eachSession.next();
                            if (aSession.getLastUsed() + 120000L > System.currentTimeMillis()) continue;
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Closing session with " + aSession.getDestEndpoint()));
                            }
                            eachSession.remove();
                            aSession.close();
                            Object var3_5 = null;
                        }
                    }
                }
                catch (Throwable e) {
                    if (LOG.isEnabledFor(Priority.FATAL)) {
                        LOG.fatal((Object)("Uncaught Throwable, Listener " + Thread.currentThread().getName() + " exiting"), e);
                    }
                    return;
                }
            }
        }
    }

    private class IncomingBeepSeesionDaemon
    extends Thread {
        private BeepTransport ourMaster;

        IncomingBeepSeesionDaemon(BeepTransport ourMaster) {
            super("BeepTransport Incoming Session Daemon : " + ourMaster.toString());
            this.ourMaster = ourMaster;
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("IncomingBeepSeesionDaemon.run starting listener - " + this.ourMaster.usingInterface.getHostAddress() + ":" + this.ourMaster.useTcpPort));
            }
            while (true) {
                try {
                    TCPSession session = AutomatedTCPSessionCreator.listen((InetAddress)this.ourMaster.usingInterface, (int)this.ourMaster.useTcpPort, (ProfileRegistry)this.ourMaster.reg);
                    HashMap hashMap = this.ourMaster.activeSessions;
                    synchronized (hashMap) {
                        BeepSession newSession = new BeepSession(this.ourMaster, (Session)session);
                        this.ourMaster.activeSessions.put(newSession.getDestEndpoint(), newSession);
                        continue;
                    }
                }
                catch (BEEPException e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("Listener exception : " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    block8: {
                        if (!LOG.isEnabledFor(Priority.FATAL)) break block8;
                        LOG.fatal((Object)("Uncaught Throwable, Listener " + Thread.currentThread().getName() + " exiting"), e);
                    }
                    return;
                }
                break;
            }
        }
    }
}

