/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.beep;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.beep.BeepTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionEvent;
import org.beepcore.beep.core.SessionEventListener;
import org.beepcore.beep.lib.ChannelPool;
import org.beepcore.beep.lib.SharedChannel;
import org.beepcore.beep.transport.tcp.AutomatedTCPSessionCreator;
import org.beepcore.beep.transport.tcp.TCPSession;

class BeepSession
implements SessionEventListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$beep$BeepSession == null ? (class$net$jxta$impl$endpoint$beep$BeepSession = BeepSession.class$("net.jxta.impl.endpoint.beep.BeepSession")) : class$net$jxta$impl$endpoint$beep$BeepSession).getName());
    private static final int CHANNEL_IDLE_TTL = 30000;
    private BeepTransport tpt;
    private EndpointAddress dst;
    private InetAddress host;
    private int port = 0;
    private Session session;
    private long lastUsed;
    private ChannelPool channels;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$beep$BeepSession;

    BeepSession(BeepTransport tpt, EndpointAddress dest) throws IOException {
        this.tpt = tpt;
        this.dst = (EndpointAddress)((Address)dest).clone();
        try {
            String tmp = this.dst.getProtocolAddress();
            int portIndex = tmp.indexOf(":");
            if (portIndex == -1) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Port missing!");
                }
                throw new IllegalArgumentException("Port missing!");
            }
            this.port = Integer.valueOf(tmp.substring(portIndex + 1));
            this.host = InetAddress.getByName(tmp.substring(0, portIndex));
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)(" using: " + this.host.toString() + ":" + this.port));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"construct failed", (Throwable)e);
            }
            throw new UndeclaredThrowableException(e);
        }
        try {
            this.session = AutomatedTCPSessionCreator.initiate((InetAddress)this.host, (int)this.port, (ProfileRegistry)tpt.reg);
        }
        catch (BEEPException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Error connecting to " + this.host + ":" + this.port + "\n\t" + e.getMessage()), (Throwable)e);
            }
            throw new IOException("Connection Refused by " + this.host + ":" + this.port);
        }
        this.constructorCommon();
    }

    BeepSession(BeepTransport tpt, Session session) {
        this.tpt = tpt;
        this.session = session;
        this.dst = new Address();
        this.dst.setProtocolName(tpt.getProtocolName());
        if (session instanceof TCPSession) {
            Socket socket = ((TCPSession)session).getSocket();
            this.host = socket.getInetAddress();
            this.port = socket.getPort();
            this.dst.setProtocolAddress(this.host.getHostAddress() + ":" + Integer.toString(this.port));
        }
        this.constructorCommon();
    }

    private void constructorCommon() {
        this.updateLastUsed();
        this.channels = new ChannelPool(this.session, 30000L);
        this.session.registerForEvent((SessionEventListener)this, 5);
        this.session.registerForEvent((SessionEventListener)this, 6);
    }

    void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    long getLastUsed() {
        return this.lastUsed;
    }

    boolean isActive() {
        int state = null == this.session ? 8 : this.session.getState();
        return state == 7;
    }

    EndpointAddress getDestEndpoint() {
        return (EndpointAddress)((Address)this.dst).clone();
    }

    EndpointAddress getSrcEndpoint() {
        return this.tpt.getPublicAddress();
    }

    Channel getNewChannel() {
        SharedChannel channel;
        this.updateLastUsed();
        try {
            channel = this.channels.getSharedChannel("http://xml.resource.org/profiles/JXTA/Beep");
        }
        catch (BEEPException caught) {
            throw new RuntimeException("BEEPException - no docs, didnt know what to do");
        }
        return channel;
    }

    void releaseChannel(Channel channel) {
        SharedChannel mine = (SharedChannel)channel;
        mine.release();
    }

    void close() {
        this.channels = null;
        try {
            this.session.close();
        }
        catch (BEEPException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Error closing session (" + e.getMessage() + ")"));
            }
            return;
        }
        this.session = null;
    }

    public void receiveEvent(SessionEvent sessionEvent) {
        int event = sessionEvent.getEvent();
        switch (event) {
            case 1: {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("Session : " + this.session.toString() + " GREETING_SENT_EVENT_CODE"));
                break;
            }
            case 2: {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("Session : " + this.session.toString() + " GREETING_RECEIVED_EVENT_CODE"));
                break;
            }
            case 3: {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("Session : " + this.session.toString() + " CHANNEL_OPENED_EVENT_CODE"));
                break;
            }
            case 4: {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("Session : " + this.session.toString() + " CHANNEL_CLOSED_EVENT_CODE"));
                break;
            }
            case 5: {
                if (this.session == null) break;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Session : " + this.session.toString() + " SESSION_CLOSED_EVENT_CODE"));
                }
                HashMap hashMap = this.tpt.activeSessions;
                synchronized (hashMap) {
                    Iterator eachSession = this.tpt.activeSessions.values().iterator();
                    while (eachSession.hasNext()) {
                        if (this != eachSession.next()) continue;
                        eachSession.remove();
                        break;
                    }
                }
                this.session = null;
                this.channels = null;
                break;
            }
            case 6: {
                if (this.session == null) break;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Session : " + this.session.toString() + " SESSION_TERMINATED_EVENT_CODE"));
                }
                HashMap hashMap = this.tpt.activeSessions;
                synchronized (hashMap) {
                    Iterator eachSession = this.tpt.activeSessions.values().iterator();
                    while (eachSession.hasNext()) {
                        if (this != eachSession.next()) continue;
                        eachSession.remove();
                        break;
                    }
                }
                this.session = null;
                this.channels = null;
                break;
            }
            case 0: {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("Session : " + this.session.toString() + " UNKNOWN_EVENT_CODE"));
                break;
            }
            default: {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("Session : " + this.session.toString() + "UNKNOWN EVENT CODE - " + event));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

