/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.EndpointDemuxListener;
import net.jxta.impl.endpoint.EndpointServiceInterface;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointServiceImpl
implements EndpointService {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointServiceImpl == null ? (class$net$jxta$impl$endpoint$EndpointServiceImpl = EndpointServiceImpl.class$("net.jxta.impl.endpoint.EndpointServiceImpl")) : class$net$jxta$impl$endpoint$EndpointServiceImpl).getName());
    private Hashtable protocols = new Hashtable();
    private Hashtable listeners = new Hashtable();
    private Hashtable incomingFilterListeners = new Hashtable();
    private Hashtable outgoingFilterListeners = new Hashtable();
    private EndpointService parentEndpoint = null;
    private boolean runRouter = true;
    private boolean routerInitialized = false;
    private Advertisement implAdv = null;
    private ID assignedID = null;
    private PeerGroup group = null;
    private String localPeerId = null;
    private Hashtable inboundTraffic = new Hashtable();
    private Hashtable outboundTraffic = new Hashtable();
    private int lastMessageSentAt = 0;
    private int lastMessageRecdAt = 0;
    private boolean isTrafficRecordingEnabled = false;
    private static final String EndpointHeaderSrcPeer = "jxta:EndpointHeaderSrcPeer";
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointServiceImpl;

    public Service getInterface() {
        return new EndpointServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdv = (ModuleImplAdvertisement)impl;
        this.assignedID = assignedID;
        this.group = group;
        this.localPeerId = group.getPeerID().toString();
        RefPeerGroup parentGroup = ((RefPeerGroup)group).getParentGroup();
        if (parentGroup == null) {
            return;
        }
        this.parentEndpoint = parentGroup.getEndpointService();
        if (this.parentEndpoint == null) {
            return;
        }
        Enumeration protosBelow = this.parentEndpoint.getEndpointProtocols();
        while (protosBelow.hasMoreElements()) {
            this.addEndpointProtocol((EndpointProtocol)protosBelow.nextElement());
        }
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    private synchronized void addProtoToAdv(EndpointProtocol proto) {
        PeerAdvertisement padv = this.group.getPeerAdvertisement();
        StructuredDocument myParam = padv.getServiceParam(this.assignedID);
        if (myParam == null) {
            myParam = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
        }
        Element a = myParam.createElement("Addr", proto.getPublicAddress().toString());
        myParam.appendChild(a);
        padv.putServiceParam(this.assignedID, myParam);
    }

    private void clearProtoFromAdv(EndpointProtocol proto) {
        PeerAdvertisement padv = this.group.getPeerAdvertisement();
        StructuredDocument myParam = padv.getServiceParam(this.assignedID);
        if (myParam == null) {
            return;
        }
        StructuredDocument newParam = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
        String addrToRemove = proto.getPublicAddress().toString();
        Enumeration addresses = myParam.getChildren();
        while (addresses.hasMoreElements()) {
            TextElement a = (TextElement)addresses.nextElement();
            if (a.getName().equals("Addr") && a.getTextValue().equals(addrToRemove)) continue;
            Element n = newParam.createElement(a.getName(), a.getTextValue());
            newParam.appendChild(n);
        }
        padv.putServiceParam(this.assignedID, newParam);
    }

    public synchronized void addEndpointProtocol(EndpointProtocol proto) throws IllegalArgumentException {
        if (this.protocols.contains(proto.getProtocolName())) {
            EndpointProtocol old = this.parentEndpoint.getEndpointProtocolByName(proto.getProtocolName());
            if (old == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Duplicate endpoint protocol " + proto.getProtocolName() + " rejected."));
                }
                throw new IllegalArgumentException("Duplicate endpoint protocol " + proto.getProtocolName() + " rejected.");
            }
            if (old != proto) {
                if (!old.allowOverLoad()) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("Overload endpoint protocol " + proto.getProtocolName() + " rejected."));
                    }
                    throw new IllegalArgumentException("Overload endpoint protocol " + proto.getProtocolName() + " rejected.");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Protocol " + proto.getProtocolName() + " hides a protocol of parent endpoint service."));
                }
                this.clearProtoFromAdv(old);
                this.protocols.remove(old.getProtocolName());
            }
        }
        this.clearProtoFromAdv(proto);
        this.protocols.put(proto.getProtocolName(), proto);
        this.addProtoToAdv(proto);
    }

    public synchronized void removeEndpointProtocol(EndpointProtocol proto) {
        Object obj = this.protocols.remove(proto.getProtocolName());
        if (obj != null) {
            this.clearProtoFromAdv(proto);
        }
    }

    public Enumeration getEndpointProtocols() {
        return this.protocols.elements();
    }

    public Message newMessage() {
        return new MessageImpl();
    }

    public EndpointAddress newEndpointAddress(String Uri) {
        return new Address(Uri);
    }

    public EndpointMessenger getMessenger(EndpointAddress addr) throws IOException {
        EndpointProtocol proto = this.getEndpointProtocolByName(addr.getProtocolName());
        if (proto == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Could not get Protocol for name " + addr.getProtocolName()));
            }
            throw new IOException("Could not get Protocol for name " + addr.getProtocolName());
        }
        return proto.getMessenger(addr);
    }

    public void propagate(Message srcMsg, String serviceName, String serviceParam) throws IOException {
        EndpointProtocol proto = null;
        MessageImpl m = null;
        Enumeration enumeration = this.protocols.elements();
        while (enumeration.hasMoreElements()) {
            try {
                proto = (EndpointProtocol)enumeration.nextElement();
                m = (MessageImpl)srcMsg.clone();
                m.setString(EndpointHeaderSrcPeer, this.localPeerId);
                srcMsg = this.processFilters(srcMsg, proto.getPublicAddress(), null, false);
                if (srcMsg == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"   message discarded upon filter decision");
                    }
                    return;
                }
                proto.propagate(m, serviceName, serviceParam, null);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Failed to send on endpoint protocol. ", (Throwable)e);
            }
        }
    }

    private synchronized void addListenerSync(String address, EndpointListener listener) throws IllegalArgumentException {
        if (this.listeners.contains(address)) {
            throw new IllegalArgumentException("listener already present for address " + address);
        }
        this.listeners.put(address, listener);
    }

    public void addListener(String address, EndpointListener listener) throws IllegalArgumentException {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.addListener(address, listener);
        }
        this.addListenerSync(address, new EndpointDemuxListener(address, listener));
    }

    private synchronized boolean removeListenerSync(String address, EndpointListener listener) {
        EndpointDemuxListener h = (EndpointDemuxListener)this.listeners.remove(address);
        if (h == null) {
            return false;
        }
        if (listener == null) {
            return false;
        }
        if (h.getListener() == listener) {
            h.unregistered();
            return true;
        }
        this.listeners.put(address, h);
        return false;
    }

    public boolean removeListener(String address, EndpointListener listener) {
        if (!this.removeListenerSync(address, listener)) {
            return false;
        }
        if (this.parentEndpoint == null) {
            return true;
        }
        return this.parentEndpoint.removeListener(address, listener);
    }

    private synchronized EndpointListener lookupListener(String address) {
        return (EndpointListener)this.listeners.get(address);
    }

    private synchronized void addFilterListenerSync(String name, EndpointFilterListener listener, boolean incoming) throws IllegalArgumentException {
        Hashtable filterListeners;
        Hashtable hashtable = filterListeners = incoming ? this.incomingFilterListeners : this.outgoingFilterListeners;
        if (filterListeners.contains(name)) {
            throw new IllegalArgumentException("filter istener for " + name + " is already present");
        }
        filterListeners.put(name, listener);
    }

    public void addFilterListener(String name, EndpointFilterListener listener, boolean incoming) throws IllegalArgumentException {
        int index = name.indexOf(58);
        if (index == -1) {
            this.addFilterListenerNameSpace(name, listener, index, incoming);
        } else {
            this.addFilterListenerFullName(name, listener, index, incoming);
        }
    }

    private void addFilterListenerNameSpace(String nameSpace, EndpointFilterListener listener, int index, boolean incoming) throws IllegalArgumentException {
        if (index == 0) {
            throw new IllegalArgumentException("Illegal fullName = \"\"");
        }
        if (this.parentEndpoint != null) {
            this.parentEndpoint.addFilterListener(nameSpace, listener, incoming);
        }
        this.addFilterListenerSync(nameSpace, listener, incoming);
    }

    private void addFilterListenerFullName(String fullName, EndpointFilterListener listener, int index, boolean incoming) throws IllegalArgumentException {
        if (index == 0 || fullName.length() == index + 1) {
            throw new IllegalArgumentException("Illegal fullName: " + fullName);
        }
        if (this.parentEndpoint != null) {
            this.parentEndpoint.addFilterListener(fullName, listener, incoming);
        }
        this.addFilterListenerSync(fullName, listener, incoming);
    }

    private synchronized void removeFilterListenerSync(String name, EndpointFilterListener listener, boolean incoming) {
        Hashtable filterListeners;
        Hashtable hashtable = filterListeners = incoming ? this.incomingFilterListeners : this.outgoingFilterListeners;
        if (filterListeners.get(name) == listener) {
            filterListeners.remove(name);
        }
    }

    public void removeFilterListener(String name, EndpointFilterListener listener, boolean incoming) {
        this.removeFilterListenerSync(name, listener, incoming);
        if (this.parentEndpoint != null) {
            this.parentEndpoint.removeFilterListener(name, listener, incoming);
        }
    }

    private synchronized EndpointFilterListener lookupFilterListener(String name, boolean incoming) {
        if (incoming) {
            return (EndpointFilterListener)this.incomingFilterListeners.get(name);
        }
        return (EndpointFilterListener)this.outgoingFilterListeners.get(name);
    }

    /*
     * Unable to fully structure code
     */
    private Message processFilters(Message msg, EndpointAddress srcAddress, EndpointAddress dstAddress, boolean incoming) {
        elements = msg.getNames();
        if (elements != null && elements.hasMoreElements()) ** GOTO lbl21
        return msg;
lbl-1000:
        // 1 sources

        {
            try {
                invokee = fullName = elements.nextString();
                listener = this.lookupFilterListener(fullName, incoming);
                if (listener == null) {
                    names = MessageElement.parseName(fullName);
                    listener = this.lookupFilterListener(names[0], incoming);
                    invokee = names[0];
                }
                if (listener != null) {
                    if (EndpointServiceImpl.LOG.isEnabledFor(Priority.DEBUG)) {
                        EndpointServiceImpl.LOG.debug((Object)("   invoking filter listener: " + invokee));
                    }
                    if ((msg = listener.processIncomingMessage(msg, srcAddress, dstAddress)) == null) {
                        return null;
                    }
                }
                continue;
            }
            catch (Exception e) {
                if (EndpointServiceImpl.LOG.isEnabledFor(Priority.WARN)) {
                    EndpointServiceImpl.LOG.warn((Object)("process filter failed with " + e));
                }
                return null;
            }
lbl21:
            // 2 sources

            ** while (elements.hasMoreElements())
        }
lbl22:
        // 1 sources

        return msg;
    }

    public void demux(Message msg) throws IOException {
        EndpointListener h;
        EndpointAddress dstAddress = msg.getDestinationAddress();
        if (dstAddress == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"demux: no destination address. Discard");
            }
            return;
        }
        EndpointAddress srcAddress = msg.getSourceAddress();
        String srcPeer = null;
        Object ip = null;
        srcPeer = msg.getString(EndpointHeaderSrcPeer);
        if (srcPeer != null && srcPeer.equals(this.localPeerId)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   discard loopback");
            }
            return;
        }
        if (!((MessageImpl)msg).filtered) {
            ((MessageImpl)msg).filtered = true;
            if ((msg = this.processFilters(msg, srcAddress, dstAddress, true)) == null) {
                return;
            }
        }
        String serviceName = dstAddress.getServiceName();
        String serviceParam = dstAddress.getServiceParameter();
        if (serviceName == null) {
            serviceName = "";
        }
        if (serviceParam == null) {
            serviceParam = "";
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("serviceName = " + serviceName));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("serviceParam = " + serviceParam));
        }
        if ((h = this.lookupListener(serviceName + serviceParam)) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"demux: no listener for this kind of message: ");
            }
            return;
        }
        h.processIncomingMessage(msg, srcAddress, dstAddress);
    }

    public EndpointProtocol getEndpointProtocolByName(String name) {
        return (EndpointProtocol)this.protocols.get(name);
    }

    public boolean ping(EndpointAddress addr) {
        if (addr == null) {
            return false;
        }
        try {
            String protoName = addr.getProtocolName();
            EndpointProtocol proto = this.getEndpointProtocolByName(protoName);
            return proto.ping(addr);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Exeption while trying to ping " + addr + ": " + e));
            }
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

