/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.UnsupportedEncodingException;
import net.jxta.endpoint.EndpointAddress;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Address
implements EndpointAddress {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$Address == null ? (class$net$jxta$impl$endpoint$Address = Address.class$("net.jxta.impl.endpoint.Address")) : class$net$jxta$impl$endpoint$Address).getName());
    String protocol;
    String protocolAddress;
    String service;
    String serviceParam;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$Address;

    public Address() {
        this.protocol = null;
        this.protocolAddress = null;
        this.service = null;
        this.serviceParam = null;
    }

    public Address(String address) {
        this.parse(address);
    }

    public Address(byte[] bytes) {
        try {
            this.parse(new String(bytes, "UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public Object clone() {
        Address a = new Address();
        a.protocol = this.protocol;
        a.protocolAddress = this.protocolAddress;
        a.service = this.service;
        a.serviceParam = this.serviceParam;
        return a;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof Address) {
            return this.toString().equals(target.toString());
        }
        return false;
    }

    public synchronized String toString() {
        if (this.service == null) {
            return this.protocol + "://" + this.protocolAddress + "/";
        }
        if (this.serviceParam != null) {
            return this.protocol + "://" + this.protocolAddress + "/" + this.service + "/" + this.serviceParam;
        }
        return this.protocol + "://" + this.protocolAddress + "/" + this.service;
    }

    public synchronized byte[] getBytes() {
        return this.toString().getBytes();
    }

    public synchronized String getProtocolName() {
        return this.protocol;
    }

    public synchronized String getProtocolAddress() {
        return this.protocolAddress;
    }

    public synchronized String getServiceName() {
        return this.service;
    }

    public synchronized String getServiceParameter() {
        return this.serviceParam;
    }

    public synchronized void setProtocolName(String name) {
        this.protocol = name;
    }

    public synchronized void setProtocolAddress(String address) {
        this.protocolAddress = address;
    }

    public synchronized void setServiceName(String name) {
        this.service = name;
    }

    public synchronized void setServiceParameter(String param) {
        this.serviceParam = param;
    }

    private void parse(String addr) {
        int index = addr.indexOf("://");
        String tmp = null;
        if (index == -1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Address is not in absolute form");
            }
            throw new IllegalArgumentException("Address is not in absolute form");
        }
        try {
            this.protocol = addr.substring(0, index);
            tmp = addr.substring(index + 3);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Protocol address is missing");
            }
            throw new IllegalArgumentException("Protocol address is missing");
        }
        index = tmp.indexOf("/");
        if (index == -1) {
            this.protocolAddress = tmp;
            return;
        }
        try {
            this.protocolAddress = tmp.substring(0, index);
            tmp = tmp.substring(index + 1);
        }
        catch (Exception e) {
            return;
        }
        index = tmp.indexOf("/");
        if (index == -1) {
            this.service = tmp;
            return;
        }
        try {
            this.service = tmp.substring(0, index);
            tmp = tmp.substring(index + 1);
        }
        catch (Exception e) {
            return;
        }
        this.serviceParam = tmp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

