/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.TextElementCommon;

public class LiteXMLElement
extends TextElementCommon
implements Attributable {
    protected LiteXMLDocument doc;
    protected Element parent;
    protected tagRange loc;
    private StringBuffer uninserted = null;
    private Vector children = new Vector();

    protected LiteXMLElement(LiteXMLDocument doc, String name) {
        this(doc, name, null);
    }

    protected LiteXMLElement(LiteXMLDocument doc, String name, String val) {
        this(doc, (tagRange)null);
        this.loc = new tagRange();
        if (null == val) {
            this.uninserted = new StringBuffer();
        } else {
            this.uninserted = new StringBuffer(val);
            this.encodeEscaped(this.uninserted);
        }
        this.uninserted.insert(0, "<" + name + ">");
        this.uninserted.append("</" + name + ">");
    }

    protected LiteXMLElement(LiteXMLDocument doc, tagRange loc) {
        this.doc = doc;
        this.loc = loc;
    }

    public boolean equals(Object element) {
        if (this == element) {
            return true;
        }
        if (!(element instanceof LiteXMLElement)) {
            return false;
        }
        LiteXMLElement liteElement = (LiteXMLElement)element;
        if (this.doc != liteElement.doc) {
            return false;
        }
        if (!this.getName().equals(liteElement.getName())) {
            return false;
        }
        String val1 = null != this.uninserted ? this.uninserted.toString() : this.getTextValue();
        String val2 = liteElement.getTextValue();
        if (null == val1 && null == val2) {
            return true;
        }
        if (null == val1 || null == val2) {
            return false;
        }
        return val1.equals(val2);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.doc = null;
        this.parent = null;
        this.children = null;
        this.uninserted = null;
        this.loc = null;
    }

    public StructuredDocument getRoot() {
        return this.doc;
    }

    public Element getParent() {
        return this.parent;
    }

    public Enumeration getChildren() {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        return this.children.elements();
    }

    public String getName() {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int current = this.loc.startTag.start + 1;
        while (current < this.loc.startTag.end) {
            if (-1 != "\n\r\t />".indexOf(this.doc.docContent.charAt(current))) break;
            ++current;
        }
        return this.doc.docContent.substring(this.loc.startTag.start + 1, current);
    }

    public String getTextValue() {
        return this.getTextValue(false);
    }

    public void appendChild(TextElement element) {
        if (!(element instanceof LiteXMLElement)) {
            throw new IllegalArgumentException("Element type not supported.");
        }
        LiteXMLElement newElement = (LiteXMLElement)element;
        if (newElement.doc != this.doc) {
            throw new IllegalArgumentException("Wrong document");
        }
        if (null != newElement.parent) {
            throw new IllegalArgumentException("New element is already in document");
        }
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null != newElement.uninserted) {
            this.doc.docContent = this.doc.docContent.substring(0, this.loc.endTag.start) + newElement.uninserted + this.doc.docContent.substring(this.loc.endTag.start);
            newElement.loc.startTag.start = this.loc.endTag.start;
            newElement.loc.startTag.end = this.doc.docContent.indexOf(62, newElement.loc.startTag.start);
            newElement.loc.body.start = newElement.loc.startTag.end + 1;
            newElement.loc.endTag.end = newElement.loc.startTag.start + newElement.uninserted.length() - 1;
            newElement.loc.endTag.start = this.doc.docContent.lastIndexOf(60, newElement.loc.endTag.end);
            newElement.loc.body.end = newElement.loc.endTag.start - 1;
            if (0 != this.loc.body.length()) {
                this.doc.adjustLocations(this.loc.endTag.start, newElement.uninserted.length());
            } else {
                --this.loc.body.start;
                this.doc.adjustLocations(this.loc.endTag.start, newElement.uninserted.length());
                ++this.loc.body.start;
            }
            this.loc.body.end += newElement.uninserted.length();
            newElement.uninserted = null;
        }
        if (!this.loc.body.contains(newElement.loc)) {
            throw new IllegalStateException("Element is not contained by parent");
        }
        newElement.parent = this;
        this.children.addElement(newElement);
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
    }

    public Enumeration getChildren(String name) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        Vector<TextElement> result = new Vector<TextElement>();
        Enumeration eachChild = this.children.elements();
        while (eachChild.hasMoreElements()) {
            TextElement aChild = (TextElement)eachChild.nextElement();
            if (!name.equals(aChild.getName())) continue;
            result.addElement(aChild);
        }
        return result.elements();
    }

    protected String getTextValue(boolean getEncoded) {
        String result;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Corrupted Node");
        }
        StringBuffer building = new StringBuffer();
        Vector<charRange> ranges = new Vector<charRange>();
        Enumeration eachChild = this.getChildren();
        while (eachChild.hasMoreElements()) {
            LiteXMLElement aChild = (LiteXMLElement)eachChild.nextElement();
            charRange childsRange = new charRange(aChild.loc.startTag.start, aChild.loc.endTag.end);
            int eachRange = 0;
            while (eachRange < ranges.size()) {
                charRange rangeChild = (charRange)ranges.elementAt(eachRange);
                if (1 == rangeChild.compareTo(childsRange)) {
                    ranges.setElementAt(childsRange, eachRange);
                    childsRange = rangeChild;
                }
                ++eachRange;
            }
            ranges.addElement(childsRange);
        }
        int current = this.loc.body.start;
        Enumeration eachRange = ranges.elements();
        while (eachRange.hasMoreElements()) {
            charRange aRange = (charRange)eachRange.nextElement();
            building.append(this.doc.docContent.substring(current, aRange.start));
            current = aRange.end + 1;
        }
        building.append(this.doc.docContent.substring(current, this.loc.endTag.start));
        if (!getEncoded) {
            building = this.decodeEscaped(building);
        }
        if (0 == (result = building.toString().trim()).length()) {
            return null;
        }
        return result;
    }

    protected void printNice(Writer into, int indent, boolean recurse) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        try {
            int eachTab = 0;
            while (eachTab < indent) {
                into.write("\t");
                ++eachTab;
            }
            into.write(this.doc.docContent.substring(this.loc.startTag.start, this.loc.startTag.end + 1) + "\n");
            String itsValue = this.getTextValue(true);
            if (null != itsValue) {
                int eachTab2 = 0;
                while (eachTab2 < indent + 1) {
                    into.write("\t");
                    ++eachTab2;
                }
                into.write(itsValue + "\n");
            }
            if (recurse) {
                Enumeration childrens = this.getChildren();
                while (childrens.hasMoreElements()) {
                    ((LiteXMLElement)childrens.nextElement()).printNice(into, indent + 1, recurse);
                }
            }
            int eachTab3 = 0;
            while (eachTab3 < indent) {
                into.write("\t");
                ++eachTab3;
            }
            into.write(this.doc.docContent.substring(this.loc.endTag.start, this.loc.endTag.end + 1) + "\n");
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    protected tagRange getTagRanges(String source, String tag, charRange range) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added to the document.");
        }
        result = new tagRange();
        start = range.start;
        end = source.length() - 1;
        foundStartTag = false;
        foundEndTag = false;
        v0 = emptyTag = null == tag || "".equals(tag) != false;
        if (-1 == start || start >= end) {
            return result;
        }
        if (-1 != range.end && end > range.end) {
            end = range.end;
        }
        if (null == tag) {
            tag = "";
        }
        current = start;
        if (!emptyTag) ** GOTO lbl43
        foundTagText = source.indexOf(60, current);
        if (-1 == foundTagText) {
            return result;
        }
        for (afterTagText = ++foundTagText; afterTagText <= end; ++afterTagText) {
            if (-1 == " \t\n\r/>".indexOf(source.charAt(afterTagText))) {
                continue;
            }
            tag = source.substring(foundTagText, afterTagText);
            emptyTag = null == tag || "".equals(tag) != false;
            break;
        }
        if (!emptyTag) ** GOTO lbl43
        return result;
lbl-1000:
        // 1 sources

        {
            foundTagText = source.indexOf(tag, current + 1);
            afterTagText = foundTagText + tag.length();
            if (-1 == foundTagText || afterTagText > end) {
                return result;
            }
            if ('<' != source.charAt(foundTagText - 1) || -1 == " \t\n\r/>".indexOf(source.charAt(afterTagText))) {
                current = afterTagText;
                continue;
            }
            foundTagTerminator = source.indexOf(62, afterTagText);
            foundNextTagStart = source.indexOf(60, afterTagText + 1);
            if (-1 == foundTagTerminator || foundTagTerminator > end || -1 != foundNextTagStart && foundNextTagStart < foundTagTerminator) {
                current = afterTagText;
                continue;
            }
            foundStartTag = true;
            result.startTag.start = foundTagText - 1;
            result.startTag.end = foundTagTerminator;
lbl43:
            // 5 sources

            ** while (!foundStartTag && current < end)
        }
lbl44:
        // 1 sources

        if (!foundStartTag) {
            return result;
        }
        if ('/' == source.charAt(result.startTag.end - 1)) {
            result.endTag = result.startTag;
            return result;
        }
        current = result.startTag.end + 1;
        subElement = null;
        if (current >= end) {
            return result;
        }
        endTag = "</" + tag + ">";
        while (!foundEndTag && current < end) {
            foundTagText = source.indexOf(endTag, current);
            if (-1 == foundTagText || foundTagText + endTag.length() - 1 > end) break;
            subElement = this.getTagRanges(source, tag, new charRange(current, foundTagText - 1));
            if (subElement.startTag.isValid()) {
                current = foundTagText + endTag.length();
                continue;
            }
            foundEndTag = true;
            result.endTag.start = foundTagText;
            result.endTag.end = foundTagText + endTag.length() - 1;
        }
        result.body.start = result.startTag.end + 1;
        result.body.end = foundEndTag != false ? result.endTag.start - 1 : end;
        return result;
    }

    protected void addChildTags(charRange scanRange, LiteXMLElement addTo) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int current = scanRange.start;
        do {
            tagRange aSubtag;
            if ((aSubtag = this.getTagRanges(this.doc.docContent, null, new charRange(current, scanRange.end))).isValid()) {
                LiteXMLElement newChild = (LiteXMLElement)this.doc.createElement(aSubtag);
                addTo.appendChild(newChild);
                this.addChildTags(aSubtag.body, newChild);
                current = aSubtag.endTag.end + 1;
                continue;
            }
            current = -1;
        } while (-1 != current && current < scanRange.end);
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
    }

    protected void adjustLocations(int beginningAt, int by) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (this.loc.startTag.end >= beginningAt || this.loc.startTag.start >= beginningAt && this.loc.startTag.end + 1 == this.loc.startTag.start) {
            this.loc.startTag.end += by;
        }
        if (this.loc.startTag.start >= beginningAt) {
            this.loc.startTag.start += by;
        }
        if (this.loc.body.end >= beginningAt || this.loc.body.start >= beginningAt && this.loc.body.end + 1 == this.loc.body.start) {
            this.loc.body.end += by;
        }
        if (this.loc.body.start >= beginningAt) {
            this.loc.body.start += by;
        }
        if (this.loc.endTag.end >= beginningAt || this.loc.endTag.start >= beginningAt && this.loc.endTag.end + 1 == this.loc.endTag.start) {
            this.loc.endTag.end += by;
        }
        if (this.loc.endTag.start >= beginningAt) {
            this.loc.endTag.start += by;
        }
        Enumeration eachChild = this.getChildren();
        while (eachChild.hasMoreElements()) {
            LiteXMLElement aChild = (LiteXMLElement)eachChild.nextElement();
            aChild.adjustLocations(beginningAt, by);
        }
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
    }

    protected StringBuffer decodeEscaped(StringBuffer target) {
        int current = 0;
        StringBuffer result = new StringBuffer();
        while (current < target.length()) {
            if ('&' != target.charAt(current)) {
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            int terminusAt = current + 1;
            while (terminusAt < target.length() && terminusAt - current < 6 && ';' != target.charAt(terminusAt)) {
                ++terminusAt;
            }
            if (terminusAt >= target.length() || ';' != target.charAt(terminusAt)) {
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            char[] sub = new char[terminusAt - current + 1];
            target.getChars(current, terminusAt + 1, sub, 0);
            String escaped = new String(sub);
            if ("&amp;".equals(escaped)) {
                result.append('&');
                current += 4;
            } else if ("&lt;".equals(escaped)) {
                result.append('<');
                current += 3;
            } else if ("&gt;".equals(escaped)) {
                result.append('>');
                current += 3;
            } else {
                if (escaped.startsWith("&#")) {
                    char asChar;
                    String numericChar = escaped.substring(2, escaped.length() - 1);
                    if (numericChar.length() < 1) {
                        result.append(target.charAt(current));
                        ++current;
                        continue;
                    }
                    if (numericChar.charAt(0) == 'x') {
                        if ((numericChar = numericChar.substring(1)).length() < 1) {
                            result.append(target.charAt(current));
                            ++current;
                            continue;
                        }
                        try {
                            asChar = (char)Integer.parseInt(numericChar.toLowerCase(), 16);
                            result.append(asChar);
                            current += escaped.length();
                        }
                        catch (NumberFormatException badref) {
                            result.append(target.charAt(current));
                            ++current;
                        }
                        continue;
                    }
                    try {
                        asChar = (char)Integer.parseInt(numericChar, 10);
                        result.append(asChar);
                        current += escaped.length();
                    }
                    catch (NumberFormatException badref) {
                        result.append(target.charAt(current));
                        ++current;
                    }
                    continue;
                }
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            ++current;
        }
        return result;
    }

    protected void encodeEscaped(StringBuffer target) {
        int current = 0;
        while (current < target.length()) {
            if ('&' == target.charAt(current)) {
                target.insert(current + 1, "amp;");
                current += 5;
                continue;
            }
            if ('<' == target.charAt(current)) {
                target.setCharAt(current, '&');
                target.insert(current + 1, "lt;");
                current += 4;
                continue;
            }
            ++current;
        }
    }

    public Enumeration getAttributes() {
        Vector<Attribute> results = new Vector<Attribute>();
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int current = this.loc.startTag.start + 1;
        while (-1 == "\n\r\t />".indexOf(this.doc.docContent.charAt(current))) {
            ++current;
        }
        while (current < this.loc.startTag.end) {
            tagRange nextAttr = this.getAttributeLoc(null, new charRange(current, this.loc.startTag.end));
            if (!nextAttr.isValid()) break;
            results.add(new Attribute(this, this.doc.docContent.substring(nextAttr.startTag.start, nextAttr.startTag.end + 1), this.doc.docContent.substring(nextAttr.body.start, nextAttr.body.end + 1)));
            current = nextAttr.endTag.end + 1;
        }
        return results.elements();
    }

    private tagRange getAttributeLoc(String name, charRange inRange) {
        tagRange result = new tagRange();
        int current = inRange.start;
        while (true) {
            if (-1 != "\n\r\t >".indexOf(this.doc.docContent.charAt(current))) {
                ++current;
                continue;
            }
            int equalsAt = this.doc.docContent.indexOf(61, current);
            if (-1 == equalsAt || equalsAt >= inRange.end) {
                return result;
            }
            result.startTag.start = current;
            result.startTag.end = equalsAt - 1;
            char requiredQuote = this.doc.docContent.charAt(equalsAt + 1);
            if ('\'' != requiredQuote && '\"' != requiredQuote) {
                return result;
            }
            int nextQuote = this.doc.docContent.indexOf(requiredQuote, equalsAt + 2);
            if (-1 == nextQuote || nextQuote >= inRange.end) {
                return result;
            }
            result.body.start = equalsAt + 2;
            result.body.end = nextQuote - 1;
            result.endTag.start = nextQuote;
            result.endTag.end = nextQuote;
            if (null != name && !name.equals(this.doc.docContent.substring(result.startTag.start, result.startTag.end + 1))) {
                result.startTag.start = -1;
            }
            if ((current = nextQuote + 1) >= inRange.end || result.isValid()) break;
        }
        return result;
    }

    public String addAttribute(String name, String value) {
        char usingQuote;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null == name) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (null == value) {
            throw new IllegalArgumentException("value must not be null");
        }
        int current = this.loc.startTag.start + 1;
        while (-1 == "\n\r\t />".indexOf(this.doc.docContent.charAt(current))) {
            ++current;
        }
        tagRange oldAttr = this.getAttributeLoc(name, new charRange(current, this.loc.startTag.end));
        String oldValue = null;
        char c = usingQuote = -1 != value.indexOf(34) ? (char)'\'' : '\"';
        if (-1 != value.indexOf(39)) {
            throw new IllegalArgumentException("Value contains both \" and '");
        }
        StringBuffer newStuff = new StringBuffer(" ");
        newStuff.append(name);
        newStuff.append("=");
        newStuff.append(usingQuote);
        newStuff.append(value);
        newStuff.append(usingQuote);
        if (!oldAttr.isValid()) {
            this.doc.docContent = this.doc.docContent.substring(0, this.loc.startTag.end) + newStuff + this.doc.docContent.substring(this.loc.startTag.end);
            this.doc.adjustLocations(this.loc.body.start, newStuff.length());
            this.loc.startTag.end += newStuff.length();
        } else {
            oldValue = this.doc.docContent.substring(oldAttr.body.start, oldAttr.body.end + 1);
            this.doc.docContent = this.doc.docContent.substring(0, oldAttr.startTag.start) + newStuff + this.doc.docContent.substring(oldAttr.endTag.end + 1);
            int delta = newStuff.length() - (oldAttr.endTag.end - oldAttr.startTag.start + 1);
            this.doc.adjustLocations(this.loc.body.start, delta);
            this.loc.startTag.end = this.loc.body.start - 1;
        }
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
        return oldValue;
    }

    public String addAttribute(Attribute newAttrib) {
        return this.addAttribute(newAttrib.getName(), newAttrib.getValue());
    }

    public Attribute getAttribute(String name) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int current = this.loc.startTag.start + 1;
        while (-1 == "\n\r\t />".indexOf(this.doc.docContent.charAt(current))) {
            ++current;
        }
        tagRange attr = this.getAttributeLoc(name, new charRange(current, this.loc.startTag.end));
        if (!attr.isValid()) {
            return null;
        }
        return new Attribute(this, this.doc.docContent.substring(attr.startTag.start, attr.startTag.end + 1), this.doc.docContent.substring(attr.body.start, attr.body.end + 1));
    }

    protected static class tagRange
    implements Comparable {
        public charRange startTag = null;
        public charRange body = null;
        public charRange endTag = null;

        public tagRange() {
            this.startTag = new charRange();
            this.body = new charRange();
            this.endTag = new charRange();
        }

        public tagRange(charRange startTag, charRange body, charRange endTag) {
            this.startTag = startTag;
            this.body = body;
            this.endTag = endTag;
        }

        public boolean isValid() {
            return null != this.startTag && null != this.body && null != this.endTag && this.startTag.isValid() && this.body.isValid() && this.endTag.isValid();
        }

        public boolean equals(Object aRange) {
            if (this == aRange) {
                return true;
            }
            if (!(aRange instanceof tagRange)) {
                return false;
            }
            tagRange someRange = (tagRange)aRange;
            return this.startTag.equals(someRange.startTag) && this.body.equals(someRange.body) && this.endTag.equals(someRange.endTag);
        }

        public int compareTo(Object aRange) {
            if (this == aRange) {
                return 0;
            }
            if (!(aRange instanceof tagRange)) {
                throw new ClassCastException("type mismatch error");
            }
            tagRange someRange = (tagRange)aRange;
            int compared = this.startTag.compareTo(someRange.startTag);
            if (0 != compared) {
                return compared;
            }
            return this.endTag.compareTo(someRange.endTag);
        }

        public boolean contains(tagRange someRange) {
            return this.isValid() && someRange.isValid() && this.body.start <= someRange.startTag.start && this.body.end >= someRange.endTag.end;
        }

        public boolean contains(charRange someRange) {
            return this.isValid() && someRange.isValid() && this.body.start <= someRange.start && this.body.end >= someRange.end;
        }
    }

    protected static class charRange
    implements Comparable {
        public int start;
        public int end;

        public charRange() {
            this.start = -1;
            this.end = -1;
        }

        public charRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int length() {
            if (-1 == this.start || -1 == this.end) {
                return -1;
            }
            return this.end - this.start + 1;
        }

        public boolean isValid() {
            return this.length() >= 0;
        }

        public boolean equals(Object aRange) {
            if (this == aRange) {
                return true;
            }
            if (!(aRange instanceof charRange)) {
                return false;
            }
            charRange someRange = (charRange)aRange;
            return this.start == someRange.start && this.end == someRange.end;
        }

        public int compareTo(Object aRange) {
            if (this == aRange) {
                return 0;
            }
            if (!(aRange instanceof charRange)) {
                throw new ClassCastException("type mismatch error");
            }
            charRange someRange = (charRange)aRange;
            if (this.start < someRange.start) {
                return -1;
            }
            if (this.start > someRange.start) {
                return 1;
            }
            if (this.end < someRange.end) {
                return -1;
            }
            if (this.end > someRange.end) {
                return 1;
            }
            return 0;
        }

        public boolean contains(charRange someRange) {
            return this.isValid() && someRange.isValid() && this.start <= someRange.start && this.end >= someRange.end;
        }

        public boolean contains(tagRange someRange) {
            return this.isValid() && someRange.isValid() && this.start <= someRange.startTag.start && this.end >= someRange.endTag.end;
        }

        public boolean contains(int someLoc) {
            return this.isValid() && someLoc >= 0 && this.start <= someLoc && this.end >= someLoc;
        }
    }
}

