/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredTextDocument;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ResendQueryException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.discovery.DiscoveryServiceInterface;
import net.jxta.impl.protocol.DiscoveryQuery;
import net.jxta.impl.protocol.DiscoveryResponse;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class DiscoveryServiceImpl
implements DiscoveryService,
QueryHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$discovery$DiscoveryServiceImpl == null ? (class$net$jxta$impl$discovery$DiscoveryServiceImpl = DiscoveryServiceImpl.class$("net.jxta.impl.discovery.DiscoveryServiceImpl")) : class$net$jxta$impl$discovery$DiscoveryServiceImpl).getName());
    private static int qid = 0;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    protected Cm cm;
    protected String[] dirname = new String[]{"Peers", "Groups", "Adv"};
    private ResolverService resolver;
    private PeerGroup group = null;
    private String localPeerId = null;
    private long seed = System.currentTimeMillis();
    private Vector listeners = new Vector();
    private Hashtable listenerTable = new Hashtable();
    private ModuleImplAdvertisement implAdvertisement = null;
    private String localPeerAdvStr = null;
    private String handlerName = null;
    private boolean lastIsRdv = false;
    static /* synthetic */ Class class$net$jxta$impl$discovery$DiscoveryServiceImpl;

    private void updatePeerAdvStr() {
        boolean newIsRdv = this.group.isRendezvous();
        if (this.lastIsRdv != newIsRdv) {
            this.localPeerAdvStr = this.advToString(this.group.getPeerAdvertisement());
            this.lastIsRdv = newIsRdv;
        }
    }

    public Service getInterface() {
        return new DiscoveryServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold) {
        if (this.resolver == null) {
            return this.nextQid();
        }
        this.updatePeerAdvStr();
        DiscoveryQuery dquery = new DiscoveryQuery(type, this.localPeerAdvStr, attribute, value, threshold);
        if (attribute != null && value != null) {
            dquery.setAttr(attribute);
            dquery.setValue(value);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sending query: " + attribute + " = " + value));
            }
        }
        int myQueryID = this.nextQid();
        ResolverQuery query = new ResolverQuery(this.handlerName, "JXTACRED", this.localPeerId, dquery.toString(), myQueryID);
        this.resolver.sendQuery(peer, query);
        return myQueryID;
    }

    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold, DiscoveryListener listener) {
        if (this.resolver == null) {
            return this.nextQid();
        }
        this.updatePeerAdvStr();
        DiscoveryQuery dquery = new DiscoveryQuery(type, this.localPeerAdvStr, attribute, value, threshold);
        if (attribute != null && value != null) {
            dquery.setAttr(attribute);
            dquery.setValue(value);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sending query: " + attribute + " = " + value));
            }
        }
        int myQueryID = this.nextQid();
        if (listener != null) {
            this.listenerTable.put(new Integer(myQueryID), listener);
        }
        ResolverQuery query = new ResolverQuery(this.handlerName, "JXTACRED", this.localPeerId, dquery.toString(), myQueryID);
        this.resolver.sendQuery(peer, query);
        return myQueryID;
    }

    public Enumeration getLocalAdvertisements(int type, String attribute, String value) throws IOException {
        if (type > 2 || type < 0) {
            throw new IllegalArgumentException("Unknown Advertisement type");
        }
        return this.search(type, attribute, value, Integer.MAX_VALUE, false, null).elements();
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public int startApp(String[] arg) {
        this.resolver = this.group.getResolverService();
        this.resolver.registerHandler(this.handlerName, this);
        return 0;
    }

    public void stopApp() {
        if (this.resolver != null && this.resolver.unregisterHandler(this.handlerName) == null && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"failed to unregister discovery from resolver.");
        }
    }

    public void init(PeerGroup pg, ID assignedID, Advertisement impl) throws PeerGroupException {
        block6: {
            block5: {
                this.implAdvertisement = (ModuleImplAdvertisement)impl;
                this.group = pg;
                this.handlerName = assignedID.toString();
                this.localPeerId = this.group.getPeerID().toString();
                this.localPeerAdvStr = this.advToString(this.group.getPeerAdvertisement());
                this.lastIsRdv = this.group.isRendezvous();
                try {
                    String pgdir = this.group.getPeerGroupID().getUniqueValue().toString();
                    this.cm = new Cm(pgdir, new Cm.ExpirationListener(){

                        public void expired(String dn, String fn, long timeout) {
                            block8: {
                                int type = -1;
                                if (dn.equals(DiscoveryServiceImpl.this.dirname[1])) {
                                    type = 1;
                                } else if (dn.equals(DiscoveryServiceImpl.this.dirname[0])) {
                                    type = 0;
                                } else if (dn.equals(DiscoveryServiceImpl.this.dirname[2])) {
                                    type = 2;
                                }
                                if (type != -1) {
                                    try {
                                        String restoredAdv = new String(DiscoveryServiceImpl.this.cm.restoreBytes(dn, fn));
                                        DiscoveryServiceImpl.this.remotePublish(restoredAdv, type, timeout);
                                    }
                                    catch (IOException e) {
                                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                                        LOG.debug((Object)("Cannot restore " + dn + "/" + fn), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }, true);
                    String[] pElements = new String[]{"Name", "PID"};
                    String[] gElements = new String[]{"Name", "GID", "Desc"};
                    String[] aElements = new String[]{"Name", "Id", "MSID", "RdvGroupId"};
                    this.cm.createFolder(this.dirname[0], pElements);
                    this.cm.createFolder(this.dirname[1], gElements);
                    this.cm.createFolder(this.dirname[2], aElements);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block5;
                    LOG.debug((Object)"Error during creation of local store", (Throwable)e);
                }
            }
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"publishing local advertisement");
                }
                this.publish(this.group.getPeerAdvertisement(), 0, 1471228928L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)"Error when publishing local peer advertisement: ", (Throwable)e);
            }
        }
    }

    public void flushAdvertisements(String id, int type) throws IOException {
        if (type <= 2 && id != null) {
            ID advID = IDFactory.fromURL(new URL(id));
            String advName = advID.getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("flushing adv " + advName + " of type " + this.dirname[type]));
            }
            this.cm.remove(this.dirname[type], advName);
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("flushing advertisements of type " + this.dirname[type]));
            }
            String[] fn = this.cm.getFileNames(this.dirname[type]);
            int i = 0;
            while (i < fn.length) {
                this.cm.remove(this.dirname[type], fn[i]);
                ++i;
            }
        }
    }

    public void publish(Advertisement adv, int type) throws IOException {
        this.publish(adv, type, 1471228928L, 0x6DDD00L);
    }

    public void publish(Advertisement adv, int type, long timeoutForMe, long timeoutForOthers) throws IOException {
        StructuredDocument doc;
        ID advID = null;
        String advName = null;
        advID = adv.getID();
        if (advID != null && advID.equals(ID.nullID)) {
            advID = null;
        }
        try {
            doc = (StructuredDocument)adv.getDocument(new MimeMediaType("text/xml"));
        }
        catch (Exception everything) {
            throw new IOException("Advertisement couldnt be saved because of :" + everything.toString());
        }
        advName = advID == null ? Cm.createTmpName(doc) : advID.getUniqueValue().toString();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("publishing " + advName + " in " + this.dirname[type]));
        }
        this.cm.save(this.dirname[type], advName, doc, timeoutForMe, timeoutForOthers);
    }

    public void remotePublish(Advertisement adv, int type) {
        this.remotePublish(adv, type, 0x6DDD00L);
    }

    public void remotePublish(Advertisement adv, int type, long timeout) {
        this.remotePublish(this.advToString(adv), type, timeout);
    }

    public void processResponse(ResolverResponseMsg response) {
        DiscoveryResponse res;
        try {
            res = new DiscoveryResponse(new ByteArrayInputStream(response.getResponse().getBytes()));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)e);
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Got a " + this.dirname[res.getDiscoveryType()] + " response : " + res.getQueryAttr() + " = " + res.getQueryValue()));
        }
        try {
            String aRes = res.getPeerAdv();
            ByteArrayInputStream is = new ByteArrayInputStream(aRes.getBytes());
            PeerAdvertisement padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), is);
            if (padv != null) {
                this.publish(padv, 0, 0x6DDD00L, 0x6DDD00L);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)e);
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getting responses");
        }
        Enumeration enumeration = res.getResponses();
        Enumeration exps = res.getExpirations();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String str = (String)enumeration.nextElement();
                long exp = (Long)exps.nextElement();
                if (exp <= 0L) continue;
                try {
                    Advertisement adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(str.getBytes()));
                    if (adv == null) continue;
                    this.publish(adv, res.getDiscoveryType(), exp, exp);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        DiscoveryEvent newevent = new DiscoveryEvent(this, res, response.getQueryId());
        DiscoveryListener dl = (DiscoveryListener)this.listenerTable.get(new Integer(response.getQueryId()));
        if (dl != null) {
            dl.discoveryEvent(new DiscoveryEvent(this, res, response.getQueryId()));
        }
        if (this.listeners.size() > 0) {
            int i = 0;
            while (i < this.listeners.size()) {
                dl = (DiscoveryListener)this.listeners.elementAt(i);
                dl.discoveryEvent(newevent);
                ++i;
            }
        }
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg query) throws NoResponseException, DiscardQueryException, IOException, ResendQueryException {
        DiscoveryQuery dq;
        Vector expirations;
        Vector results;
        block12: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery starts");
            }
            Object enum_ = null;
            results = null;
            expirations = new Vector();
            try {
                dq = new DiscoveryQuery(new ByteArrayInputStream(query.getQuery().getBytes()));
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Error in query : ", (Throwable)e);
                }
                throw new IOException();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Got a " + this.dirname[dq.getDiscoveryType()] + " query " + dq.getAttr() + " = " + dq.getValue()));
            }
            PeerAdvertisement padv = null;
            try {
                padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(dq.getPeerAdv().getBytes()));
                if (!padv.getPeerID().toString().equals(this.localPeerId)) {
                    this.publish(padv, 0, 0x6DDD00L, 0x6DDD00L);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                LOG.debug((Object)e);
            }
        }
        results = this.search(dq.getDiscoveryType(), dq.getAttr(), dq.getValue(), dq.getThreshold(), true, expirations);
        if (results == null || results.size() == 0) {
            if (this.group.isRendezvous()) {
                throw new NoResponseException();
            }
            throw new DiscardQueryException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Responding  to " + this.dirname[dq.getDiscoveryType()] + " Query : " + dq.getAttr() + " = " + dq.getValue()));
        }
        this.updatePeerAdvStr();
        DiscoveryResponse dresponse = new DiscoveryResponse(results.size(), dq.getDiscoveryType(), this.localPeerAdvStr, dq.getAttr(), dq.getValue(), results, expirations);
        if (dq.getDiscoveryType() > 0 && results.isEmpty()) {
            throw new DiscardQueryException();
        }
        ResolverResponse response = new ResolverResponse(this.handlerName, "JXTACRED", query.getQueryId(), dresponse.toString());
        return response;
    }

    public synchronized void addDiscoveryListener(DiscoveryListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized boolean removeDiscoveryListener(DiscoveryListener listener) {
        Enumeration e = this.listenerTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.listenerTable.get(key) != listener) continue;
            this.listenerTable.remove(key);
        }
        return this.listeners.removeElement(listener);
    }

    protected synchronized int next(int bits) {
        long nextseed;
        this.seed = nextseed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(nextseed >>> 48 - bits);
    }

    void remotePublish(String advString, int type, long timeout) {
        DiscoveryResponse dresponse;
        block6: {
            if (this.resolver == null) {
                return;
            }
            Vector list = new Vector();
            if (type == 0) {
                return;
            }
            Vector<String> advert = new Vector<String>(1);
            Vector<Long> expirations = new Vector<Long>(1);
            dresponse = null;
            advert.addElement(advString);
            expirations.addElement(new Long(timeout));
            this.updatePeerAdvStr();
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Remote publishing Group");
                }
                dresponse = new DiscoveryResponse(1, type, this.localPeerAdvStr, null, null, advert, expirations);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)e);
            }
        }
        ResolverResponse pushRes = new ResolverResponse(this.handlerName, "JXTACRED", 0, dresponse.toString());
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"remote publishing");
        }
        this.resolver.sendResponse(null, pushRes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector search(int type, String attr, String value, int threshold, boolean bytes, Vector expirations) {
        FileInputStream is = null;
        Enumeration enumeration = null;
        Vector<Object> results = new Vector<Object>();
        if (attr != null || value != null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"narrowing down the response.");
            }
            if ((enumeration = this.cm.search(this.dirname[type], attr, value)) == null) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) return results;
                LOG.debug((Object)("No hits on query" + attr + " " + value));
                return results;
            }
            int i = 1;
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return results;
                }
                String fn = (String)enumeration.nextElement();
                try {
                    block29: {
                        if (fn.equals(this.localPeerId)) continue;
                        if (bytes) {
                            results.addElement(new String(this.cm.restoreBytes(this.dirname[type], fn)));
                            expirations.addElement(new Long(this.cm.getExpirationTime(this.dirname[type], fn)));
                        } else {
                            IOException e2;
                            Object var14_18;
                            try {
                                is = this.cm.getInputStream(this.dirname[type], fn);
                                Advertisement adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), is, this.cm.getExpirationTime(this.dirname[type], fn));
                                results.addElement(adv);
                                var14_18 = null;
                                if (is == null) break block29;
                            }
                            catch (Throwable throwable) {
                                var14_18 = null;
                                if (is == null) throw throwable;
                                try {
                                    is.close();
                                    throw throwable;
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {}
                            catch (IOException e2) {}
                            is.close();
                        }
                    }
                    if (++i <= threshold) continue;
                    return results;
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"search failed", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        String[] fn = this.cm.getFileNames(this.dirname[type]);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"remote does not care about narrowing down the response.");
        }
        if (fn == null) return results;
        if (fn.length == 0) {
            return results;
        }
        int i = 0;
        while (true) {
            block31: {
                if (i >= fn.length) {
                    return results;
                }
                try {
                    block30: {
                        if (!fn[i].equals(this.localPeerId) && this.cm.getExpirationTime(this.dirname[type], fn[i]) > 0L) {
                            if (bytes) {
                                results.addElement(new String(this.cm.restoreBytes(this.dirname[type], fn[i])));
                                expirations.addElement(new Long(this.cm.getExpirationTime(this.dirname[type], fn[i])));
                            } else {
                                IOException e3;
                                Object var17_21;
                                try {
                                    is = this.cm.getInputStream(this.dirname[type], fn[i]);
                                    Advertisement adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), is, this.cm.getExpirationTime(this.dirname[type], fn[i]));
                                    results.addElement(adv);
                                    var17_21 = null;
                                    if (is == null) break block30;
                                }
                                catch (Throwable throwable) {
                                    var17_21 = null;
                                    if (is == null) throw throwable;
                                    try {
                                        is.close();
                                        throw throwable;
                                    }
                                    catch (IOException e3) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {}
                                catch (IOException e3) {}
                                is.close();
                            }
                        }
                    }
                    if (i >= threshold - 1) {
                        return results;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block31;
                    LOG.debug((Object)e);
                }
            }
            ++i;
        }
    }

    private String advToString(Advertisement adv) {
        StringWriter out = new StringWriter();
        MimeMediaType displayAs = new MimeMediaType("text/xml");
        try {
            StructuredTextDocument doc = (StructuredTextDocument)adv.getDocument(displayAs);
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception all) {
            return null;
        }
    }

    private int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    private synchronized int nextQid() {
        return qid++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

