/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.config.ConfigUtil;
import net.jxta.impl.endpoint.Address;

public class TcpConfig {
    private static final int DEFAULT_PORT = 6001;
    private static final String MCAST_HOST = "224.0.1.85";
    private static final int MCAST_PORT = 1234;
    private static final int MCAST_DGRAM_SIZE = 8192;
    private static final String DEFAULT_IMPL = "net.jxta.impl.endpoint.tcp.TcpTransport";
    private EndpointAddress mServerAddress;
    private EndpointAddress mMulticastAddress;
    private int mMulticastBufferLen;
    private boolean mUsePublicAddress;
    private EndpointAddress mPublicAddress;
    private EndpointAddress localAddress;
    private String mImplClassname;
    private static final String KEY_SERVER = "Server";
    private static final String KEY_MCAST = "Multicast";
    private static final String KEY_MCAST_BUFF = "MulticastBufferLen";
    private static final String KEY_IMPL = "Impl";

    public void writeToXML(StructuredTextDocument doc) {
        TextElement parent = doc.createElement("TCP");
        doc.appendChild((Element)parent);
        ConfigUtil.writeAddress(doc, parent, this.mServerAddress, KEY_SERVER);
        ConfigUtil.writeAddress(doc, parent, this.mMulticastAddress, KEY_MCAST);
        TextElement e = doc.createElement(KEY_MCAST_BUFF, String.valueOf(this.mMulticastBufferLen));
        parent.appendChild((Element)e);
        ConfigUtil.writeAddress(doc, parent, this.mPublicAddress, "PublicAddress");
        e = doc.createElement("UsePublicAddress", String.valueOf(this.mUsePublicAddress));
        parent.appendChild((Element)e);
        ConfigUtil.writeAddress(doc, parent, this.localAddress, "LocalAddress");
        e = doc.createElement(KEY_IMPL, this.mImplClassname);
        parent.appendChild((Element)e);
    }

    public static TcpConfig createDefaultConfig() {
        TcpConfig conf = new TcpConfig();
        conf.setServerAddress(new Address("tcp://localhost:6001"));
        conf.setMulticastAddress(new Address("tcp://224.0.1.85:1234"));
        conf.setMulticastBufferLen(8192);
        conf.setLocalAddress(null);
        conf.setPublicAddress(null);
        conf.setUsePublicAddress(false);
        conf.setImplClassname(DEFAULT_IMPL);
        return conf;
    }

    public static TcpConfig newFromXML(TextElement parent) {
        Enumeration enumeration = parent.getChildren();
        if (enumeration == null) {
            return null;
        }
        TcpConfig conf = new TcpConfig();
        while (enumeration.hasMoreElements()) {
            TextElement e = (TextElement)enumeration.nextElement();
            String elname = e.getName();
            if (elname.equals(KEY_IMPL)) {
                conf.mImplClassname = e.getTextValue();
            }
            if (elname.equals(KEY_MCAST_BUFF)) {
                conf.mMulticastBufferLen = Integer.valueOf(e.getTextValue());
                continue;
            }
            if (elname.equals(KEY_SERVER)) {
                conf.mServerAddress = new Address(e.getTextValue());
                continue;
            }
            if (elname.equals(KEY_MCAST)) {
                conf.mMulticastAddress = new Address(e.getTextValue());
                continue;
            }
            if (elname.equals("PublicAddress")) {
                conf.mPublicAddress = new Address(e.getTextValue());
                continue;
            }
            if (elname.equals("UsePublicAddress")) {
                conf.mUsePublicAddress = Boolean.valueOf(e.getTextValue());
                continue;
            }
            if (!elname.equals("LocalAddress")) continue;
            conf.localAddress = new Address(e.getTextValue());
        }
        return conf;
    }

    public EndpointAddress getServerAddress() {
        return this.mServerAddress;
    }

    public void setServerAddress(EndpointAddress aAddress) {
        this.mServerAddress = aAddress;
    }

    public EndpointAddress getMulticastAddress() {
        return this.mMulticastAddress;
    }

    public void setMulticastAddress(EndpointAddress aMulticastAddress) {
        this.mMulticastAddress = aMulticastAddress;
    }

    public int getMulticastBufferLen() {
        return this.mMulticastBufferLen;
    }

    public void setMulticastBufferLen(int aBufferLen) {
        this.mMulticastBufferLen = aBufferLen;
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(EndpointAddress aLocalAddress) {
        this.localAddress = aLocalAddress;
    }

    public EndpointAddress getPublicAddress() {
        return this.mPublicAddress;
    }

    public void setPublicAddress(EndpointAddress aPublicAddress) {
        this.mPublicAddress = aPublicAddress;
    }

    public boolean getUsePublicAddress() {
        return this.mUsePublicAddress;
    }

    public void setUsePublicAddress(boolean aUsePublicAddress) {
        this.mUsePublicAddress = aUsePublicAddress;
    }

    public String getImplClassname() {
        return this.mImplClassname;
    }

    public void setImplClassname(String aImplClassname) {
        this.mImplClassname = aImplClassname;
    }
}

