/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;

public class CodeDescriptor {
    private String mClassname;
    private String mCodeURI;

    public CodeDescriptor(String aClassname, String aCodeURI) {
        this.mClassname = aClassname;
        this.mCodeURI = aCodeURI;
    }

    public String getClassname() {
        return this.mClassname;
    }

    public String getCodeURI() {
        return this.mCodeURI;
    }

    public void writeToXML(StructuredTextDocument aDoc, Element aNode) {
        TextElement child = aDoc.createElement("classname", this.mClassname);
        aNode.appendChild(child);
        child = aDoc.createElement("uri", this.mCodeURI);
        aNode.appendChild(child);
    }

    public static CodeDescriptor newFromXML(TextElement aElement) {
        Enumeration enumeration = aElement.getChildren();
        if (enumeration == null) {
            return null;
        }
        String cn = null;
        String uri = null;
        while (enumeration.hasMoreElements()) {
            TextElement e = (TextElement)enumeration.nextElement();
            String elname = e.getName();
            if (elname.equals("classname")) {
                cn = e.getTextValue();
                continue;
            }
            if (!elname.equals("uri")) continue;
            uri = e.getTextValue();
        }
        return new CodeDescriptor(cn, uri);
    }
}

