/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.impl.cm.SchedulerService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class FileExpirationService {
    File dir;
    File db;
    File tmpDb;
    Vector docDirs;
    SchedulerService ss;
    RandomAccessFile out;
    Hashtable hash;
    int mods;
    SchedulerService.PendingAction pendingCompressAction;
    ExpirationListener listener;
    static final int SCHEDULE = 1;
    static final int CANCEL = 2;
    static final long COMPRESS_INTERVAL = 1800000L;
    static final int MOD_THRESHOLD = 128;
    static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$FileExpirationService == null ? (class$net$jxta$impl$cm$FileExpirationService = FileExpirationService.class$("net.jxta.impl.cm.FileExpirationService")) : class$net$jxta$impl$cm$FileExpirationService).getName());
    static /* synthetic */ Class class$net$jxta$impl$cm$FileExpirationService;

    FileExpirationService(SchedulerService ss, File dir, File[] docDirs, ExpirationListener listener) throws IOException {
        this.db = new File(dir, "scheduler.db");
        this.tmpDb = new File(dir, ".tmp.scheduler.db");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.ss = ss;
        this.dir = dir;
        this.listener = listener;
        this.docDirs = new Vector();
        this.hash = new Hashtable();
        if (this.db.exists()) {
            this.compress();
        } else {
            this.out = new RandomAccessFile(this.db, "rw");
        }
        this.pendingCompressAction = ss.scheduleAction(new CleanupAction(), 1800000L);
        int i = 0;
        while (docDirs != null && i < docDirs.length) {
            this.addDocDir(dir);
            ++i;
        }
    }

    void addDocDir(File dir) {
        this.docDirs.addElement(dir);
    }

    void stop() {
        block3: {
            this.ss.cancelAction(this.pendingCompressAction);
            try {
                if (this.db.exists()) {
                    this.compress();
                }
                this.out.close();
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"Compression of log stream failed on stop()", (Throwable)e);
            }
        }
    }

    public synchronized long getExpirationTime(File f) {
        Entry entry = (Entry)this.hash.get(f.getAbsolutePath());
        if (entry == null) {
            return -1L;
        }
        return Math.min(entry.timeInMyCache, entry.timeoutForOthers + System.currentTimeMillis());
    }

    public void scheduleFileExpiration(File file, long timeInMyCache, long timeoutForOthers) throws IOException {
        while (true) {
            Entry entry = null;
            FileExpirationService fileExpirationService = this;
            synchronized (fileExpirationService) {
                entry = (Entry)this.hash.get(file.getAbsolutePath());
                if (entry == null) {
                    long myTimeout = timeInMyCache - System.currentTimeMillis();
                    entry = new Entry(file, timeInMyCache, timeoutForOthers);
                    ExpireAction action1 = new ExpireAction(entry);
                    entry.myPendingAction = this.ss.scheduleAction(action1, myTimeout);
                    if (entry.myPendingAction != null) {
                        this.hash.put(file.getAbsolutePath(), entry);
                        this.log(1, file, timeInMyCache, timeoutForOthers);
                        ++this.mods;
                    }
                    return;
                }
                if (entry.timeInMyCache > timeInMyCache) {
                    return;
                }
                if (entry.timeInMyCache == timeInMyCache && entry.timeoutForOthers == timeoutForOthers) {
                    return;
                }
                this.hash.remove(file.getAbsolutePath());
            }
            this.ss.cancelAction(entry.myPendingAction);
        }
    }

    public void cancelFileExpiration(File file) {
        Entry e = null;
        FileExpirationService fileExpirationService = this;
        synchronized (fileExpirationService) {
            e = (Entry)this.hash.get(file.getAbsolutePath());
            if (e == null) {
                return;
            }
            this.hash.remove(file.getAbsolutePath());
            this.log(2, file, 0L, 0L);
            ++this.mods;
        }
        this.ss.cancelAction(e.myPendingAction);
    }

    void log(int action, File file, long timeInMyCache, long timeoutForOthers) {
        block4: {
            try {
                this.logWrite(action, file, timeInMyCache, timeoutForOthers);
            }
            catch (IOException e) {
                try {
                    this.compress();
                    this.logWrite(action, file, timeInMyCache, timeoutForOthers);
                }
                catch (IOException e2) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot write to " + this.db + ", keeping expiration tables in memory."));
                }
            }
        }
    }

    void logWrite(int action, File file, long timeInMyCache, long timeForOthers) throws IOException {
        this.out.writeInt(action);
        this.out.writeUTF(file.getAbsolutePath().toString());
        this.out.writeLong(timeInMyCache);
        this.out.writeLong(timeForOthers);
        this.out.getFD().sync();
    }

    private void compress() throws IOException {
        IOException e32;
        DataInputStream in = null;
        long start = System.currentTimeMillis();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        if (this.tmpDb.exists()) {
            this.tmpDb.delete();
        }
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.db)));
            this.out = new RandomAccessFile(this.tmpDb, "rw");
            this.compressStreams(in);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            IOException e32;
            Object var6_5 = null;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Compressed " + this.db + " in " + (System.currentTimeMillis() - start) + " ms."));
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e32) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e32) {
                    // empty catch block
                }
            }
            if (this.tmpDb.exists()) {
                if (this.db.exists()) {
                    this.db.delete();
                }
                this.tmpDb.renameTo(this.db);
            }
            this.out = new RandomAccessFile(this.db, "rw");
            this.out.seek(this.out.length());
            throw throwable;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Compressed " + this.db + " in " + (System.currentTimeMillis() - start) + " ms."));
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e32) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e32) {
                // empty catch block
            }
        }
        if (this.tmpDb.exists()) {
            if (this.db.exists()) {
                this.db.delete();
            }
            this.tmpDb.renameTo(this.db);
        }
        this.out = new RandomAccessFile(this.db, "rw");
        this.out.seek(this.out.length());
        this.removeUnknownFiles();
        this.mods = 0;
    }

    void compressStreams(DataInputStream in) throws IOException {
        int i = 0;
        try {
            while (true) {
                int action = in.readInt();
                File file = new File(in.readUTF());
                long timeInMyCache = in.readLong();
                long timeoutForOthers = in.readLong();
                if (file.exists()) {
                    switch (action) {
                        case 1: {
                            if (timeInMyCache <= System.currentTimeMillis()) break;
                            this.scheduleFileExpiration(file, timeInMyCache, timeoutForOthers);
                            break;
                        }
                        case 2: {
                            this.cancelFileExpiration(file);
                        }
                    }
                }
                ++i;
            }
        }
        catch (EOFException e) {
            return;
        }
    }

    void removeUnknownFiles() {
        Enumeration e = this.docDirs.elements();
        while (e.hasMoreElements()) {
            File dir = (File)e.nextElement();
            this.removeUnknownFiles(dir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeUnknownFiles(File dir) {
        String[] list = dir.list();
        int i = 0;
        while (true) {
            block9: {
                if (list == null || i >= list.length) {
                    return;
                }
                File f = new File(dir, list[i]);
                if (!f.isDirectory() && this.hash.get(f.getAbsolutePath()) == null && f.getName().indexOf("scheduler.db") == -1) {
                    Object var7_6;
                    try {
                        block8: {
                            try {
                                if (this.listener == null) break block8;
                                this.listener.expiredAndRemove(f);
                            }
                            catch (Throwable t) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)"Throwable caught while dispatching expiration listener.", t);
                                }
                                var7_6 = null;
                                f.delete();
                                break block9;
                            }
                        }
                        var7_6 = null;
                        f.delete();
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        f.delete();
                        throw throwable;
                    }
                }
            }
            ++i;
        }
    }

    public static void main(String[] argv) throws IOException {
        SchedulerService ss = new SchedulerService();
        File dir = new File(argv[0]);
        Thread t = new Thread(ss);
        t.start();
        FileExpirationService fes = new FileExpirationService(ss, dir, null, null);
        fes.addDocDir(new File("testdir/"));
        long time = System.currentTimeMillis() + 30000L;
        fes.scheduleFileExpiration(new File("testdir/test1"), time, time);
        fes.scheduleFileExpiration(new File("testdir/test2"), time, time);
        fes.scheduleFileExpiration(new File("testdir/test3"), time, time);
        fes.cancelFileExpiration(new File("testdir/test2"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ExpireAction
    implements SchedulerService.Action {
        Entry entry;

        ExpireAction(Entry entry) {
            this.entry = entry;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(SchedulerService ss) {
            try {
                block9: {
                    try {
                        if (FileExpirationService.this.listener == null) break block9;
                        FileExpirationService.this.listener.expiredAndRemove(this.entry.file);
                    }
                    catch (Throwable t) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Throwable caught while dispatching expiration listener.", t);
                        }
                        Object var4_3 = null;
                        FileExpirationService fileExpirationService3 = FileExpirationService.this;
                        synchronized (fileExpirationService3) {
                            this.entry.file.delete();
                            FileExpirationService.this.hash.remove(this.entry.file.getAbsolutePath());
                            return;
                        }
                    }
                }
                Object var4_2 = null;
                FileExpirationService fileExpirationService = FileExpirationService.this;
                synchronized (fileExpirationService) {
                    this.entry.file.delete();
                    FileExpirationService.this.hash.remove(this.entry.file.getAbsolutePath());
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                FileExpirationService fileExpirationService2 = FileExpirationService.this;
                synchronized (fileExpirationService2) {
                    this.entry.file.delete();
                    FileExpirationService.this.hash.remove(this.entry.file.getAbsolutePath());
                    throw throwable;
                }
            }
        }
    }

    class CleanupAction
    implements SchedulerService.Action {
        CleanupAction() {
        }

        public void perform(SchedulerService ss) {
            block3: {
                try {
                    if (FileExpirationService.this.db.exists()) {
                        FileExpirationService.this.compress();
                    }
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                    LOG.debug((Object)"Compression of log stream failed.", (Throwable)e);
                }
            }
            FileExpirationService.this.pendingCompressAction = ss.scheduleAction(this, 1800000L);
        }
    }

    class Entry {
        File file;
        SchedulerService.PendingAction myPendingAction;
        long timeInMyCache;
        long timeoutForOthers;

        Entry(File file, long timeInMyCache, long timeoutForOthers) {
            this.file = file;
            this.timeInMyCache = timeInMyCache;
            this.timeoutForOthers = timeoutForOthers;
        }
    }

    static interface ExpirationListener {
        public void expiredAndRemove(File var1);
    }
}

