/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.jxta.index.IndexService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class CmIndexerThread
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$CmIndexerThread == null ? (class$net$jxta$impl$cm$CmIndexerThread = CmIndexerThread.class$("net.jxta.impl.cm.CmIndexerThread")) : class$net$jxta$impl$cm$CmIndexerThread).getName());
    private File[] dirs;
    private IndexService.Index[] indexes;
    static /* synthetic */ Class class$net$jxta$impl$cm$CmIndexerThread;

    CmIndexerThread(File[] dirs, IndexService.Index[] indexes) {
        this.dirs = dirs;
        this.indexes = indexes;
    }

    public void run() {
        block14: {
            try {
                int i = 0;
                while (i < this.dirs.length) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Starting to index " + this.dirs[i]));
                    }
                    String[] fn = this.dirs[i].list();
                    int j = 0;
                    while (j < fn.length) {
                        block13: {
                            File f = new File(this.dirs[i], fn[j]);
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Indexing " + fn[j] + " in " + this.dirs[i]));
                            }
                            try {
                                this.indexFile(this.indexes[i], f);
                            }
                            catch (IOException e) {
                                if (LOG.isEnabledFor(Priority.WARN)) {
                                    LOG.warn((Object)("IOX! NOT Indexing " + fn[j] + " in " + this.dirs[i]));
                                }
                            }
                            catch (IndexService.BadDocumentException e) {
                                if (LOG.isEnabledFor(Priority.WARN)) {
                                    LOG.warn((Object)("BADDOC! NOT Indexing " + fn[j] + " in " + this.dirs[i]));
                                }
                            }
                            catch (IndexService.IndexException e) {
                                if (!LOG.isEnabledFor(Priority.WARN)) break block13;
                                LOG.warn((Object)("INDX! NOT Indexing " + fn[j] + " in " + this.dirs[i]));
                            }
                        }
                        ++j;
                    }
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Finished indexing " + this.dirs[i]));
                    }
                    ++i;
                }
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break block14;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
    }

    private void indexFile(IndexService.Index index, File f) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
        FileInputStream in = null;
        in = new FileInputStream(f);
        if (in == null && LOG.isEnabledFor(Priority.ERROR)) {
            LOG.error((Object)"indexing file which could not be opened");
        }
        if (f.getName() == null && LOG.isEnabledFor(Priority.ERROR)) {
            LOG.error((Object)"indexing file with null pathName");
        }
        if (index == null && LOG.isEnabledFor(Priority.ERROR)) {
            LOG.error((Object)"indexing into null index");
        }
        index.add(f.getName(), in);
        if (in != null) {
            in.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

