/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.id;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.util.ClassFactory;
import sun.net.www.protocol.urn.Handler;

public final class IDFactory
extends ClassFactory {
    private static IDFactory factory = new IDFactory();
    private static Hashtable IdTypes = new Hashtable();
    private boolean loadedString = false;
    private String idNewInstances = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    private IDFactory() {
    }

    private boolean doRegisterIDTypes() {
        String idInstances = "net.jxta.id.jxta.IDFormat net.jxta.impl.id.UUID.IDFormat net.jxta.impl.id.unknown.IDFormat";
        this.idNewInstances = new String("uuid");
        return factory.registerFromString("net.jxta.id.jxta.IDFormat net.jxta.impl.id.UUID.IDFormat net.jxta.impl.id.unknown.IDFormat");
    }

    protected Hashtable getAssocTable() {
        return IdTypes;
    }

    protected Class getClassForKey() {
        return class$java$lang$String == null ? (class$java$lang$String = IDFactory.class$("java.lang.String")) : class$java$lang$String;
    }

    protected Class getClassOfInstantiators() {
        return class$java$lang$Object == null ? (class$java$lang$Object = IDFactory.class$("java.lang.Object")) : class$java$lang$Object;
    }

    protected boolean registerAssoc(String className) {
        boolean registeredSomething = false;
        try {
            Class<?> idClass = Class.forName(className);
            Instantiator instantiator = (Instantiator)idClass.getField("INSTANTIATOR").get(null);
            String idType = instantiator.getSupportedIDFormat();
            registeredSomething = this.registerAssoc(idType, instantiator);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return registeredSomething;
    }

    public static boolean registerIDType(int type, Class instanceClass) {
        boolean result = factory.registerAssoc(new Integer(type), instanceClass);
        return result;
    }

    public static ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        Instantiator instantiator;
        ID result = null;
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        String decoded = Handler.decodeURN(encoded);
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected. (jxta!=" + decoded.substring(0, colonAt) + ")");
        }
        int dashAt = (decoded = decoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        decoded = decoded.substring(0, dashAt);
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        try {
            instantiator = (Instantiator)factory.getInstantiator(decoded);
        }
        catch (NoSuchElementException itsUnknown) {
            instantiator = (Instantiator)factory.getInstantiator("unknown");
        }
        result = instantiator.fromURL(source);
        return result;
    }

    public static CodatID newCodatID(PeerGroupID groupID) {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newCodatID(groupID);
    }

    public static CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newCodatID(groupID, in);
    }

    public static PeerID newPeerID(PeerGroupID groupID) {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newPeerID(groupID);
    }

    public static PeerGroupID newPeerGroupID() {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newPeerGroupID();
    }

    public static PipeID newPipeID(PeerGroupID groupID) {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newPipeID(groupID);
    }

    public static PipeID newPipeID(PeerGroupID groupID, byte[] seed) {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newPipeID(groupID, seed);
    }

    public static ModuleClassID newModuleClassID() {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newModuleClassID();
    }

    public static ModuleClassID newModuleClassID(ModuleClassID baseClass) {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newModuleClassID(baseClass);
    }

    public static ModuleSpecID newModuleSpecID(ModuleClassID baseClass) {
        if (!IDFactory.factory.loadedString) {
            IDFactory.factory.loadedString = factory.doRegisterIDTypes();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(IDFactory.factory.idNewInstances);
        return instantiator.newModuleSpecID(baseClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Instantiator {
        public String getSupportedIDFormat();

        public ID fromURL(URL var1) throws MalformedURLException, UnknownServiceException;

        public CodatID newCodatID(PeerGroupID var1);

        public CodatID newCodatID(PeerGroupID var1, InputStream var2) throws IOException;

        public PeerID newPeerID(PeerGroupID var1);

        public PeerGroupID newPeerGroupID();

        public PipeID newPipeID(PeerGroupID var1);

        public PipeID newPipeID(PeerGroupID var1, byte[] var2);

        public ModuleClassID newModuleClassID();

        public ModuleClassID newModuleClassID(ModuleClassID var1);

        public ModuleSpecID newModuleSpecID(ModuleClassID var1);
    }
}

