/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.ProviderException;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.LiteXMLElement;

public final class DocTest
extends TestCase {
    public DocTest(String name) {
        super(name);
    }

    private void _test(MimeMediaType type) {
        try {
            String useDocType = "Test";
            StructuredTextDocument doc = null;
            try {
                doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(type, "Test");
            }
            catch (Throwable thrown) {
                Assert.fail((String)("exception thrown during construction!" + thrown.toString()));
            }
            Assert.assertTrue((String)("could not construct object for type : " + type), (doc != null ? 1 : 0) != 0);
            String itsType = doc.getName();
            Assert.assertTrue((String)"returned doctype does not equal type document was created with!", (boolean)"Test".equals(itsType));
            Assert.assertTrue((String)"returned doc name does not equal name of document element", (boolean)doc.getName().equals(itsType));
            TextElement testElement = doc.createElement("element");
            doc.appendChild(testElement);
            try {
                Element firstchild = (Element)doc.getChildren().nextElement();
                Assert.assertTrue((String)"added a single element, but something else was returned", (boolean)testElement.equals(firstchild));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"added a single element, but it was not returned");
            }
            String useName = "element2";
            String useValue = "value&<!";
            TextElement testElement2 = doc.createElement("element2", "value&<!");
            testElement.appendChild(testElement2);
            String itsName = testElement2.getName();
            Assert.assertTrue((String)"name of element was not correct after creation", (boolean)"element2".equals(itsName));
            String itsValue = testElement2.getTextValue();
            Assert.assertTrue((String)("value of element was not correct after creation. was '" + itsValue + "' should be '" + "value&<!" + "'"), (boolean)"value&<!".equals(itsValue));
            testElement2 = doc.createElement("element3", "value&<!");
            testElement.appendChild(testElement2);
            testElement2 = doc.createElement("element4", "1");
            testElement.appendChild(testElement2);
            itsValue = testElement2.getTextValue();
            Assert.assertTrue((String)"value of element was not correct after creation (length 1)", (boolean)"1".equals(itsValue));
            int count = 0;
            Enumeration eachChild = doc.getChildren();
            while (eachChild.hasMoreElements()) {
                ++count;
                eachChild.nextElement();
            }
            Assert.assertTrue((String)"Doc didnt have one child", (1 == count ? 1 : 0) != 0);
            count = 0;
            Enumeration eachChild2 = doc.getChildren("element");
            while (eachChild2.hasMoreElements()) {
                ++count;
                eachChild2.nextElement();
            }
            Assert.assertTrue((String)"Doc didnt have one child named 'element'", (1 == count ? 1 : 0) != 0);
            count = 0;
            Enumeration eachChild3 = doc.getChildren("bogus");
            while (eachChild3.hasMoreElements()) {
                ++count;
                eachChild3.nextElement();
            }
            Assert.assertTrue((String)" Doc shouldnt have had a child named 'bogus'", (0 == count ? 1 : 0) != 0);
            count = 0;
            Enumeration eachChild4 = testElement.getChildren();
            while (eachChild4.hasMoreElements()) {
                ++count;
                eachChild4.nextElement();
            }
            Assert.assertTrue((String)"element didnt have expected number of children", (3 == count ? 1 : 0) != 0);
            count = 0;
            Enumeration eachChild5 = testElement.getChildren("element2");
            while (eachChild5.hasMoreElements()) {
                ++count;
                eachChild5.nextElement();
            }
            Assert.assertTrue((String)"element didnt have expected number of children named 'element2'", (1 == count ? 1 : 0) != 0);
            TextElement testElement3 = doc.createElement("element2", "value&<!");
            testElement2.appendChild((Element)testElement3);
            testElement3 = doc.createElement("element2");
            testElement2.appendChild((Element)testElement3);
            count = 0;
            Enumeration eachChild6 = testElement2.getChildren("element2");
            while (eachChild6.hasMoreElements()) {
                ++count;
                eachChild6.nextElement();
            }
            Assert.assertTrue((String)"element didnt have expected number of children named 'element2'", (2 == count ? 1 : 0) != 0);
            if (testElement instanceof Attributable) {
                this._testAttributes((Attributable)((Object)testElement));
                this._testAttributes((Attributable)((Object)testElement3));
            }
            StructuredDocument likeMe = null;
            try {
                likeMe = StructuredDocumentFactory.newStructuredDocument(doc.getMimeType(), doc.getStream());
            }
            catch (ProviderException thrown) {
            }
            catch (Throwable thrown) {
                Assert.fail((String)("Exception thrown during construction!" + thrown.toString()));
            }
            StringWriter somewhere = new StringWriter();
            doc.sendToWriter(somewhere);
            String docAsString = ((Object)somewhere).toString().trim();
            testElement3 = doc.createElement("element2", docAsString);
            testElement2.appendChild((Element)testElement3);
            String docFromElement = (String)testElement3.getValue();
            Assert.assertTrue((String)"Could not faithfully store stream representation of doc in doc. (lengths dont match)", (docAsString.length() == docFromElement.length() ? 1 : 0) != 0);
            int eachChar = 0;
            while (eachChar < docAsString.length()) {
                Assert.assertTrue((String)("Could not faithfully store stream representation of doc in doc. (failed at index: " + eachChar + ")"), (docAsString.charAt(eachChar) == docFromElement.charAt(eachChar) ? 1 : 0) != 0);
                ++eachChar;
            }
        }
        catch (Throwable everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public void _testAttributes(Attributable element) {
        try {
            String someName = "attrName";
            String someValue = "attrValue";
            Enumeration attribs = element.getAttributes();
            Assert.assertTrue((String)"Element already had attributes!", (!attribs.hasMoreElements() ? 1 : 0) != 0);
            Assert.assertTrue((String)"New attribute returned previous value!", (null == element.addAttribute("attrName", "attrValue") ? 1 : 0) != 0);
            String oldValue = element.addAttribute(new Attribute("attrName", "attrValue"));
            Assert.assertTrue((String)"New attribute didnt return previous value!", (null != oldValue && oldValue.equals("attrValue") ? 1 : 0) != 0);
            Attribute anAttrib = element.getAttribute("attrName");
            Assert.assertTrue((String)"Could not get attribute back!", (null != anAttrib ? 1 : 0) != 0);
            Assert.assertTrue((String)"value of attribute was not correct", (boolean)anAttrib.getValue().equals("attrValue"));
            anAttrib = element.getAttribute("bogusName");
            Assert.assertTrue((String)"Should not have been able to get an unknown attribute name", (null == anAttrib ? 1 : 0) != 0);
        }
        catch (Throwable everything) {
            everything.printStackTrace();
            Assert.fail((String)("Caught an unexpected exception - " + everything.toString()));
        }
    }

    public void _testAttributesSolo(MimeMediaType type) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            LiteXMLDocument doc = new LiteXMLDocument(type, "Message");
            doc.addAttribute("version", "123");
            doc.sendToStream(os);
            String old = doc.addAttribute("version", "1xx23");
            Assert.assertTrue((String)"updating attribute gave wrong result", (boolean)"123".equals(old));
            doc.sendToStream(os);
        }
        catch (Throwable everything) {
            everything.printStackTrace();
            Assert.fail((String)("Caught an unexpected exception - " + everything.toString()));
        }
    }

    public static void copyElements(StructuredDocument intoDoc, Element intoElement, Element from) {
        Object fromKey = from.getKey();
        Object fromValue = from.getValue();
        Element newElement = intoDoc.createElement(fromKey, fromValue);
        intoElement.appendChild(newElement);
        Enumeration eachChild = from.getChildren();
        while (eachChild.hasMoreElements()) {
            Element aChild = (Element)eachChild.nextElement();
            DocTest.copyElements(intoDoc, newElement, aChild);
        }
    }

    public void testXMLStructuredDoc() {
        this._test(new MimeMediaType("Text/Xml"));
        this._testAttributesSolo(new MimeMediaType("Text/Xml"));
    }

    public void testPlainTextDoc() {
        this._test(new MimeMediaType("Text/Plain"));
        this._testAttributesSolo(new MimeMediaType("Text/Plain"));
    }

    public void testExtensionMapping() {
        MimeMediaType refMime = new MimeMediaType("Text/Xml");
        String refExt = "xml";
        String ext = StructuredDocumentFactory.getFileExtensionForMimeType(refMime);
        MimeMediaType mime = StructuredDocumentFactory.getMimeTypeForFileExtension(ext);
        Assert.assertTrue((String)"mime type was not the same after reflex mapping", (boolean)refMime.equals(mime));
        Assert.assertTrue((String)"extension was not the same after reflex mapping", (boolean)refExt.equals(ext));
    }

    public void testIssue102() {
        String WORKS = "<xml><stooges>Moe, Larry, &#x41;&#65;&#0666;& Curly</stooges></xml>";
        String DOES_NOT_WORK = "<xml><stooges>Moe, Larry, & Joe</stooges></xml>";
        LiteXMLBug works = new LiteXMLBug(WORKS);
        LiteXMLBug doesNotWork = new LiteXMLBug(DOES_NOT_WORK);
    }

    public static void main(String[] args) {
        new TestRunner();
        TestRunner.main((String[])new String[]{"DocTest"});
    }

    public static class LiteXMLBug {
        public LiteXMLBug(String xml) {
            MimeMediaType mimeMediaType = new MimeMediaType("text/plain");
            StringReader reader = new StringReader(xml);
            try {
                LiteXMLDocument document = new LiteXMLDocument(mimeMediaType, reader);
                this.spew(document);
                Object var6_5 = null;
                reader.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                reader.close();
                throw throwable;
            }
        }

        public void spew(LiteXMLElement element) {
            System.out.println(element.getValue());
            Enumeration children = element.getChildren();
            while (children.hasMoreElements()) {
                LiteXMLElement child = (LiteXMLElement)children.nextElement();
                this.spew(child);
            }
        }
    }
}

