/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openprivacy.panther.implementations.CacheNode;
import talon.util.net.URI;

public class CacheConstructor {
    private static Hashtable cacheNodes = new Hashtable();

    public static CacheNode construct(URI location) throws IOException {
        CacheNode node = CacheConstructor.getCacheNode(location.toString());
        if (node != null) {
            return node;
        }
        String root = System.getProperty("panther.root");
        if (root == null) {
            root = System.getProperty("java.io.tmpdir") + "/panther/cache/";
        }
        root = new File(root).getAbsolutePath() + "/";
        root = root + location.getScheme() + "/";
        root = CacheConstructor.constructHostPortion(root, location);
        root = CacheConstructor.constructPathPortion(root, location);
        root = CacheConstructor.constructXML(root);
        node = new CacheNode(root, true);
        CacheConstructor.setCacheNode(location.toString(), node);
        return node;
    }

    public static CacheNode construct(String location) throws IOException {
        return CacheConstructor.construct(new URI(location));
    }

    private static final String constructHostPortion(String root, URI location) throws IOException {
        String hostname = location.getURL().getHost();
        StringTokenizer tok = new StringTokenizer(hostname, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            root = root + token + "/";
        }
        return root;
    }

    private static final String constructPathPortion(String root, URI location) throws IOException {
        String scheme = location.getScheme();
        String host = location.getURL().getHost();
        int start = scheme.length() + "::/".length() + host.length();
        int end = location.toString().lastIndexOf("/");
        if (end < 0 || start > end) {
            new File(root).mkdirs();
            return root;
        }
        String path = location.toString().substring(start, end);
        StringTokenizer tok = new StringTokenizer(path, "/");
        String current = root;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            current = current + token + "/";
        }
        new File(current).mkdirs();
        return current;
    }

    public static final String constructXML(String root) throws IOException {
        String filename = root + "/" + "data.xml";
        if (!new File(filename).exists()) {
            PrintWriter pw = new PrintWriter(new FileWriter(filename));
            pw.println("<cache xmlns=\"http://schemas.openprivacy.org/panther/cache\">");
            pw.println("</cache>");
            pw.close();
        }
        return filename;
    }

    public static final CacheNode getCacheNode(String location) {
        return (CacheNode)cacheNodes.get(location);
    }

    public static final void setCacheNode(String location, CacheNode node) {
        cacheNodes.put(location, node);
    }
}

