/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleSupport;

public class StandardManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
Runnable {
    private int checkInterval = 60;
    private static final String info = "StandardManager/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static String name = "StandardManager";
    private String pathname = "SESSIONS.ser";
    private boolean started = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "StandardManager";

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(ManagerBase.sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    private File file() {
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && this.container instanceof Context && (tempdir = (File)(servletContext = ((Context)this.container).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void load() throws ClassNotFoundException, IOException {
        Object bis;
        if (this.debug >= 1) {
            this.log("Start: Loading persisted sessions");
        }
        this.recycled.clear();
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(ManagerBase.sm.getString("standardManager.loading", this.pathname));
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            if (this.container != null) {
                loader = this.container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                if (this.debug >= 1) {
                    this.log("Creating custom object input stream for class loader " + classLoader);
                }
                ois = new CustomObjectInputStream((InputStream)bis, classLoader);
            } else {
                if (this.debug >= 1) {
                    this.log("Creating standard object input stream");
                }
                ois = new ObjectInputStream((InputStream)bis);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.debug >= 1) {
                this.log("No persisted data file found");
            }
            return;
        }
        catch (IOException e) {
            this.log(ManagerBase.sm.getString("standardManager.loading.ioe", e), e);
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
                ois = null;
            }
            throw e;
        }
        bis = this.sessions;
        synchronized (bis) {
            try {
                try {
                    Integer count = (Integer)ois.readObject();
                    int n = count;
                    if (this.debug >= 1) {
                        this.log("Loading " + n + " persisted sessions");
                    }
                    int i = 0;
                    while (i < n) {
                        StandardSession session = new StandardSession(this);
                        session.readObjectData(ois);
                        session.setManager(this);
                        this.sessions.put(session.getId(), session);
                        session.activate();
                        ++i;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.log(ManagerBase.sm.getString("standardManager.loading.cnfe", e), e);
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                        ois = null;
                    }
                    throw e;
                }
                catch (IOException e) {
                    this.log(ManagerBase.sm.getString("standardManager.loading.ioe", e), e);
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                        ois = null;
                    }
                    throw e;
                }
                Object var9_14 = null;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException iOException) {}
                if (file != null && file.exists()) {
                    file.delete();
                }
                throw throwable;
            }
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        if (this.debug >= 1) {
            this.log("Finish: Loading persisted sessions");
        }
    }

    private void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            int timeIdle;
            int maxInactiveInterval;
            StandardSession session = (StandardSession)sessions[i];
            if (session.isValid() && (maxInactiveInterval = session.getMaxInactiveInterval()) >= 0 && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) >= maxInactiveInterval) {
                try {
                    session.expire();
                }
                catch (Throwable t) {
                    this.log(ManagerBase.sm.getString("standardManager.expireException"), t);
                }
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        block3: {
            if (!(event.getSource() instanceof Context)) {
                return;
            }
            Context context = (Context)event.getSource();
            if (!event.getPropertyName().equals("sessionTimeout")) break block3;
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(ManagerBase.sm.getString("standardManager.sessionTimeout", event.getNewValue().toString()));
            }
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", new Integer(oldCheckInterval), new Integer(this.checkInterval));
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    public void start() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Starting");
        }
        if (this.started) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.debug >= 1) {
            this.log("Force random number initialization starting");
        }
        String dummy = this.generateSessionId();
        if (this.debug >= 1) {
            this.log("Force random number initialization completed");
        }
        try {
            this.load();
        }
        catch (Throwable t) {
            this.log(ManagerBase.sm.getString("standardManager.managerLoad"), t);
        }
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        if (!this.started) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
        try {
            this.unload();
        }
        catch (IOException e) {
            this.log(ManagerBase.sm.getString("standardManager.managerUnload"), e);
        }
        Session[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            StandardSession session = (StandardSession)sessions[i];
            if (session.isValid()) {
                try {
                    session.expire();
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
        this.random = null;
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardManager[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }

    public void unload() throws IOException {
        File file;
        if (this.debug >= 1) {
            this.log("Unloading persisted sessions");
        }
        if ((file = this.file()) == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(ManagerBase.sm.getString("standardManager.unloading", this.pathname));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            this.log(ManagerBase.sm.getString("standardManager.unloading.ioe", e), e);
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
                oos = null;
            }
            throw e;
        }
        ArrayList<StandardSession> list = new ArrayList<StandardSession>();
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            if (this.debug >= 1) {
                this.log("Unloading " + this.sessions.size() + " sessions");
            }
            try {
                oos.writeObject(new Integer(this.sessions.size()));
                Iterator elements = this.sessions.values().iterator();
                while (elements.hasNext()) {
                    StandardSession session = (StandardSession)elements.next();
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
            catch (IOException e) {
                this.log(ManagerBase.sm.getString("standardManager.unloading.ioe", e), e);
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                    oos = null;
                }
                throw e;
            }
        }
        try {
            oos.flush();
            oos.close();
            oos = null;
        }
        catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
                oos = null;
            }
            throw e;
        }
        if (this.debug >= 1) {
            this.log("Expiring " + list.size() + " persisted sessions");
        }
        Iterator expires = ((AbstractList)list).iterator();
        while (expires.hasNext()) {
            StandardSession session = (StandardSession)expires.next();
            try {
                session.expire();
            }
            catch (Throwable throwable) {}
        }
        if (this.debug >= 1) {
            this.log("Unloading complete");
        }
    }
}

