/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.cipher;

import jxta.security.cipher.Cipher;
import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.util.Util;

public final class RC4Cipher
implements Cipher {
    private byte type = (byte)4;
    private byte mode = (byte)99;
    private byte[] S = null;
    private int ii = 0;
    private int jj = 0;
    private static String myname = "RC4 Cipher";
    private boolean debug = false;
    static final int buflen = 256;

    public String getAlgorithmName() {
        return myname;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public byte getAlgorithm() {
        return 4;
    }

    public void init(Key key, byte by, byte[] byArray, int n, int n2) throws CryptoException {
        throw new CryptoException(1);
    }

    public void init(Key key, byte by) throws CryptoException {
        int n;
        if (key.getType() != 8 || by != 1 && by != 2) {
            throw new CryptoException(2);
        }
        this.mode = by;
        this.S = new byte[256];
        byte[] byArray = new byte[key.getSize() + 7 >>> 3];
        SecretKey secretKey = (SecretKey)key;
        secretKey.getKey(byArray, 0);
        int n2 = 0;
        while (n2 < 256) {
            this.S[n2] = (byte)n2;
            ++n2;
        }
        byte[] byArray2 = new byte[256];
        int n3 = 0;
        while (n3 < 256) {
            n = 0;
            while (n < byArray.length && n3 < 256) {
                byArray2[n3++] = byArray[n];
                ++n;
            }
        }
        if (this.debug) {
            System.out.println("key : " + Util.hexEncode(byArray));
            System.out.println("K   : " + Util.hexEncode(byArray2));
        }
        n = 0;
        int n4 = 0;
        while (n4 < 256) {
            n = n + (this.S[n4] + byArray2[n4] & 0xFF) & 0xFF;
            byte by2 = this.S[n4];
            this.S[n4] = this.S[n];
            this.S[n] = by2;
            ++n4;
        }
        if (this.debug) {
            System.out.println("S   : " + Util.hexEncode(this.S));
        }
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            this.ii = this.ii + 1 & 0xFF;
            byte by = this.S[this.ii];
            this.jj = this.jj + (by & 0xFF) & 0xFF;
            this.S[this.ii] = this.S[this.jj];
            this.S[this.jj] = by;
            int n5 = this.S[this.ii] + by & 0xFF;
            byte by2 = this.S[n5];
            byArray2[n3 + n4] = (byte)(byArray[n + n4] ^ by2);
            ++n4;
        }
        return n2;
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        if (n2 < 0 || n + n2 > byArray.length || n3 + n2 > byArray2.length) {
            throw new CryptoException(1);
        }
        if (this.mode == 99) {
            throw new CryptoException(3);
        }
        int n4 = this.transform(byArray, n, n2, byArray2, n3);
        return n4;
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        int n4 = this.update(byArray, n, n2, byArray2, n3);
        this.mode = (byte)99;
        this.S = null;
        this.jj = 0;
        this.ii = 0;
        return n4;
    }
}

