<?xml version="1.0"?> 

<!--

$Id: edit-channel.xsl,v 1.3 2001/09/24 08:52:29 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

-->

<xsl:stylesheet xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.edit-channel.title" select="''"/>

    <xsl:param name="reptile.edit-channel.description" select="''"/>

    <xsl:param name="reptile.edit-channel.image.title" select="''"/>

    <xsl:param name="reptile.edit-channel.image.link" select="''"/>

    <xsl:param name="reptile.edit-channel.image.url" select="''"/>
    
    <!-- this should be the contentType and location of the channel that you
    need to update -->

    <xsl:template match="/rdf:RDF">

        <xsl:message>within edit channel...</xsl:message>

        <rdf:RDF>

            <xsl:apply-templates/>

        </rdf:RDF>

    </xsl:template>

    <!-- update channel information  -->
    <xsl:template match="rss:channel">

        <xsl:message>FOUND IT MAN!!!...</xsl:message>

        <rss:channel>

            <rss:title><xsl:value-of select="$reptile.edit-channel.title"/></rss:title>

            <rss:description><xsl:value-of select="$reptile.edit-channel.description"/></rss:description>

            <rss:image rdf:about="{$reptile.edit-channel.image.url}">

                <rss:title><xsl:value-of select="$reptile.edit-channel.image.title"/></rss:title>

                <rss:link><xsl:value-of select="$reptile.edit-channel.image.link"/></rss:link>

                <rss:url><xsl:value-of select="$reptile.edit-channel.image.url"/></rss:url>

            </rss:image>

        </rss:channel>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:channel/rss:title"/>
    <xsl:template match="/rdf:RDF/rss:channel/rss:description"/>

</xsl:stylesheet>

