<?xml version="1.0"?> 

<!--

$Id: mozilla-content-feeds.xsl,v 1.3 2001/08/09 23:59:33 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:content-feeds="http://schemas.openprivacy.org/reptile/content-feeds"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
                extension-element-prefixes="proxy"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <xsl:template match="/content-feeds:content-feeds">

            <control:content>

                <dc:title>Registered content feeds.</dc:title>

                <control:body>

                <p>
                The following content feeds are available:
                </p>

                <xsl:apply-templates/>

                </control:body>

            </control:content>

    </xsl:template>

    <xsl:template match="content-feeds:feed">

        <logo-producer:bullet/>

        <b>Name: </b> <xsl:value-of select="dc:title"/>

        <blockquote>

            <h4>Resource information: </h4>

            <b>Location: </b>

            <xsl:value-of select="@location"/>

            <!--  For some reason this wasn't working... -->
            <!--  <link-producer:link link-name="urn:view-source" location="{@location}" name="{@location}"/> -->

            <br/>

            <b>Content Type: </b> <xsl:value-of select="@contentType"/>
            <br/>

            <h4>Updating settings: </h4>
            
            <b>Update period: </b> <xsl:value-of select="sy:updatePeriod"/>
            <br/>

            <b>Update frequency: </b> <xsl:value-of select="sy:updateFrequency"/>
            <br/>

            <h4>Proxy information: </h4>

            <b>Last updated:  </b>  <proxy:lastModified location="{@location}"/>
            <br/>

            <b>Next update:  </b>  <proxy:nextUpdate location="{@location}"/>
            <br/>                 

            <b>Update interval:  </b>  <proxy:updateInterval location="{@location}"/>
            <br/>                 



        </blockquote>

        <br/>

    </xsl:template>

</xsl:stylesheet>

