/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();
    private boolean bAdd;
    private boolean bRemove;
    private static final int MAX_LINELENGTH = 82;

    public static void main(String[] stringArray) {
        CodeSwitcher codeSwitcher = new CodeSwitcher();
        if (stringArray.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.startsWith("+")) {
                if (string.length() == 1) {
                    codeSwitcher.bAdd = true;
                } else {
                    codeSwitcher.vSwitchOn.addElement(string.substring(1));
                }
            } else if (string.startsWith("-")) {
                if (string.length() == 1) {
                    codeSwitcher.bRemove = true;
                } else {
                    codeSwitcher.vSwitchOff.addElement(string.substring(1));
                }
            } else {
                codeSwitcher.addDir(string);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            CodeSwitcher.printError("no path specified");
            CodeSwitcher.showUsage();
        }
        codeSwitcher.process();
        if (codeSwitcher.vSwitchOff.size() == 0 && codeSwitcher.vSwitchOn.size() == 0) {
            codeSwitcher.printSwitches();
        }
    }

    static void showUsage() {
        System.out.println("Usage: java CodeSwitcher [paths] [labels] [+][-]");
        System.out.println("If no labels are specified then all used");
        System.out.println("labels in the source code are shown.");
        System.out.println("Use +MODE to switch on the things labeld MODE");
        System.out.println("Use -MODE to switch off the things labeld MODE");
        System.out.println("Path: Any number of path or files may be");
        System.out.println("specified. Use . for the current directory");
        System.out.println("(including sub-directories).");
        System.out.println("Example: java CodeSwitcher +JAVA2 .");
        System.out.println("This example switches on code labeled JAVA2");
        System.out.println("in all *.java files in the current directory");
        System.out.println("and all subdirectories.");
        System.out.println("java CodeSwitcher + .");
        System.out.println("Adds test code to the code.");
        System.out.println("java CodeSwitcher - .");
        System.out.println("Removed test code from the code.");
    }

    CodeSwitcher() {
    }

    void process() {
        int n = this.vList.size();
        int n2 = 0;
        while (n2 < n) {
            System.out.print(".");
            String string = (String)this.vList.elementAt(n2);
            if (this.bAdd || this.bRemove) {
                int n3 = this.testFile(string);
                if (this.bAdd && !this.bRemove) {
                    this.addTest(string, n3);
                } else {
                    this.removeTest(string);
                }
            } else if (!this.processFile(string)) {
                System.out.println("in file " + string + " !");
            }
            ++n2;
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        int n = 0;
        while (n < this.vSwitches.size()) {
            System.out.println((String)this.vSwitches.elementAt(n));
            ++n;
        }
    }

    void addDir(String string) {
        File file = new File(string);
        if (file.isFile() && string.endsWith(".java")) {
            this.vList.addElement(string);
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                this.addDir(string + File.separatorChar + stringArray[n]);
                ++n;
            }
        }
    }

    void removeTest(String string) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        try {
            Object object;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            FileWriter fileWriter = new FileWriter(file2);
            while ((object = lineNumberReader.readLine()) != null) {
                if (((String)object).startsWith("Profile.visit(")) {
                    int n = ((String)object).indexOf(59);
                    object = ((String)object).substring(n + 1);
                }
                fileWriter.write((String)object + "\r\n");
            }
            lineNumberReader.close();
            fileWriter.flush();
            fileWriter.close();
            object = new File(string + ".bak");
            ((File)object).delete();
            file.renameTo((File)object);
            File file3 = new File(string);
            file2.renameTo(file3);
            ((File)object).delete();
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
        }
    }

    void addTest(String string, int n) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        String string2 = string;
        string2 = string2.replace('\\', '.');
        try {
            Object object;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            FileWriter fileWriter = new FileWriter(file2);
            int n2 = 0;
            boolean bl = false;
            while ((object = lineNumberReader.readLine()) != null) {
                if (((String)object).startsWith(" ")) {
                    int n3 = 0;
                    while (n3 < ((String)object).length()) {
                        if (((String)object).charAt(n3) != ' ') break;
                        ++n3;
                    }
                    if (n3 > 3 && this.testLine((String)object) && !bl) {
                        object = "Profile.visit(\"" + string2 + "\"," + n2 + "," + n + ");" + (String)object;
                        ++n2;
                    } else {
                        bl = this.isLongline((String)object);
                    }
                }
                fileWriter.write((String)object + "\r\n");
            }
            lineNumberReader.close();
            fileWriter.flush();
            fileWriter.close();
            object = new File(string + ".bak");
            ((File)object).delete();
            file.renameTo((File)object);
            File file3 = new File(string);
            file2.renameTo(file3);
            ((File)object).delete();
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
        }
    }

    int testFile(String string) {
        File file = new File(string);
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            int n = 1;
            int n2 = 0;
            boolean bl = false;
            while ((string2 = lineNumberReader.readLine()) != null) {
                if (string2.length() > 82 && !string2.startsWith("Profile.")) {
                    System.out.println("long line in " + string + " at line " + n);
                }
                if (string2.startsWith(" ")) {
                    int n3 = 0;
                    while (n3 < string2.length()) {
                        if (string2.charAt(n3) != ' ') break;
                        ++n3;
                    }
                    if (n3 > 3 && this.testLine(string2) && !bl) {
                        ++n2;
                    } else {
                        bl = this.isLongline(string2);
                    }
                    String string3 = string2.substring(n3);
                    if (string3.startsWith("if(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("if( without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("} else if(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("} else if without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("while(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("while( without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("switch(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("switch( without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("do ") && !string3.endsWith(" {")) {
                        System.out.println("do without { in " + string + " at line " + n);
                    }
                }
                ++n;
            }
            lineNumberReader.close();
            return n2;
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
            return -1;
        }
    }

    boolean testLine(String string) {
        if (!string.endsWith(";")) {
            return false;
        }
        return !string.trim().startsWith("super(");
    }

    boolean isLongline(String string) {
        char c = string.charAt(string.length() - 1);
        return ",(+-&|".indexOf(c) >= 0;
    }

    boolean processFile(String string) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            Object object2;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            FileWriter fileWriter = new FileWriter(file2);
            while ((object2 = lineNumberReader.readLine()) != null) {
                if (bl2 && (((String)object2).equals("/*") || ((String)object2).equals("*/"))) continue;
                if (!((String)object2).startsWith("//#")) {
                    fileWriter.write((String)object2 + "\r\n");
                    continue;
                }
                if (((String)object2).startsWith("//#ifdef ")) {
                    if (n != 0) {
                        CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                        return false;
                    }
                    fileWriter.write((String)object2 + "\r\n");
                    n = 1;
                    object = ((String)object2).substring(9);
                    if (this.vSwitchOn.indexOf(object) != -1) {
                        bl2 = true;
                        bl = false;
                    } else if (this.vSwitchOff.indexOf(object) != -1) {
                        bl2 = true;
                        fileWriter.write("/*\r\n");
                        bl = true;
                    }
                    if (this.vSwitches.indexOf(object) != -1) continue;
                    this.vSwitches.addElement(object);
                    continue;
                }
                if (((String)object2).startsWith("//#else")) {
                    if (n != 1) {
                        CodeSwitcher.printError("'#else' without '#ifdef'");
                        return false;
                    }
                    n = 2;
                    if (!bl2) {
                        fileWriter.write((String)object2 + "\r\n");
                        continue;
                    }
                    if (bl) {
                        fileWriter.write("*/\r\n");
                        fileWriter.write((String)object2 + "\r\n");
                        bl = false;
                        continue;
                    }
                    fileWriter.write((String)object2 + "\r\n");
                    fileWriter.write("/*\r\n");
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("//#endif")) {
                    if (n == 0) {
                        CodeSwitcher.printError("'#endif' without '#ifdef'");
                        return false;
                    }
                    n = 0;
                    if (bl2 && bl) {
                        fileWriter.write("*/\r\n");
                    }
                    fileWriter.write((String)object2 + "\r\n");
                    bl2 = false;
                    continue;
                }
                fileWriter.write((String)object2 + "\r\n");
            }
            if (n != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            lineNumberReader.close();
            fileWriter.flush();
            fileWriter.close();
            object2 = new File(string + ".bak");
            ((File)object2).delete();
            file.renameTo((File)object2);
            object = new File(string);
            file2.renameTo((File)object);
            ((File)object2).delete();
            return true;
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
            return false;
        }
    }

    static void printError(String string) {
        System.out.println("");
        System.out.println("ERROR: " + string);
    }
}

