/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.jxta;

import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.jxta.Message;
import COM.claymoresystems.ptls.jxta.MessageElement;
import COM.claymoresystems.ptls.jxta.MessageElementEnumeration;
import COM.claymoresystems.ptls.jxta.MessageWireFormat;
import COM.claymoresystems.ptls.jxta.MimeMediaType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MessageWireFormatBinary
extends MessageWireFormat {
    protected static final int HAS_TYPE = 1;
    protected static final int MESSAGE_VERSION = 0;
    protected static final MimeMediaType outputMimeType = new MimeMediaType("application/x-jxta-msg");
    MimeMediaType type;

    public static MimeMediaType getOutputMimeType() {
        return (MimeMediaType)outputMimeType.clone();
    }

    public MessageWireFormatBinary(MimeMediaType mimeMediaType) {
        this.type = mimeMediaType;
    }

    public void writeMessage(OutputStream outputStream, Message message) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        if (SSLDebug.getDebug(128)) {
            System.out.println("\nMessageWireFormatBinary.WriteMessage:");
        }
        dataOutputStream.writeBytes("jxmg");
        dataOutputStream.writeByte(0);
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        this.assignNamespaceIds(message, hashtable, vector);
        this.writeStringVector(dataOutputStream, vector);
        int n = 0;
        MessageElementEnumeration messageElementEnumeration = message.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            messageElementEnumeration.nextElement();
            n = (short)(n + 1);
        }
        if (SSLDebug.getDebug(128)) {
            System.out.println("Write: " + n + " elements");
        }
        dataOutputStream.writeShort(n);
        messageElementEnumeration = message.getElementsInFifoOrder();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            this.writeMessageElement(dataOutputStream, hashtable, message, messageElement);
        }
    }

    public void readMessage(InputStream inputStream, Message message) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readByte() != 106 || dataInputStream.readByte() != 120 || dataInputStream.readByte() != 109 || dataInputStream.readByte() != 103) {
            throw new IOException("ReadMessage: Not a jxmg message");
        }
        if (dataInputStream.readByte() != 0) {
            throw new IOException("Message not version 0");
        }
        int n = dataInputStream.readShort();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        hashtable.put(new Integer(0), "");
        hashtable.put(new Integer(1), "jxta");
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            String string = this.readString(dataInputStream);
            hashtable.put(new Integer(n2++), string);
            ++n3;
        }
        int n4 = dataInputStream.readShort();
        if (SSLDebug.getDebug(128)) {
            System.out.println("Read: " + n4 + " elements");
        }
        if (n4 < 0) {
            throw new IOException("Negative element count");
        }
        int n5 = 0;
        while (n5 < n4) {
            this.readMessageElement(dataInputStream, hashtable, message);
            ++n5;
        }
    }

    private void assignNamespaceIds(Message message, Hashtable hashtable, Vector vector) {
        Enumeration enumeration = message.getNamespaces();
        hashtable.put("", new Integer(0));
        hashtable.put("jxta", new Integer(1));
        int n = 2;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n2 = new Integer(n);
            if (hashtable.get(n2) != null) continue;
            hashtable.put(string, new Integer(n++));
            vector.addElement(string);
        }
    }

    private void readMessageElement(DataInputStream dataInputStream, Hashtable hashtable, Message message) throws IOException {
        if (dataInputStream.readByte() != 106 || dataInputStream.readByte() != 120 || dataInputStream.readByte() != 101 || dataInputStream.readByte() != 108) {
            throw new IOException("Not a message element");
        }
        byte by = dataInputStream.readByte();
        String string = (String)hashtable.get(new Integer(by));
        if (string == null) {
            throw new IOException("bad namespace id");
        }
        byte by2 = dataInputStream.readByte();
        String string2 = this.readString(dataInputStream);
        MimeMediaType mimeMediaType = null;
        if ((by2 & 1) != 0) {
            String string3 = this.readString(dataInputStream);
            mimeMediaType = new MimeMediaType(string3);
        }
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        String string4 = string.equals("") ? string2 : string + ":" + string2;
        MessageElement messageElement = message.newMessageElement(string4, mimeMediaType, byArray, null);
        message.addElement(messageElement);
    }

    private void writeMessageElement(DataOutputStream dataOutputStream, Hashtable hashtable, Message message, MessageElement messageElement) throws IOException {
        MimeMediaType mimeMediaType;
        String[] stringArray = MessageElement.parseName(messageElement.getName());
        String string = stringArray[0];
        String string2 = stringArray[1];
        dataOutputStream.writeByte(106);
        dataOutputStream.writeByte(120);
        dataOutputStream.writeByte(101);
        dataOutputStream.writeByte(108);
        int n = 0;
        Integer n2 = (Integer)hashtable.get(string);
        if (n2 != null) {
            n = n2;
        }
        dataOutputStream.writeByte(n);
        byte by = 0;
        if (messageElement.getType() != null) {
            by = (byte)(by | 1);
        }
        MessageElement messageElement2 = messageElement.getSignature();
        dataOutputStream.writeByte(by);
        if (string2 != null) {
            this.writeString(dataOutputStream, string2);
        }
        if ((mimeMediaType = messageElement.getType()) != null) {
            this.writeString(dataOutputStream, mimeMediaType.toString());
        }
        byte[] byArray = messageElement.getBytesOffset();
        int n3 = messageElement.getLength();
        int n4 = messageElement.getOffset();
        if (SSLDebug.getDebug(128)) {
            System.out.println("WriteElement[" + string2 + "]: len = " + n3 + " offset = " + n4);
        }
        dataOutputStream.writeInt(messageElement.getLength());
        dataOutputStream.write(byArray, messageElement.getOffset(), messageElement.getLength());
    }

    private void writeStringVector(DataOutputStream dataOutputStream, Vector vector) throws IOException {
        dataOutputStream.writeShort(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeString(dataOutputStream, (String)enumeration.nextElement());
        }
    }

    private String readString(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        if (s < 0) {
            throw new IOException("Bad string length in message");
        }
        byte[] byArray = new byte[s];
        dataInputStream.readFully(byArray);
        return new String(byArray, "UTF8");
    }

    private void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeShort(string.length());
        dataOutputStream.write(string.getBytes("UTF8"));
    }
}

