/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.benchmark;

import COM.claymoresystems.util.Bench;
import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;

class SockBench
extends Bench {
    protected String host = "localhost";
    protected int port = 4433;
    protected String keyfile = "server.pem";
    protected String rootfile = "root.pem";
    protected String password = "password";
    protected int iterate = 5;
    protected boolean useNormalSockets = false;
    protected boolean clientauth = false;
    protected boolean profile = false;
    protected boolean noNetwork = false;
    protected int msgSize = 1024;
    protected int msgCount = 20;
    protected byte[] msg = null;
    protected boolean verbose = false;
    protected boolean exitForClose;
    protected int algorithm = 18;

    SockBench(String string, String[] stringArray) {
        int n;
        Getopt getopt = new Getopt(string, stringArray, "psi:m:M:vna:N", null);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 118: {
                    this.verbose = true;
                    break;
                }
                case 105: {
                    this.iterate = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.useNormalSockets = true;
                    break;
                }
                case 109: {
                    this.msgSize = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 77: {
                    this.msgCount = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 110: {
                    this.exitForClose = true;
                    this.iterate = 1;
                    break;
                }
                case 78: {
                    this.noNetwork = true;
                    break;
                }
                case 97: {
                    this.algorithm = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                default: {
                    System.out.println("Bad argument " + n);
                    throw new InternalError();
                }
            }
        }
        Bench.register("socketWrite");
        Bench.register("ourWrite");
        Bench.register("MAC");
        Bench.register("Encrypt");
        Bench.register("Recencode");
        Bench.register("MAC updates");
        Bench.register("XXX");
    }

    protected byte[] getMessage() {
        if (this.msg != null) {
            return this.msg;
        }
        this.msg = new byte[this.msgSize];
        this.msg[0] = (byte)(this.msgSize >> 8 & 0xFF);
        this.msg[1] = (byte)(this.msgSize & 0xFF);
        int n = 2;
        while (n < this.msgSize) {
            this.msg[n] = (byte)(n & 0xFF);
            ++n;
        }
        return this.msg;
    }

    protected byte[] readMessage(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[2];
        int n = bufferedInputStream.read(byArray);
        if (n == -1) {
            return null;
        }
        if (n != 2) {
            throw new InternalError("Short read " + n);
        }
        int n2 = byArray[0] << 8 | byArray[1];
        byte[] byArray2 = new byte[n2];
        int n3 = n2 - 2;
        int n4 = 0;
        if (this.verbose) {
            System.out.println("Length=" + n2);
        }
        while (n3 > 0) {
            n = bufferedInputStream.read(byArray2, n4, n3);
            n3 -= n;
            n4 += n;
            if (this.verbose) {
                System.out.println("Read " + n + "bytes (partial)");
            }
            if (n != 0) continue;
            throw new InternalError();
        }
        if (this.verbose) {
            System.out.println("Read " + n2 + "bytes");
        }
        return byArray2;
    }

    protected void writeMessage(BufferedOutputStream bufferedOutputStream) throws IOException {
        byte[] byArray = this.getMessage();
        Bench.start(2);
        bufferedOutputStream.write(byArray);
        Bench.end(2);
        if (this.verbose) {
            System.out.println("Wrote " + byArray.length + " bytes");
        }
    }
}

