/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.crypto.DHPrivateKey;
import COM.claymoresystems.crypto.DHPublicKey;
import COM.claymoresystems.crypto.PKCS1Pad;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLException;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;

class SSLClientKeyExchange
extends SSLPDU {
    SSLopaque client_data = new SSLopaque(-65535);

    SSLClientKeyExchange() {
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws IOException {
        switch (sSLConn.hs.cipher_suite.getKeyExchangeAlg()) {
            case 1: {
                DHPublicKey dHPublicKey = (DHPublicKey)sSLConn.hs.peerEncryptionKey;
                DHPrivateKey dHPrivateKey = DHPrivateKey.getInstance();
                dHPrivateKey.initPrivateKey(dHPublicKey.getg(), dHPublicKey.getp(), sSLConn.hs.rng);
                this.client_data.value = dHPrivateKey.getYBytes();
                sSLConn.hs.pre_master_secret = dHPrivateKey.keyAgree(dHPublicKey, true);
                return this.client_data.encode(sSLConn, outputStream);
            }
            case 2: {
                try {
                    sSLConn.hs.pre_master_secret = new byte[48];
                    sSLConn.hs.rng.nextBytes(sSLConn.hs.pre_master_secret);
                    sSLConn.hs.pre_master_secret[0] = 3;
                    sSLConn.hs.pre_master_secret[1] = (byte)(sSLConn.max_ssl_version & 0xFF);
                    Cipher cipher = Cipher.getInstance((String)"RSA");
                    if (sSLConn.hs.peerEncryptionKey == null) {
                        sSLConn.hs.peerEncryptionKey = sSLConn.hs.peerSignatureKey;
                    }
                    cipher.initEncrypt((Key)sSLConn.hs.peerEncryptionKey);
                    byte[] byArray = PKCS1Pad.pkcs1PadBuf(sSLConn.hs.rng, sSLConn.hs.pre_master_secret, sSLConn.hs.peerEncryptionKey);
                    SSLDebug.debug(8, "RSA input", byArray);
                    byte[] byArray2 = cipher.crypt(byArray);
                    this.client_data.value = byArray2;
                    SSLDebug.debug(8, "PreMasterSecret", sSLConn.hs.pre_master_secret);
                    SSLDebug.debug(8, "EncryptedPreMasterSecret", byArray2);
                    if (sSLConn.ssl_version >= 769) {
                        return this.client_data.encode(sSLConn, outputStream);
                    }
                    outputStream.write(byArray2);
                    return byArray2.length;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new InternalError(exception.toString());
                }
            }
        }
        throw new InternalError("Inconsistent algorithm");
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n;
        switch (sSLConn.hs.cipher_suite.getKeyExchangeAlg()) {
            case 1: {
                n = this.client_data.decode(sSLConn, inputStream);
                sSLConn.hs.peerEncryptionKey = new DHPublicKey(new BigInteger(1, this.client_data.value));
                sSLConn.hs.pre_master_secret = sSLConn.hs.dhEphemeral.keyAgree((DHPublicKey)sSLConn.hs.peerEncryptionKey, false);
                break;
            }
            case 2: {
                Object object;
                byte[] byArray;
                if (sSLConn.ssl_version >= 769) {
                    n = this.client_data.decode(sSLConn, inputStream);
                    byArray = this.client_data.value;
                } else {
                    object = new byte[512];
                    n = inputStream.read((byte[])object);
                    if (n < 0) {
                        throw new SSLException("Short RSA key");
                    }
                    byArray = new byte[n];
                    System.arraycopy(object, 0, byArray, 0, n);
                }
                try {
                    object = Cipher.getInstance((String)"RSA");
                    object.initDecrypt((Key)(sSLConn.hs.rsaEphemeral == null ? sSLConn.ctx.getPrivateKey() : sSLConn.hs.rsaEphemeral));
                    byte[] byArray2 = object.crypt(byArray);
                    try {
                        sSLConn.hs.pre_master_secret = PKCS1Pad.pkcs1UnpadBuf(byArray2, 1, (CryptixRSAPrivateKey)sSLConn.ctx.getPrivateKey());
                        if (sSLConn.hs.pre_master_secret.length != 48) {
                            throw new Exception("Bad PMS length");
                        }
                    }
                    catch (Exception exception) {
                        sSLConn.hs.pre_master_secret = new byte[48];
                        SSLDebug.debug(8, "Bad padding. Randomizing PMS");
                        sSLConn.ctx.rng.nextBytes(sSLConn.hs.pre_master_secret);
                    }
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
                }
                catch (Exception exception) {
                    sSLConn.alert(SSLAlertX.TLS_ALERT_INTERNAL_ERROR);
                }
                break;
            }
            default: {
                throw new InternalError("Inconsistent algorithm");
            }
        }
        return n;
    }
}

