/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.torque.engine.database.model.Column;
import org.apache.turbine.torque.engine.database.model.Database;
import org.apache.turbine.torque.engine.database.model.Table;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToData
extends DefaultHandler
implements EntityResolver {
    private Database database;
    private String errorMessage;
    private Vector data;
    private String dtdFileName;
    private File dtdFile;
    private InputSource dataDTD;

    public List parseFile(String xmlFile) {
        try {
            this.data = new Vector();
            SAXParser parser = new SAXParser();
            parser.setEntityResolver((EntityResolver)this);
            parser.setContentHandler((ContentHandler)this);
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler((ErrorHandler)this);
            FileReader fr = new FileReader(xmlFile);
            BufferedReader br = new BufferedReader(fr);
            try {
                InputSource is = new InputSource(br);
                parser.parse(is);
            }
            finally {
                Object var6_7 = null;
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.errorMessage.length() > 0) {
            System.out.println("ERROR in data file!!!\n" + this.errorMessage);
        }
        return this.data;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        try {
            if (!rawName.equals("dataset")) {
                Table table = this.database.getTableByJavaName(rawName);
                Vector<ColumnValue> columnValues = new Vector<ColumnValue>();
                int i = 0;
                while (i < attributes.getLength()) {
                    Column col = table.getColumnByJavaName(attributes.getLocalName(i));
                    String value = attributes.getValue(i);
                    columnValues.add(new ColumnValue(col, value));
                    ++i;
                }
                this.data.add(new DataRow(table, columnValues));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warning(SAXParseException spe) {
        System.out.println("Warning Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void error(SAXParseException spe) {
        System.out.println("Error Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void fatalError(SAXParseException spe) {
        System.out.println("Fatal Error Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.dataDTD != null && this.dtdFileName.equals(systemId)) {
            System.out.println("Resolver: used " + this.dtdFile.getPath());
            return this.dataDTD;
        }
        System.out.println("Resolver: used " + systemId);
        return this.getInputSource(systemId);
    }

    public InputSource getInputSource(String urlString) {
        try {
            URL url = new URL(urlString);
            return new InputSource(url.openStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new InputSource();
        }
    }

    public XmlToData(Database database, String dtdFilePath) throws MalformedURLException, IOException {
        this.database = database;
        this.dtdFile = new File(dtdFilePath);
        this.dtdFileName = "file://" + this.dtdFile.getName();
        this.dataDTD = new InputSource(this.dtdFile.toURL().openStream());
        this.errorMessage = "";
    }

    public class DataRow {
        private Table table;
        private Vector columnValues;

        public Table getTable() {
            return this.table;
        }

        public Vector getColumnValues() {
            return this.columnValues;
        }

        public DataRow(Table table, Vector columnValues) {
            this.table = table;
            this.columnValues = columnValues;
        }
    }

    public class ColumnValue {
        private Column col;
        private String val;

        public Column getColumn() {
            return this.col;
        }

        public String getValue() {
            return this.val;
        }

        public ColumnValue(Column col, String val) {
            this.col = col;
            this.val = val;
        }
    }
}

