/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.endpoint.Message;

class OutgoingMessageQueue {
    Message[] arr;
    int head;
    int tail;
    int total;

    OutgoingMessageQueue(int size) {
        this.arr = new Message[size];
    }

    synchronized void enqueue(Message msg) throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
        this.arr[this.tail] = msg;
        this.tail = (this.tail + 1) % this.arr.length;
        ++this.total;
        this.notifyAll();
    }

    synchronized void slide(long n) {
        int i = 0;
        while ((long)i < n) {
            this.arr[this.head] = null;
            this.head = (this.head + 1) % this.arr.length;
            ++i;
        }
    }

    synchronized Message get(int i, long maxTimeout) throws InterruptedException {
        while (this.total < i) {
            long start = System.currentTimeMillis();
            this.wait(maxTimeout);
            if (System.currentTimeMillis() - start < maxTimeout) continue;
            return null;
        }
        return this.arr[(this.head + i) % this.arr.length];
    }

    synchronized Message dequeue(Message msg, long maxTimeout) throws InterruptedException {
        while (this.isEmpty()) {
            long start = System.currentTimeMillis();
            this.wait(maxTimeout);
            if (System.currentTimeMillis() - start < maxTimeout) continue;
            return null;
        }
        Message m = this.arr[this.head];
        this.arr[this.head] = null;
        this.head = (this.head + 1) % this.arr.length;
        --this.total;
        return m;
    }

    boolean isEmpty() {
        return this.total == 0;
    }

    boolean isFull() {
        return this.total == this.arr.length;
    }

    int getMessageCount() {
        return this.total;
    }

    int getFreeSlots() {
        return this.arr.length - this.total;
    }
}

