/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.proxy.Requestor;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class ProxyService
implements Service,
EndpointListener,
PipeMsgListener,
OutputPipeListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$proxy$ProxyService == null ? (class$net$jxta$impl$proxy$ProxyService = ProxyService.class$("net.jxta.impl.proxy.ProxyService")) : class$net$jxta$impl$proxy$ProxyService).getName());
    public static final int DEFAULT_THRESHOLD = 2;
    public static final int DEFAULT_LIFETIME = 1800000;
    private PeerGroup group = null;
    private String serviceName = null;
    private String serviceParameter = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private PipeService pipe = null;
    private Advertisement implAdv = null;
    private Map searchRequests;
    private Map pipeListeners;
    private Map pipeSenders;
    public static final String REQUEST_TAG = "proxy:request";
    public static final String RESPONSE_TAG = "proxy:response";
    public static final String DATA_TAG = "proxy:data";
    public static final String ERROR_TAG = "proxy:error";
    public static final String REQUESTID_TAG = "proxy:requestId";
    public static final String TYPE_TAG = "proxy:type";
    public static final String NAME_TAG = "proxy:name";
    public static final String ID_TAG = "proxy:id";
    public static final String ARG_TAG = "proxy:arg";
    public static final String ATTRIBUTE_TAG = "proxy:attr";
    public static final String VALUE_TAG = "proxy:value";
    public static final String REQUEST_CREATE = "create";
    public static final String REQUEST_SEARCH = "search";
    public static final String REQUEST_LISTEN = "listen";
    public static final String REQUEST_CLOSE = "close";
    public static final String REQUEST_SEND = "send";
    public static final String TYPE_PEER = "PEER";
    public static final String TYPE_GROUP = "GROUP";
    public static final String TYPE_PIPE = "PIPE";
    private static final Category RLOG = Category.getInstance((String)(class$net$jxta$impl$proxy$ProxyService$RequestorList == null ? (class$net$jxta$impl$proxy$ProxyService$RequestorList = ProxyService.class$("net.jxta.impl.proxy.ProxyService$RequestorList")) : class$net$jxta$impl$proxy$ProxyService$RequestorList).getName());
    static /* synthetic */ Class class$net$jxta$impl$proxy$ProxyService;
    static /* synthetic */ Class class$net$jxta$impl$proxy$ProxyService$RequestorList;

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.group = group;
        this.serviceName = assignedID.toString();
        this.implAdv = implAdv;
        this.serviceParameter = group.getPeerGroupID().toString();
        this.searchRequests = Collections.synchronizedMap(new TreeMap());
        this.pipeListeners = Collections.synchronizedMap(new TreeMap());
        this.pipeSenders = Collections.synchronizedMap(new TreeMap());
    }

    public int startApp(String[] args) {
        LOG.info((Object)("addListener " + this.serviceName + this.serviceParameter));
        this.endpoint = this.group.getEndpointService();
        this.discovery = this.group.getDiscoveryService();
        this.pipe = this.group.getPipeService();
        this.endpoint.addListener(this.serviceName + this.serviceParameter, this);
        return 0;
    }

    public void stopApp() {
        LOG.info((Object)("removeListener " + this.serviceName + this.serviceParameter));
        this.endpoint.removeListener(this.serviceName + this.serviceParameter, this);
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        String request = ProxyService.popString(REQUEST_TAG, message);
        Requestor requestor = null;
        try {
            requestor = Requestor.createRequestor(this.group, message);
        }
        catch (IOException e) {
            LOG.warn((Object)"could not create requestor", (Throwable)e);
        }
        LOG.debug((Object)("request = " + request));
        if (request != null && requestor != null) {
            if (REQUEST_CREATE.equals(request)) {
                this.handleCreateRequest(requestor, ProxyService.popString(TYPE_TAG, message), ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message));
            } else if (REQUEST_SEARCH.equals(request)) {
                this.handleSearchRequest(requestor, ProxyService.popString(TYPE_TAG, message), ProxyService.popString(ATTRIBUTE_TAG, message), ProxyService.popString(VALUE_TAG, message));
            } else if (REQUEST_LISTEN.equals(request)) {
                this.handleListenRequest(requestor, ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message));
            } else if (REQUEST_CLOSE.equals(request)) {
                this.handleCloseRequest(requestor, ProxyService.popString(ID_TAG, message));
            } else if (REQUEST_SEND.equals(request)) {
                this.handleSendRequest(requestor, ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message), message);
            }
        }
    }

    public void handleCreateRequest(Requestor requestor, String type, String name, String id, String arg) {
        LOG.debug((Object)("handleCreateRequest type=" + type + " name=" + name + " id=" + id + " arg=" + arg));
        if (name == null) {
            name = "";
        }
        if (TYPE_PEER.equals(type)) {
            PeerAdvertisement adv = this.createPeerAdvertisement(name, id);
            if (adv != null) {
                try {
                    this.discovery.publish(adv, 0);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not publish peer advertisement");
                }
                Message message = this.endpoint.newMessage();
                message.setString(TYPE_TAG, type);
                message.setString(NAME_TAG, adv.getName());
                message.setString(ID_TAG, adv.getPeerID().toString());
                requestor.send(message);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else if (TYPE_GROUP.equals(type)) {
            PeerGroupAdvertisement adv = ProxyService.createGroupAdvertisement(name, id);
            if (adv != null) {
                try {
                    this.discovery.publish(adv, 1);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not publish group advertisement");
                }
                Message message = this.endpoint.newMessage();
                message.setString(TYPE_TAG, type);
                message.setString(NAME_TAG, adv.getName());
                message.setString(ID_TAG, adv.getPeerGroupID().toString());
                requestor.send(message);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else if (TYPE_PIPE.equals(type)) {
            PipeAdvertisement adv;
            if (arg == null) {
                arg = "JxtaUnicast";
            }
            if ((adv = ProxyService.createPipeAdvertisement(name, id, arg)) != null) {
                try {
                    this.discovery.publish(adv, 2);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not publish pipe advertisement");
                }
                Message message = this.endpoint.newMessage();
                message.setString(TYPE_TAG, type);
                message.setString(NAME_TAG, adv.getName());
                message.setString(ID_TAG, adv.getPipeID().toString());
                message.setString(ARG_TAG, adv.getType());
                requestor.send(message);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else {
            requestor.notifyError("unsupported type");
        }
    }

    public void handleSearchRequest(Requestor requestor, String type, String attribute, String value) {
        LOG.debug((Object)("handleSearchRequest type=" + type + " attribute=" + attribute + " value=" + value));
        int discoveryType = TYPE_PEER.equals(type) ? 0 : (TYPE_GROUP.equals(type) ? 1 : 2);
        Enumeration enumeration = null;
        try {
            enumeration = this.discovery.getLocalAdvertisements(discoveryType, attribute, value);
        }
        catch (IOException e) {
            requestor.notifyError("could not search locally");
        }
        Advertisement adv = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            adv = (Advertisement)enumeration.nextElement();
            requestor.send(adv, DATA_TAG);
        }
        int queryId = this.discovery.getRemoteAdvertisements(null, discoveryType, attribute, value, 2);
        this.searchRequests.put(new Integer(queryId), requestor);
    }

    public void handleListenRequest(Requestor requestor, String name, String id, String arg) {
        LOG.debug((Object)("handleListenRequest name=" + name + " id=" + id + " arg=" + arg));
        PipeAdvertisement pipeAdv = this.findPipeAdvertisement(name, id, arg);
        if (pipeAdv == null) {
            requestor.notifyError("Could not find pipe");
            return;
        }
        id = pipeAdv.getPipeID().toString();
        LOG.debug((Object)("listen to pipe name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType()));
        RequestorList list = (RequestorList)this.pipeListeners.get(id);
        if (list == null) {
            LOG.debug((Object)"first listener, create input pipe");
            list = new RequestorList();
            this.pipeListeners.put(id, list);
            list.add(requestor);
            LOG.debug((Object)("add list " + list + " to pipe id=" + id));
            try {
                list.setInputPipe(this.pipe.createInputPipe(pipeAdv, this));
            }
            catch (IOException e) {
                requestor.notifyError("could not listen to pipe");
                return;
            }
        } else {
            list.add(requestor);
        }
        requestor.send(pipeAdv, RESPONSE_TAG);
    }

    public void handleCloseRequest(Requestor requestor, String id) {
        LOG.debug((Object)("handleCloseRequest id=" + id));
        Object listeners = this.pipeListeners.get(id);
        if (listeners == null) {
            if (listeners instanceof Requestor) {
                this.pipeListeners.remove(id);
            } else if (listeners instanceof LinkedList) {
                LinkedList list = (LinkedList)listeners;
                list.remove(requestor);
                if (list.size() == 0) {
                    this.pipeListeners.remove(id);
                }
            }
        }
    }

    public void handleSendRequest(Requestor requestor, String name, String id, String arg, Message message) {
        LOG.debug((Object)("handleSendRequest name=" + name + " id=" + id + " arg=" + arg));
        PipeAdvertisement pipeAdv = this.findPipeAdvertisement(name, id, arg);
        if (pipeAdv == null) {
            requestor.notifyError("Could not find pipe");
            return;
        }
        id = pipeAdv.getPipeID().toString();
        LOG.debug((Object)("send to pipe name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType()));
        RequestorList list = (RequestorList)this.pipeListeners.get(id);
        if (list != null && "JxtaUnicast".equals(pipeAdv.getType())) {
            list.send((Message)message.clone());
            return;
        }
        try {
            LOG.debug((Object)"output pipe send begin");
            OutputPipe out = this.pipe.createOutputPipe(pipeAdv, 50000L);
            out.send(message);
            out.close();
            LOG.debug((Object)"output pipe send end");
        }
        catch (IOException e) {
            requestor.notifyError("could not listen to pipe");
            return;
        }
        requestor.send(pipeAdv, RESPONSE_TAG);
    }

    private PeerAdvertisement createPeerAdvertisement(String name, String id) {
        PeerAdvertisement adv = null;
        PeerID pid = null;
        try {
            ID tempId = IDFactory.fromURL(new URL(id));
            if (tempId instanceof PeerID) {
                pid = (PeerID)tempId;
            }
        }
        catch (UnknownServiceException e) {
            LOG.warn((Object)"Invalid peerId", (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Could not parse peerId from url", (Throwable)e);
        }
        if (pid == null) {
            pid = IDFactory.newPeerID(this.group.getPeerGroupID());
        }
        LOG.debug((Object)("newPeerAdvertisement name=" + name + " id=" + pid.toString()));
        try {
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
            adv.setName(name);
            adv.setPeerID(pid);
        }
        catch (Exception e) {
            LOG.warn((Object)"newPeerAdvertisement Exception", (Throwable)e);
        }
        return adv;
    }

    private static PeerGroupAdvertisement createGroupAdvertisement(String name, String id) {
        PeerGroupAdvertisement adv = null;
        PeerGroupID gid = null;
        try {
            ID tempId = IDFactory.fromURL(new URL(id));
            if (tempId instanceof PeerGroupID) {
                gid = (PeerGroupID)tempId;
            }
        }
        catch (UnknownServiceException e) {
            LOG.warn((Object)"Invalid peergroupId", (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Could not parse peergroupId from url", (Throwable)e);
        }
        if (gid == null) {
            gid = IDFactory.newPeerGroupID();
        }
        LOG.debug((Object)("newPeerAdvertisement name=" + name + " id=" + gid.toString()));
        try {
            adv = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
            adv.setName(name);
            adv.setPeerGroupID(gid);
        }
        catch (Exception e) {
            LOG.warn((Object)"newPeerAdvertisement Exception", (Throwable)e);
        }
        return adv;
    }

    private static PipeAdvertisement createPipeAdvertisement(String pipeName, String pipeId, String pipeType) {
        PipeAdvertisement adv = null;
        LOG.debug((Object)("newPipeAdvertisement name=" + pipeName + " pipeId=" + pipeId + " pipeType=" + pipeType));
        try {
            adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
            adv.setName(pipeName);
            adv.setPipeID(IDFactory.fromURL(new URL(pipeId)));
            adv.setType(pipeType);
        }
        catch (Exception e) {
            LOG.warn((Object)"newPipeAdvertisement Exception", (Throwable)e);
        }
        return adv;
    }

    private PipeAdvertisement findPipeAdvertisement(String name, String id, String arg) {
        String value;
        String attribute;
        LOG.debug((Object)("findPipeAdvertisement name=" + name + " id=" + id + " arg=" + arg));
        if (id != null) {
            attribute = "Id";
            value = id;
        } else if (name != null) {
            attribute = "Name";
            value = name;
        } else {
            return null;
        }
        if (arg == null) {
            arg = "JxtaUnicast";
        }
        Enumeration enumeration = null;
        try {
            enumeration = this.discovery.getLocalAdvertisements(2, attribute, value);
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException in getLocalAdvertisements()", (Throwable)e);
            return null;
        }
        PipeAdvertisement pipeAdv = null;
        Advertisement adv = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            adv = (Advertisement)enumeration.nextElement();
            if (!(adv instanceof PipeAdvertisement)) continue;
            pipeAdv = (PipeAdvertisement)adv;
            break;
        }
        LOG.debug((Object)("found PipeAdvertisement = " + pipeAdv));
        if (pipeAdv == null) {
            LOG.debug((Object)"create PipeAdvertisement");
            if (id == null) {
                id = IDFactory.newPipeID(this.group.getPeerGroupID()).toString();
            }
            pipeAdv = ProxyService.createPipeAdvertisement(name, id, arg);
        }
        LOG.debug((Object)"publish PipeAdvertisement");
        try {
            this.discovery.publish(pipeAdv, 2, 1800000L, 1800000L);
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not publish pipe advertisement");
        }
        return pipeAdv;
    }

    /*
     * Unable to fully structure code
     */
    public void discoveryEvent(DiscoveryEvent event) {
        ProxyService.LOG.debug((Object)("discoveryEvent " + event));
        requestor = (Requestor)this.searchRequests.get(new Integer(event.getQueryID()));
        if (requestor == null) {
            return;
        }
        response = event.getResponse();
        if (response == null) {
            return;
        }
        enum = response.getResponses();
        if (enum != null && enum.hasMoreElements()) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            try {
                str = (String)enum.nextElement();
                adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(str.getBytes()));
                requestor.send(adv, "proxy:data");
                continue;
            }
            catch (Exception e) {
                ProxyService.LOG.warn((Object)"Bad result returned by DiscoveryService", (Throwable)e);
            }
lbl19:
            // 3 sources

            ** while (enum.hasMoreElements())
        }
lbl20:
        // 1 sources

    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        LOG.debug((Object)("pipeMsgEvent " + event.getPipeID()));
        String id = event.getPipeID().toString();
        RequestorList list = (RequestorList)this.pipeListeners.get(id);
        if (list != null) {
            Message message = event.getMessage();
            list.send((Message)message.clone());
        } else {
            ((InputPipe)event.getSource()).close();
            LOG.debug((Object)("close pipe id=" + id));
        }
    }

    public void outputPipeEvent(OutputPipeEvent event) {
        LOG.debug((Object)("outputPipeEvent " + event));
    }

    protected static String popString(String name, Message message) {
        String value = message.getString(name);
        message.removeElement(name);
        return value;
    }

    public static void main(String[] args) throws PeerGroupException {
        PeerGroup group = PeerGroupFactory.newNetPeerGroup();
        Category cat = Category.getInstance((String)"net.jxta.impl.proxy");
        cat.setPriority(Priority.DEBUG);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RequestorList {
        LinkedList list = new LinkedList();
        InputPipe inputPipe;

        RequestorList() {
        }

        void setInputPipe(InputPipe inputPipe) {
            this.inputPipe = inputPipe;
        }

        synchronized boolean isEmpty() {
            return this.list.size() == 0;
        }

        synchronized void add(Requestor requestor) {
            RLOG.debug((Object)("add " + requestor));
            this.list.add(requestor);
        }

        synchronized void remove(Requestor requestor) {
            RLOG.debug((Object)("remove " + requestor));
            this.list.remove(requestor);
        }

        synchronized void send(Message message) {
            RLOG.debug((Object)("send " + this.list.size()));
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Requestor requestor = (Requestor)iterator.next();
                requestor.send((Message)message.clone());
            }
        }
    }
}

