/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class StdPeerGroupParamAdv
extends Advertisement {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$StdPeerGroupParamAdv == null ? (class$net$jxta$impl$peergroup$StdPeerGroupParamAdv = StdPeerGroupParamAdv.class$("net.jxta.impl.peergroup.StdPeerGroupParamAdv")) : class$net$jxta$impl$peergroup$StdPeerGroupParamAdv).getName());
    private static final String paramTag = "Parm";
    private static final String protoTag = "Proto";
    private static final String appTag = "App";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String msidTag = "MSID";
    private static final String miaTag = ModuleImplAdvertisement.getAdvertisementType();
    private Hashtable servicesTable = null;
    private Hashtable protosTable = null;
    private Hashtable appsTable = null;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$StdPeerGroupParamAdv;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ID getID() {
        return null;
    }

    public StdPeerGroupParamAdv() {
        this.servicesTable = new Hashtable();
        this.protosTable = new Hashtable();
        this.appsTable = new Hashtable();
    }

    public StdPeerGroupParamAdv(Element root) throws PeerGroupException {
        try {
            this.initialize(root);
        }
        catch (Exception any) {
            throw new PeerGroupException(any.getMessage());
        }
    }

    public Hashtable getServices() {
        return this.servicesTable;
    }

    public Hashtable getProtos() {
        return this.protosTable;
    }

    public Hashtable getApps() {
        return this.appsTable;
    }

    public void setServices(Hashtable servicesTable) {
        this.servicesTable = servicesTable == null ? new Hashtable() : servicesTable;
    }

    public void setProtos(Hashtable protosTable) {
        this.protosTable = protosTable == null ? new Hashtable() : protosTable;
    }

    public void setApps(Hashtable appsTable) {
        this.appsTable = appsTable == null ? new Hashtable() : appsTable;
    }

    public void initialize(Element root) throws Exception {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = StdPeerGroupParamAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(paramTag)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.servicesTable = new Hashtable();
        this.protosTable = new Hashtable();
        this.appsTable = new Hashtable();
        int appCount = 0;
        Enumeration modules = doc.getChildren();
        while (modules.hasMoreElements()) {
            Cloneable theValue;
            Hashtable theTable;
            TextElement module = (TextElement)modules.nextElement();
            String tagName = module.getName();
            if (tagName.equals(svcTag)) {
                theTable = this.servicesTable;
            } else if (tagName.equals(appTag)) {
                theTable = this.appsTable;
            } else {
                if (!tagName.equals(protoTag)) continue;
                theTable = this.protosTable;
            }
            ModuleSpecID specID = null;
            ModuleClassID classID = null;
            ModuleImplAdvertisement inLineAdv = null;
            try {
                if (module.getTextValue() != null) {
                    specID = (ModuleSpecID)IDFactory.fromURL(new URL(module.getTextValue()));
                }
                Enumeration fields = module.getChildren();
                while (fields.hasMoreElements()) {
                    TextElement field = (TextElement)fields.nextElement();
                    if (field.getName().equals(mcidTag)) {
                        classID = (ModuleClassID)IDFactory.fromURL(new URL(field.getTextValue()));
                        continue;
                    }
                    if (field.getName().equals(msidTag)) {
                        specID = (ModuleSpecID)IDFactory.fromURL(new URL(field.getTextValue()));
                        continue;
                    }
                    if (!field.getName().equals(miaTag)) continue;
                    inLineAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(field);
                }
            }
            catch (Exception any) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Broken entry; skipping", (Throwable)any);
                continue;
            }
            if (inLineAdv == null && specID == null) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Insufficent entry; skipping");
                continue;
            }
            if (inLineAdv == null) {
                theValue = specID;
            } else {
                specID = inLineAdv.getModuleSpecID();
                theValue = inLineAdv;
            }
            if (classID == null) {
                classID = specID.getBaseClass();
            }
            if (theTable == this.appsTable && appCount++ != 0) {
                classID = IDFactory.newModuleClassID(classID);
            }
            theTable.put(classID, theValue);
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = null;
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, paramTag);
        }
        catch (Throwable everything) {
            return null;
        }
        this.outputModules(doc, this.servicesTable, svcTag, encodeAs);
        this.outputModules(doc, this.protosTable, protoTag, encodeAs);
        this.outputModules(doc, this.appsTable, appTag, encodeAs);
        return doc;
    }

    private void outputModules(StructuredTextDocument doc, Hashtable modulesTable, String mainTag, MimeMediaType encodeAs) {
        Enumeration allClasses = modulesTable.keys();
        while (allClasses.hasMoreElements()) {
            TextElement i;
            TextElement m;
            ModuleClassID mcid = (ModuleClassID)allClasses.nextElement();
            Object val = modulesTable.get(mcid);
            if (val instanceof Advertisement) {
                m = doc.createElement(mainTag);
                doc.appendChild(m);
                if (modulesTable != this.appsTable && !mcid.equals(mcid.getBaseClass())) {
                    i = doc.createElement(mcidTag, mcid.toString());
                    m.appendChild(i);
                }
                StructuredTextDocument advdoc = (StructuredTextDocument)((Advertisement)val).getDocument(encodeAs);
                StructuredDocumentUtils.copyElements(doc, m, advdoc);
                continue;
            }
            if (val instanceof ModuleSpecID) {
                if (modulesTable == this.appsTable || mcid.equals(mcid.getBaseClass())) {
                    m = doc.createElement(mainTag, ((ModuleSpecID)val).toString());
                    doc.appendChild(m);
                    continue;
                }
                m = doc.createElement(mainTag);
                doc.appendChild(m);
                i = doc.createElement(mcidTag, mcid.toString());
                m.appendChild(i);
                i = doc.createElement(msidTag, ((ModuleSpecID)val).toString());
                m.appendChild(i);
                continue;
            }
            if (!LOG.isEnabledFor(Priority.WARN)) continue;
            LOG.warn((Object)"unsupported class in modules table");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

