/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import net.jxta.impl.index.BloomFilterProperties;
import net.jxta.impl.index.SummaryUpdate;
import net.jxta.impl.xml.XmlParser;

public class SummaryUpdate {
    String serialNumber = null;
    String id = null;
    int[] bitPositions = null;
    int nItems = 0;
    BloomFilterProperties bloomFilterProperties;

    SummaryUpdate(BloomFilterProperties bfProperties, String sn, String id, int[] updates) {
        this.bloomFilterProperties = bfProperties;
        this.serialNumber = sn;
        this.id = id;
        this.add(updates);
    }

    public static SummaryUpdate parse(InputStream is) throws XmlParser.Exception, IOException {
        XmlParser parser = new XmlParser();
        byte[] buf = new byte[128];
        class SUCallback
        implements XmlParser.ParserCallback {
            BloomFilterProperties bfp;
            String id;
            String sn;
            StringBuffer sb;
            static final int NOTHING = 0;
            static final int ID = 1;
            static final int SN = 2;
            static final int BFPARAMS = 3;
            static final int CBITS = 4;
            static final int NFUN = 5;
            static final int NBITS = 6;
            static final int LEN = 7;
            int state;

            SUCallback() {
                this.bfp = new BloomFilterProperties();
                this.sb = new StringBuffer();
                this.state = 0;
            }

            public void startTag(byte[] chars, int start, int len) {
                String tag = new String(chars, start, len);
                if (this.state == 0) {
                    this.state = tag.equals("ID") ? 1 : (tag.equals("SN") ? 2 : (tag.equals("BloomFilterParameters") ? 3 : (tag.equals("ChangedBits") ? 4 : 0)));
                } else if (this.state == 3) {
                    if (tag.equals("nFunctionsPerEntry")) {
                        this.state = 5;
                    } else if (tag.equals("nBitsPerFunction")) {
                        this.state = 6;
                    } else if (tag.equals("length")) {
                        this.state = 7;
                    }
                }
            }

            public void attribute(byte[] nameCh, int nameStart, int nameLen, byte[] valueCh, int valueStart, int valueLen) {
            }

            public void chars(byte[] chars, int start, int len) {
                String value = new String(chars, start, len);
                int intValue = -1;
                switch (this.state) {
                    case 1: {
                        this.id = value;
                        break;
                    }
                    case 2: {
                        this.sn = value;
                        break;
                    }
                    case 4: {
                        this.sb.append(value);
                        break;
                    }
                    case 5: {
                        try {
                            intValue = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (intValue == -1) break;
                        this.bfp.setNFunctions(intValue);
                        break;
                    }
                    case 6: {
                        try {
                            intValue = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (intValue == -1) break;
                        this.bfp.setNBitsPerFunction(intValue);
                        break;
                    }
                    case 7: {
                        try {
                            intValue = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (intValue == -1) break;
                        this.bfp.setLength(intValue);
                        break;
                    }
                }
            }

            public void endTag(byte[] chars, int start, int len) {
                switch (this.state) {
                    case 5: 
                    case 6: 
                    case 7: {
                        this.state = 3;
                        break;
                    }
                    default: {
                        this.state = 0;
                    }
                }
            }
        }
        SUCallback suCallback = new SUCallback();
        XmlParser.parse(is, buf, suCallback);
        StringTokenizer st = new StringTokenizer(suCallback.sb.toString(), ",");
        int nTokens = st.countTokens();
        int[] updates = new int[nTokens];
        int indx = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                int intValue = Integer.parseInt(s);
                updates[indx++] = intValue;
            }
            catch (NumberFormatException nfe) {
                throw new XmlParser.Exception("Invalid Bit Position Value");
            }
        }
        SummaryUpdate su = new SummaryUpdate(suCallback.bfp, suCallback.sn, suCallback.id, updates);
        return su;
    }

    public void add(int[] pos) {
        if (pos == null) {
            return;
        }
        int[] temp = new int[this.nItems + pos.length];
        if (this.nItems > 0) {
            System.arraycopy(this.bitPositions, 0, temp, 0, this.nItems);
        }
        System.arraycopy(pos, 0, temp, this.nItems, pos.length);
        this.nItems += pos.length;
        this.bitPositions = temp;
    }

    public String getId() {
        return this.id;
    }

    public BloomFilterProperties getProperties() {
        return this.bloomFilterProperties;
    }

    public int[] getBitPositions() {
        return this.bitPositions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<ID>" + this.id + "</ID>\n");
        int nItemsPerLine = 5;
        int currentPos = 0;
        sb.append("<SN>" + this.serialNumber + "</SN>\n");
        sb.append(this.bloomFilterProperties.toString());
        int i = 0;
        while ((double)i < Math.ceil((double)this.nItems / (double)nItemsPerLine)) {
            sb.append("<ChangedBits>");
            int j = 0;
            while (j < nItemsPerLine && currentPos < this.nItems) {
                sb.append(this.bitPositions[currentPos++] + ",");
                ++j;
            }
            sb.append("</ChangedBits>\n");
            ++i;
        }
        return sb.toString();
    }
}

