/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import net.jxta.impl.index.BloomFilter;
import net.jxta.impl.index.RemoteSummary;
import net.jxta.impl.index.SummaryUpdate;
import net.jxta.impl.index.xpath.Expression;

public class IndexSummary {
    int maxNumKeys;
    static final int MAX_BUFFER = 1000;
    BloomFilter bf = null;
    byte[] bitCounter;
    int[] bitsChanged;
    int numKeysStored = 0;
    int numBitsPerEntry;
    long versionNumber = 0L;
    String indexId;
    int pointer = 0;

    public IndexSummary(String indexId, int size) {
        this.maxNumKeys = size;
        this.indexId = indexId;
        this.bf = new BloomFilter(this.maxNumKeys);
        this.bitsChanged = new int[1000];
        this.bitCounter = new byte[this.bf.getLength()];
        this.numBitsPerEntry = this.bf.getBitsPerEntry();
        this.versionNumber = 0L;
    }

    public IndexSummary(File summaryFile) throws IOException {
        this.load(summaryFile);
    }

    public void load(File summaryFile) throws IOException {
    }

    public void write(File summaryFile) throws IOException {
    }

    public boolean add(Expression.Literal literal) {
        if (this.numKeysStored >= this.maxNumKeys) {
            return false;
        }
        if (this.pointer + this.numBitsPerEntry >= 1000) {
            this.publishCurrentChanges();
        }
        int[] bitPositions = this.bf.getBitPositions(literal.getName().toString());
        int i = 0;
        while (i < this.numBitsPerEntry) {
            int pos = bitPositions[i];
            if (this.bitCounter[pos] == 127) {
                return false;
            }
            ++i;
        }
        ++this.numKeysStored;
        int i2 = 0;
        while (i2 < this.numBitsPerEntry) {
            int pos = bitPositions[i2];
            if (this.bitCounter[pos] == 0) {
                this.bitsChanged[this.pointer++] = pos;
            }
            int n = pos;
            this.bitCounter[n] = (byte)(this.bitCounter[n] + 1);
            ++i2;
        }
        return true;
    }

    public boolean remove(Expression.Literal literal) {
        if (this.numKeysStored == 0) {
            return false;
        }
        if (this.pointer + this.numBitsPerEntry >= 1000) {
            this.publishCurrentChanges();
        }
        int[] bitPositions = this.bf.getBitPositions(literal.getName().toString());
        int i = 0;
        while (i < this.numBitsPerEntry) {
            int pos = bitPositions[i];
            if (this.bitCounter[pos] == 0) {
                return false;
            }
            ++i;
        }
        --this.numKeysStored;
        int i2 = 0;
        while (i2 < this.numBitsPerEntry) {
            int pos = bitPositions[i2];
            if (this.bitCounter[pos] == 1) {
                this.bitsChanged[this.pointer++] = pos | Integer.MIN_VALUE;
            }
            int n = pos;
            this.bitCounter[n] = (byte)(this.bitCounter[n] - 1);
            ++i2;
        }
        return true;
    }

    public void publishCurrentChanges() {
        SummaryUpdate su = this.delta();
        if (su == null) {
            return;
        }
        System.out.println(su.toString());
        this.pointer = 0;
        ++this.versionNumber;
    }

    private SummaryUpdate delta() {
        if (this.pointer == 0) {
            return null;
        }
        String serialNumber = new String(System.currentTimeMillis() + ":" + this.versionNumber);
        int[] temp = new int[this.pointer];
        System.arraycopy(this.bitsChanged, 0, temp, 0, this.pointer);
        SummaryUpdate su = new SummaryUpdate(this.bf.getProperties(), serialNumber, this.indexId, temp);
        return su;
    }

    public static void main(String[] args) {
        Expression.Literal[] literals = new Expression.Literal[5];
        String indexId = "INDEX_ID1";
        IndexSummary summary = new IndexSummary(indexId, 1000);
        literals[0] = new Expression.Literal("item1");
        literals[1] = new Expression.Literal("item2");
        literals[2] = new Expression.Literal("item3");
        literals[3] = new Expression.Literal("item4");
        literals[4] = new Expression.Literal("item5");
        summary.add(literals[0]);
        summary.add(literals[1]);
        summary.add(literals[2]);
        summary.add(literals[3]);
        summary.add(literals[4]);
        System.out.println("Number of Keys Stored:" + summary.numKeysStored);
        String s = summary.delta().toString();
        System.out.println("SummaryUpdate: ");
        System.out.println(s);
        byte[] sUpdates = s.getBytes();
        SummaryUpdate su = null;
        try {
            su = SummaryUpdate.parse(new ByteArrayInputStream(sUpdates));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (su == null) {
            System.out.println("ERROR: could not read SummaryUpdate from InputStream");
        }
        RemoteSummary rs = new RemoteSummary(su);
        System.out.println("Does the RemoteSummary created contain all literals?\n" + rs.query(literals));
        summary.remove(literals[0]);
        summary.remove(literals[1]);
        summary.remove(literals[2]);
        rs.update(summary.delta());
        System.out.println("Removed some items from the remotesummary");
        System.out.println("Does the RemoteSummary contain all literals now?\n" + rs.query(literals));
        Expression.Literal[] x = new Expression.Literal[]{literals[3], literals[4]};
        System.out.println("This query should answer true now?\n" + rs.query(x));
        System.out.println("Number of Keys currently stored: " + summary.numKeysStored);
    }
}

