/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URL;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.ModuleClassID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public final class ModuleSpecID
extends net.jxta.platform.ModuleSpecID {
    private static final int moduleClassIdOffset = 0;
    private static final int moduleSpecIdOffset = 16;
    private static final int padOffset = 32;
    private static final int padSize = 31;
    protected IDBytes id;

    private ModuleSpecID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 6;
    }

    ModuleSpecID(IDBytes id) {
        this.id = id;
    }

    ModuleSpecID(UUID classUUID, UUID specUUID) {
        this();
        this.id.longIntoBytes(0, classUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, classUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, specUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, specUUID.getLeastSignificantBits());
    }

    public ModuleSpecID(net.jxta.platform.ModuleClassID classID) {
        this(((ModuleClassID)classID).getClassUUID(), UUIDFactory.newUUID());
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof String) {
            return target.equals(this.toString());
        }
        if (target instanceof ModuleSpecID) {
            return this.id.equals(((ModuleSpecID)target).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public net.jxta.platform.ModuleClassID getBaseClass() {
        return new ModuleClassID(this.getClassUUID(), new UUID(0L, 0L));
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleClassID classId) {
        return this.getClassUUID().equals(((ModuleClassID)classId).getClassUUID());
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleSpecID specId) {
        return this.getClassUUID().equals(((ModuleSpecID)specId).getClassUUID());
    }

    UUID getClassUUID() {
        UUID result = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        return result;
    }

    UUID getSpecUUID() {
        UUID result = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        return result;
    }
}

