/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsMessage;
import net.jxta.impl.endpoint.tls.TlsTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsMessenger == null ? (class$net$jxta$impl$endpoint$tls$TlsMessenger = TlsMessenger.class$("net.jxta.impl.endpoint.tls.TlsMessenger")) : class$net$jxta$impl$endpoint$tls$TlsMessenger).getName());
    private EndpointMessenger messenger = null;
    private EndpointAddress destAddress = null;
    private TlsTransport transport = null;
    private TlsConn conn = null;
    private String localPeerAddr = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsMessenger;

    public TlsMessenger(EndpointAddress destAddress, TlsConn conn, TlsTransport tp) {
        if (conn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"null TLS connection!");
            }
            throw new IllegalArgumentException("null TLS connection!");
        }
        this.conn = conn;
        this.destAddress = destAddress;
        this.transport = tp;
        this.localPeerAddr = this.transport.getPublicAddress().toString();
    }

    public void sendMessage(Message message) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TlsMessenger.sendMessage starts");
        }
        Object ip = null;
        TlsMessage tlsMsg = null;
        if (message.hasElement("JxtaTls")) {
            message.removeElement("JxtaTls");
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"The outgoing message already had a TLS message.");
            }
        }
        tlsMsg = new TlsMessage();
        tlsMsg.setSrcAddress(this.localPeerAddr);
        tlsMsg.setDestAddress(this.destAddress.toString());
        message.addElement(message.newMessageElement("JxtaTls", null, tlsMsg.getInputStream()));
        this.conn.sendMessage(message);
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

