/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpConnectionManager {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpConnectionManager == null ? (class$net$jxta$impl$endpoint$tcp$TcpConnectionManager = TcpConnectionManager.class$("net.jxta.impl.endpoint.tcp.TcpConnectionManager")) : class$net$jxta$impl$endpoint$tcp$TcpConnectionManager).getName());
    private static final long TcpConnectionGCDelay = 3600000L;
    private Timer TcpConnectionGCTimer = new Timer();
    private TcpTransport proto = null;
    private Hashtable openConnections = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpConnectionManager;

    public TcpConnectionManager(TcpTransport p) {
        this.proto = p;
        this.TcpConnectionGCTimer.scheduleAtFixedRate((TimerTask)new TcpConnectionGCTask(this), 3600000L, 3600000L);
    }

    private synchronized void registerTcpConnection(EndpointAddress addr, TcpConnection conn) {
        TcpConnection old;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Register connection to " + addr.toString()));
        }
        if ((old = this.openConnections.put(addr.toString(), conn)) != null) {
            old.close();
        }
    }

    private synchronized void unregisterTcpConnection(EndpointAddress addr) {
        TcpConnection old = (TcpConnection)this.openConnections.remove(addr.toString());
        if (old != null) {
            old.close();
        }
    }

    public synchronized TcpConnection getTcpConnection(EndpointAddress destAddr) {
        EndpointAddress addr = (EndpointAddress)destAddr.clone();
        addr.setServiceName(null);
        addr.setServiceParameter(null);
        TcpConnection conn = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Looking connection to " + addr.toString()));
        }
        if ((conn = (TcpConnection)this.openConnections.get(addr.toString())) == null) {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Creating new connection to " + addr.toString()));
                }
                conn = new TcpConnection(addr, this.proto);
                this.registerTcpConnection(addr, conn);
            }
            catch (Exception e) {
                return null;
            }
        } else if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Reusing existing connection to " + addr.toString()));
        }
        conn.setLastUsed(System.currentTimeMillis());
        return conn;
    }

    protected void tcpConnectionGC() {
        Enumeration enumeration;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TcpConnectionGC starts");
        }
        if ((enumeration = this.openConnections.keys()) == null || !enumeration.hasMoreElements()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"TcpConnectionGC: no connection. Nothing to do.");
            }
            return;
        }
        TcpConnection conn = null;
        long lastUsed = 0L;
        long currentTime = 0L;
        String destAddr = null;
        while (enumeration.hasMoreElements()) {
            try {
                destAddr = (String)enumeration.nextElement();
                conn = (TcpConnection)this.openConnections.get(destAddr);
                TcpConnectionManager tcpConnectionManager = this;
                synchronized (tcpConnectionManager) {
                    if (conn == null) {
                        continue;
                    }
                    lastUsed = conn.getLastUsed();
                    currentTime = System.currentTimeMillis();
                    if (currentTime - lastUsed >= 3600000L) {
                        conn.close();
                        this.openConnections.remove(destAddr);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("TcpConnectionGC removes unused connection fon to " + destAddr));
                        }
                    }
                }
            }
            catch (Exception ez1) {
                // empty catch block
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TcpConnectionGC completed.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TcpConnectionGCTask
    extends TimerTask {
        TcpConnectionManager manager = null;

        public TcpConnectionGCTask(TcpConnectionManager manager) {
            this.manager = manager;
        }

        public void run() {
            this.manager.tcpConnectionGC();
        }
    }
}

