/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.endpoint.EndpointService;
import net.jxta.impl.endpoint.servlethttp.JxtaHttpServer;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.MultiException;

public class JettyHttpServer
implements JxtaHttpServer {
    private HttpServer server = null;
    private HandlerContext handlerContext = null;
    private EndpointService endpoint = null;
    private ServletHandler handler;
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$JettyHttpServer == null ? (class$net$jxta$impl$endpoint$servlethttp$JettyHttpServer = JettyHttpServer.class$("net.jxta.impl.endpoint.servlethttp.JettyHttpServer")) : class$net$jxta$impl$endpoint$servlethttp$JettyHttpServer).getName());
    private HashMap attrMap = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$JettyHttpServer;

    public void init(InetAddress addr, int port, EndpointService endpoint, int minThreads, int maxThreads, int maxThreadIdleTimeMs, int maxReadTimeMs) throws IOException {
        this.endpoint = endpoint;
        InetAddrPort addrPort = new InetAddrPort(addr, port);
        SocketListener listener = new SocketListener(addrPort);
        listener.setMinThreads(minThreads);
        listener.setMaxThreads(maxThreads);
        listener.setMaxIdleTimeMs(maxThreadIdleTimeMs);
        listener.setMaxReadTimeMs(maxReadTimeMs);
        this.server = new HttpServer();
        listener.setHttpServer(this.server);
        this.server.addListener((HttpListener)listener);
        this.handlerContext = this.server.addContext("/");
        this.handler = new ServletHandler();
        this.handler.initialize(this.handlerContext);
        this.handlerContext.addHandler((HttpHandler)this.handler);
    }

    public void addServlet(String pathSpec, String servletClassName) {
        this.handler.addServlet(pathSpec, servletClassName);
    }

    public void setContextAttribute(String name, Object value) {
        this.attrMap.put(name, value);
    }

    public void start() throws IOException {
        if (this.server != null) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Jetty HTTP server starting");
            }
            try {
                this.server.start();
            }
            catch (MultiException e) {
                e.printStackTrace();
                throw new IOException("Problem starting Jetty: " + (Object)((Object)e));
            }
            this.handler.getContext().setAttribute("endpoint", (Object)this.endpoint);
            Iterator i = this.attrMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object value = this.attrMap.get(key);
                this.handler.getContext().setAttribute(key, value);
            }
        } else {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Jetty HTTP server not initialized; cannot start");
            }
            throw new IOException("Jetty HTTP server not initialized; cannot start");
        }
    }

    public void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

