/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.beep;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.StringDataStream;
import org.beepcore.beep.lib.MessageQueue;
import org.beepcore.beep.profile.Profile;
import org.beepcore.beep.profile.ProfileConfiguration;

public class JxtaBeepProfile
extends Thread
implements StartChannelListener,
Profile {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$beep$JxtaBeepProfile == null ? (class$net$jxta$impl$endpoint$beep$JxtaBeepProfile = JxtaBeepProfile.class$("net.jxta.impl.endpoint.beep.JxtaBeepProfile")) : class$net$jxta$impl$endpoint$beep$JxtaBeepProfile).getName());
    public static final String JXTA_URI = "http://xml.resource.org/profiles/JXTA/Beep";
    private EndpointService endpoint = null;
    private MessageQueue messages = new MessageQueue();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$beep$JxtaBeepProfile;

    public JxtaBeepProfile() {
        super("JxtaBeepProfile Receive Daemon");
    }

    public StartChannelListener init(String uri, ProfileConfiguration config) throws BEEPException {
        this.start();
        return this;
    }

    EndpointService SetEndpoint(EndpointService endpoint) {
        EndpointService old = this.endpoint;
        this.endpoint = endpoint;
        return old;
    }

    public void startChannel(Channel channel, String encoding, String data) throws StartChannelException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"JxtaCCL StartChannel Callback");
        }
        channel.setDataListener((DataListener)this.messages);
    }

    public void closeChannel(Channel channel) throws CloseChannelException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"JxtaCCL CloseChannel Callback");
        }
        channel.setDataListener(null);
        channel.setAppData(null);
    }

    public boolean advertiseProfile(Session session) {
        return true;
    }

    public void run() {
        try {
            while (true) {
                org.beepcore.beep.core.Message message;
                try {
                    message = this.messages.getNextMessage();
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                    continue;
                }
                this.receiveMSG(message);
            }
        }
        catch (Throwable all) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
            return;
        }
    }

    private void receiveMSG(org.beepcore.beep.core.Message message) {
        DataStream ds = message.getDataStream();
        InputStream is = ds.getInputStream();
        try {
            Message msg = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage(is, msg);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  handing message to EndpointService");
            }
            this.endpoint.demux(msg);
            try {
                message.sendRPY((DataStream)new StringDataStream("OK"));
            }
            catch (BEEPException e) {
                try {
                    message.sendERR(451, "Error sending RPY");
                }
                catch (BEEPException x) {
                    message.getChannel().getSession().terminate(x.getMessage());
                }
                return;
            }
        }
        catch (IOException e) {
            message.getChannel().getSession().terminate(e.getMessage());
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

