/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Vector;
import net.jxta.endpoint.Message;

public class EndpointReceiveQueue {
    public static final int Max_Messages = 100;
    private Vector queue = null;
    private boolean closeFlag = false;
    private int maxNbOfMessages = 100;
    private int nbOfQueuedMessages = 0;

    public EndpointReceiveQueue() {
        this.queue = new Vector(100);
        this.closeFlag = false;
    }

    public EndpointReceiveQueue(int size) {
        this.queue = new Vector(size);
        this.closeFlag = false;
    }

    public synchronized void push(Message message) {
        if (this.closeFlag) {
            return;
        }
        if (this.queue.size() == this.getMaxNbOfMessages()) {
            --this.nbOfQueuedMessages;
            this.queue.removeElementAt(0);
        }
        ++this.nbOfQueuedMessages;
        this.queue.addElement(message);
        this.notifyAll();
    }

    public synchronized Message next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        Message result = (Message)this.queue.firstElement();
        this.queue.removeElementAt(0);
        --this.nbOfQueuedMessages;
        return result;
    }

    public synchronized Message poll(long timeOut) throws InterruptedException {
        if (timeOut < 0L) {
            throw new IllegalArgumentException("timeOut must be >= 0");
        }
        long realTimeOut = System.currentTimeMillis() + timeOut;
        do {
            Message result;
            if (null != (result = this.next())) {
                return result;
            }
            if (this.isClosed()) continue;
            this.wait(timeOut);
            result = this.next();
            if (null != result) {
                return result;
            }
            if (0L != timeOut && (timeOut = realTimeOut - System.currentTimeMillis()) <= 0L) break;
        } while (!this.isClosed());
        return null;
    }

    public Message waitForMessage() throws InterruptedException {
        return this.poll(0L);
    }

    public synchronized boolean isClosed() {
        return this.closeFlag;
    }

    public synchronized void close() {
        this.closeFlag = true;
        this.notifyAll();
    }

    public int getMaxNbOfMessages() {
        int maxNb = this.queue.capacity() < this.maxNbOfMessages ? this.queue.capacity() : this.maxNbOfMessages;
        return maxNb;
    }

    public synchronized void setMaxNbOfMessages(int maxMsgs) {
        this.maxNbOfMessages = maxMsgs;
        this.queue.ensureCapacity(maxMsgs);
    }

    public synchronized int getNbOfQueuedMessages() {
        return this.nbOfQueuedMessages;
    }
}

