/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.impl.document.TextDocumentCommon;

public class LiteXMLDocument
extends LiteXMLElement
implements TextDocumentCommon {
    private static final String JXTA_NAMESPACE = "http://jxta.org";
    public static final Instantiator INSTANTIATOR = new Instantiator();
    String docContent = null;
    private MimeMediaType mimeType = null;
    static /* synthetic */ Class class$java$lang$String;

    public LiteXMLDocument(MimeMediaType mimeType, String type) {
        super(null, (LiteXMLElement.tagRange)null);
        String[] tag = MessageElement.parseName(type);
        String xmlns = "";
        if (!tag[0].equals("")) {
            xmlns = " xmlns:" + tag[0] + "=\"" + JXTA_NAMESPACE + "\"";
        }
        this.init(mimeType, new InputStreamReader(new ByteArrayInputStream(("<?xml version=\"1.0\"?>\n\n<!DOCTYPE " + type + ">\n\n" + "<" + type + xmlns + ">\n" + "</" + type + ">\n").getBytes())));
    }

    public LiteXMLDocument(MimeMediaType mimeType, String type, String textValue) {
        super(null, (LiteXMLElement.tagRange)null);
        String[] tag = MessageElement.parseName(type);
        String xmlns = "";
        if (!tag[0].equals("")) {
            xmlns = " xmlns:" + tag[0] + "=\"" + JXTA_NAMESPACE + "\"";
        }
        this.init(mimeType, new InputStreamReader(new ByteArrayInputStream(new String("<?xml version=\"1.0\"?>\n\n<!DOCTYPE " + type + ">\n\n" + "<" + type + xmlns + ">\n" + textValue + "</" + type + ">\n").getBytes())));
    }

    public LiteXMLDocument(MimeMediaType mimeType, InputStream in) {
        super(null, (LiteXMLElement.tagRange)null);
        this.init(mimeType, new InputStreamReader(in));
    }

    public LiteXMLDocument(MimeMediaType mimeType, Reader in) {
        super(null, (LiteXMLElement.tagRange)null);
        this.init(mimeType, in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(MimeMediaType mimeType, Reader in) {
        this.loc = new LiteXMLElement.tagRange();
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeType;
        StringBuffer theDoc = new StringBuffer();
        char[] smallBuffer = new char[512];
        try {
            int readCount;
            do {
                if ((readCount = in.read(smallBuffer)) <= 0) continue;
                theDoc.append(smallBuffer, 0, readCount);
            } while (readCount >= 0);
        }
        catch (IOException ignored) {}
        this.docContent = new String(theDoc);
        theDoc = null;
        this.loc.startTag.start = 0;
        this.loc.startTag.end = this.docContent.indexOf(62);
        this.loc.body.start = this.loc.startTag.end + 1;
        this.loc.endTag.start = this.loc.body.end = this.docContent.length() - 1;
        this.loc.endTag.end = this.loc.body.end;
        LiteXMLElement.charRange docType = this.getDocType(this.doc.docContent, false);
        this.loc = docType.isValid() ? this.getTagRanges(this.doc.docContent, this.docContent.substring(docType.start, docType.end + 1), this.loc.body) : this.getTagRanges(this.doc.docContent, null, this.loc.body);
        if (!this.loc.isValid()) {
            throw new RuntimeException("Parsing error in source document. could not find end of document");
        }
        this.addChildTags(this.loc.body, this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.docContent = null;
        this.mimeType = null;
    }

    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    public Element createElement(Object key) {
        return this.createElement(key, null);
    }

    public Element createElement(Object key, Object val) {
        if (!(class$java$lang$String == null ? (class$java$lang$String = LiteXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(key.getClass())) {
            throw new ClassCastException(key.getClass().getName() + " not supported by createElement as key.");
        }
        if (null != val && !(class$java$lang$String == null ? (class$java$lang$String = LiteXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(val.getClass())) {
            throw new ClassCastException(val.getClass().getName() + " not supported by createElement as value.");
        }
        return this.createElement((String)key, (String)val);
    }

    public TextElement createElement(String name) {
        return new LiteXMLElement(this, name);
    }

    public TextElement createElement(String name, String val) {
        return new LiteXMLElement(this, name, val);
    }

    protected TextElement createElement(LiteXMLElement.tagRange loc) {
        return new LiteXMLElement(this, loc);
    }

    public Reader getReader() {
        StringWriter stringOut = new StringWriter();
        stringOut.write("<?xml version=\"1.0\"?>\n\n");
        LiteXMLElement.charRange result = this.getDocType(this.docContent, true);
        if (result.isValid()) {
            stringOut.write(this.docContent.substring(result.start, result.end + 1) + "\n\n");
        }
        this.printNice(stringOut, 0, true);
        String asString = stringOut.toString();
        return new StringReader(asString);
    }

    public InputStream getStream() {
        StringWriter stringOut = new StringWriter();
        stringOut.write("<?xml version=\"1.0\"?>\n\n");
        LiteXMLElement.charRange result = this.getDocType(this.docContent, true);
        if (result.isValid()) {
            stringOut.write(this.docContent.substring(result.start, result.end + 1) + "\n\n");
        }
        this.printNice(stringOut, 0, true);
        String asString = stringOut.toString();
        return new ByteArrayInputStream(asString.getBytes());
    }

    public void sendToWriter(Writer stream) throws IOException {
        stream.write("<?xml version=\"1.0\"?>\n\n");
        LiteXMLElement.charRange result = this.getDocType(this.docContent, true);
        if (result.isValid()) {
            stream.write(this.docContent.substring(result.start, result.end + 1) + "\n\n");
        }
        this.printNice(stream, 0, true);
    }

    public void sendToStream(OutputStream stream) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(stream));
        this.sendToWriter(out);
        ((Writer)out).flush();
    }

    protected LiteXMLElement.charRange getDocType(String source, boolean wholeElement) {
        String xmldoctype = "!DOCTYPE";
        LiteXMLElement.charRange result = new LiteXMLElement.charRange();
        int start = 0;
        int end = this.doc.docContent.length() - 1;
        LiteXMLElement.tagRange ranges = this.getTagRanges(source, "!DOCTYPE", new LiteXMLElement.charRange(start, end));
        if (-1 == start) {
            return result;
        }
        if (!ranges.startTag.isValid()) {
            return result;
        }
        if (wholeElement) {
            result = ranges.startTag;
        } else {
            result.start = ranges.startTag.start + 1 + "!DOCTYPE".length() - 1 + 1;
            while (result.start < end && -1 != " \t\n\r".indexOf(source.charAt(result.start))) {
                ++result.start;
            }
            result.end = result.start;
            while (result.end + 1 < end && -1 == " \t\n\r/>".indexOf(source.charAt(result.end + 1))) {
                ++result.end;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements StructuredDocumentFactory.Instantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{new MimeMediaType("Text", "Xml"), new MimeMediaType("Text", "x-Xml"), new MimeMediaType("Application", "Xml"), new MimeMediaType("Application", "x-Xml")};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype) {
            return new LiteXMLDocument(mimeType, doctype);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype, String value) {
            return new LiteXMLDocument(mimeType, doctype, value);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, InputStream source) throws IOException {
            return new LiteXMLDocument(mimeType, source);
        }
    }
}

