/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.cm.CmCache;
import net.jxta.impl.cm.CmIndexerThread;
import net.jxta.impl.cm.FileExpirationService;
import net.jxta.impl.cm.SchedulerService;
import net.jxta.impl.config.Config;
import net.jxta.impl.index.IndexServiceImpl;
import net.jxta.index.IndexService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class Cm {
    public static final String RootDirBase = Config.JXTA_HOME + "cm";
    public static final String PublicDirName = "public";
    public static final String PrivateDirName = "private";
    public static final String TmpDirName = "tmp";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$Cm == null ? (class$net$jxta$impl$cm$Cm = Cm.class$("net.jxta.impl.cm.Cm")) : class$net$jxta$impl$cm$Cm).getName());
    private static final Random random = new Random();
    protected static final IndexService indexService = new IndexServiceImpl();
    protected static final SchedulerService schedulerService = new SchedulerService();
    protected Hashtable indexes;
    protected Hashtable caches;
    protected File rootDir;
    private FileExpirationService expirer;
    private String indexFilename;
    private static final int RAW = 0;
    private static final int CACHE = 1;
    private static final int INDEX = 2;
    private int searchMethod;
    private String[] searchType;
    static /* synthetic */ Class class$net$jxta$impl$cm$Cm;

    public Cm(String areaName, boolean enableOptimize) {
        this(areaName, null, enableOptimize);
    }

    public Cm(String areaName, ExpirationListener listener, boolean enableOptimize) {
        block15: {
            block14: {
                this.indexes = new Hashtable(4);
                this.caches = new Hashtable(4);
                this.indexFilename = "cm.idx";
                this.searchMethod = 0;
                this.searchType = new String[]{"RAW", "CACHE", "INDEX"};
                try {
                    ResourceBundle cmRsrc = ResourceBundle.getBundle("net.jxta.user");
                    String str = cmRsrc.getString("impl.cm.searchMethod").trim();
                    if (str.equals("RAW")) {
                        this.searchMethod = 0;
                    } else if (str.equals("CACHE")) {
                        this.searchMethod = 1;
                    } else if (str.equals("INDEX")) {
                        this.searchMethod = 2;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)(" Search Method " + this.searchType[this.searchMethod]));
                    }
                }
                catch (MissingResourceException e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block14;
                    LOG.warn((Object)"cm search method preference resource not found", (Throwable)e);
                }
            }
            try {
                File base = new File(RootDirBase);
                File[] docDirs = new File[3];
                FileExpirationService.ExpirationListener republisher = null;
                this.rootDir = new File(base, areaName);
                this.rootDir = new File(this.rootDir.getCanonicalPath());
                if (this.searchMethod == 2 && enableOptimize) {
                    republisher = new FileExpirationService.ExpirationListener(){

                        /*
                         * Loose catch block
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void expiredAndRemove(File f) {
                            FileInputStream in;
                            block19: {
                                IndexService.Index index = (IndexService.Index)Cm.this.indexes.get(new File(f.getParent()).getName());
                                in = null;
                                in = new FileInputStream(f);
                                if (index != null) {
                                    index.remove(f.getName(), in);
                                }
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block19;
                                LOG.debug((Object)(" removing " + f + " from index."));
                            }
                            Object var9_4 = null;
                            if (in == null) return;
                            try {
                                ((InputStream)in).close();
                                return;
                            }
                            catch (IOException e2) {}
                            return;
                            {
                                catch (NullPointerException e) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"NPE ", (Throwable)e);
                                    }
                                    Object var9_5 = null;
                                    if (in == null) return;
                                    try {
                                        ((InputStream)in).close();
                                        return;
                                    }
                                    catch (IOException e2) {}
                                    return;
                                }
                                catch (IOException e) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"IO Exception ", (Throwable)e);
                                    }
                                    Object var9_6 = null;
                                    if (in == null) return;
                                    try {
                                        ((InputStream)in).close();
                                        return;
                                    }
                                    catch (IOException e2) {}
                                    return;
                                }
                                catch (IndexService.BadDocumentException e) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"bad doc ", (Throwable)e);
                                    }
                                    Object var9_7 = null;
                                    if (in == null) return;
                                    try {
                                        ((InputStream)in).close();
                                        return;
                                    }
                                    catch (IOException e2) {}
                                    return;
                                }
                                catch (IndexService.IndexException e) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"Index Error ", (Throwable)e);
                                    }
                                    Object var9_8 = null;
                                    if (in == null) return;
                                    try {
                                        ((InputStream)in).close();
                                        return;
                                    }
                                    catch (IOException e2) {}
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                if (in == null) throw throwable;
                                try {
                                    ((InputStream)in).close();
                                    throw throwable;
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    };
                } else if (this.searchMethod == 1 && enableOptimize) {
                    republisher = new FileExpirationService.ExpirationListener(){

                        public void expiredAndRemove(File f) {
                            CmCache cmc = (CmCache)Cm.this.caches.get(new File(f.getParent()).getName());
                            cmc.remove(f.getName());
                        }
                    };
                }
                docDirs[0] = this.initDir(TmpDirName);
                docDirs[1] = this.initDir(PrivateDirName);
                docDirs[2] = this.initDir(PublicDirName);
                this.expirer = new FileExpirationService(schedulerService, this.rootDir, docDirs, republisher);
                if (this.searchMethod == 2 && enableOptimize) {
                    new Thread((Runnable)new CmIndexerThread(docDirs, new IndexService.Index[]{(IndexService.Index)this.indexes.get(TmpDirName), (IndexService.Index)this.indexes.get(PrivateDirName), (IndexService.Index)this.indexes.get(PublicDirName)}), "CmIndexerThread :" + areaName).start();
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block15;
                LOG.warn((Object)"Unable to create Cm", (Throwable)e);
            }
        }
    }

    public static String createTmpName(StructuredDocument doc) {
        int hash = 0;
        try {
            StringWriter out = new StringWriter();
            ((StructuredTextDocument)doc).sendToWriter(out);
            hash = out.toString().hashCode();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "cm" + Integer.toString(hash);
    }

    public long getExpirationTime(String dn, String fn) {
        File file = this.getFile(dn, fn);
        long absoluteExpirationTimeForOthers = this.expirer.getExpirationTime(file);
        if (absoluteExpirationTimeForOthers == -1L) {
            return 0L;
        }
        return absoluteExpirationTimeForOthers - System.currentTimeMillis();
    }

    public String[] getFileNames(String dn) {
        if (dn == null) {
            return null;
        }
        File dir = new File(this.rootDir, dn);
        return dir.list();
    }

    public String getOldestFile(String dn) {
        if (dn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"nul directory name");
            }
            return null;
        }
        try {
            File dir = new File(this.rootDir, dn);
            File[] list = dir.listFiles();
            if (list == null || list.length == 0) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"no files in folder");
                }
                return null;
            }
            long oldestTime = list[0].lastModified();
            File oldest = list[0];
            File file = null;
            long time = 0L;
            int i = 1;
            while (i < list.length) {
                file = list[i];
                time = file.lastModified();
                if (time < oldestTime) {
                    oldest = list[i];
                    oldestTime = time;
                }
                ++i;
            }
            return oldest.getName();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.debug((Object)"Failure determining oldest file", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isFolder(String dn) {
        if (dn == null) {
            return false;
        }
        File dir = new File(this.rootDir, dn);
        return dir.exists() && dir.isDirectory();
    }

    public FileInputStream getInputStream(String dn, String fn) throws IOException {
        return new FileInputStream(this.getFile(dn, fn));
    }

    public void createFolder(String f) throws IOException {
        this.createFolder(f, null);
    }

    public synchronized void createFolder(String f, String[] elements) throws IOException {
        File dir = this.initDir(f);
        this.expirer.addDocDir(dir);
        switch (this.searchMethod) {
            case 0: {
                break;
            }
            case 2: {
                if (this.indexes.get(f) != null) break;
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Creating indexer threads with null index");
                }
                new Thread((Runnable)new CmIndexerThread(new File[]{dir}, new IndexService.Index[]{(IndexService.Index)this.indexes.get(f)}), "CmIndexerThread: " + f).start();
                break;
            }
            case 1: {
                if (elements == null || this.caches.get(f) != null) break;
                CmCache cmc = new CmCache(elements, dir);
                this.caches.put(f, cmc);
                new Thread((Runnable)cmc, f + " CmCache ").start();
                break;
            }
        }
    }

    public String createTmpName(String dn) {
        String tryName;
        File dir = new File(this.rootDir, dn);
        while (new File(dir, tryName = "cm" + Integer.toString(random.nextInt())).exists()) {
        }
        return tryName;
    }

    /*
     * Unable to fully structure code
     */
    public void remove(String dn, String fn) throws IOException {
        file = this.getFile(dn, fn);
        try {
            block22: {
                this.expirer.cancelFileExpiration(file);
                if (this.searchMethod == 2) {
                    is = null;
                    try {
                        is = new FileInputStream(file);
                        ((IndexService.Index)this.indexes.get(dn)).remove(fn, is);
                        var8_5 = null;
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var7_15) {
                        var8_8 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var7_15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block22;
                        catch (IndexService.BadDocumentException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"bad file ", (Throwable)e);
                            }
                            var8_6 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block22;
                        }
                        catch (IndexService.IndexException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index Exception", (Throwable)e);
                            }
                            var8_7 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block22;
                        }
                    }
                }
                if (this.searchMethod == 1) {
                    ((CmCache)this.caches.get(dn)).remove(fn);
                }
            }
            var11_16 = null;
            ** if (file.delete()) goto lbl-1000
        }
        catch (Throwable var10_18) {
            var11_17 = null;
            if (!file.delete()) {
                throw new IOException("Cm cannot remove the file " + file);
            }
            throw var10_18;
        }
lbl-1000:
        // 1 sources

        {
            throw new IOException("Cm cannot remove the file " + file);
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    public boolean exists(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        return file.exists();
    }

    public StructuredDocument restore(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        return this.restoreFile(file);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] restoreBytes(String dn, String fn) throws IOException {
        block9: {
            file = this.getFile(dn, fn);
            ip = null;
            buffer = null;
            try {
                ip = new FileInputStream(file);
                size = (int)file.length();
                buffer = new byte[size];
                got = 0;
                while (true) {
                    if (got >= size) {
                        break block9;
                    }
                    res = ip.read(buffer, got, size - got);
                    if (-1 == res) {
                        ip.close();
                        var9_9 = null;
                        var11_10 = null;
                        if (ip == null) return var9_9;
                        break;
                    }
                    got += res;
                }
            }
            catch (Throwable var10_16) {
                var11_12 = null;
                if (ip == null) throw var10_16;
                try {
                    ip.close();
                    throw var10_16;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw var10_16;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 113->121)] { 
lbl35:
            // 1 sources

            ip.close();
            return var9_9;
lbl37:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var9_9;
        }
        var11_11 = null;
        if (ip == null) return buffer;
        try {}
        catch (IOException ignored) {
            return buffer;
        }
        ip.close();
        return buffer;
    }

    public void save(String dn, String fn, StructuredDocument doc) throws IOException {
        this.save(dn, fn, doc, 1471228928L, 0x6DDD00L);
    }

    /*
     * Unable to fully structure code
     */
    public void save(String dn, String fn, StructuredDocument doc, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        block37: {
            block36: {
                file = this.getFile(dn, fn);
                if (this.searchMethod == 2 && file.exists()) {
                    in = null;
                    try {
                        in = new FileInputStream(file);
                        ((IndexService.Index)this.indexes.get(dn)).remove(fn, in);
                        var13_8 = null;
                        ** if (in == null) goto lbl-1000
                    }
                    catch (Throwable var12_22) {
                        var13_11 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var12_22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block36;
                        catch (IndexService.BadDocumentException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : Bad Document", (Throwable)e);
                            }
                            var13_9 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                            break block36;
                        }
                        catch (IndexService.IndexException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : Index Exception", (Throwable)e);
                            }
                            var13_10 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
            }
            op = null;
            try {
                op = new FileOutputStream(file);
                doc.sendToStream(op);
                op.close();
                op = null;
                if (this.searchMethod == 2) {
                    try {
                        if (Cm.LOG.isDebugEnabled() && Cm.LOG.isEnabledFor(Priority.DEBUG)) {
                            Cm.LOG.debug((Object)("indexing " + file + ": " + dn + " " + fn));
                        }
                        ((IndexService.Index)this.indexes.get(dn)).add(fn, doc.getStream());
                    }
                    catch (IOException e) {
                        if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                            Cm.LOG.warn((Object)"Index : IO Exception", (Throwable)e);
                        }
                        throw e;
                    }
                    catch (IndexService.BadDocumentException e) {
                        if (!Cm.LOG.isEnabledFor(Priority.WARN)) ** GOTO lbl76
                        Cm.LOG.warn((Object)"Save failed", (Throwable)e);
                    }
                    catch (IndexService.IndexException e) {
                        if (!Cm.LOG.isEnabledFor(Priority.WARN)) ** GOTO lbl76
                        Cm.LOG.warn((Object)"Save failed", (Throwable)e);
                    }
                } else if (this.searchMethod == 1) {
                    ((CmCache)this.caches.get(dn)).add(fn, doc);
                }
lbl76:
                // 8 sources

                now = System.currentTimeMillis();
                this.expirer.scheduleFileExpiration(file, now + timeoutInMyCache, timeoutForOthers);
                var16_24 = null;
                ** if (op == null) goto lbl-1000
            }
            catch (Throwable var15_28) {
                var16_25 = null;
                if (op != null) {
                    try {
                        op.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var15_28;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    op.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block37;
                catch (IOException e) {
                    if (Cm.LOG.isEnabledFor(Priority.DEBUG)) {
                        Cm.LOG.debug((Object)"Cm cannot write doc", (Throwable)e);
                    }
                    throw e;
                }
            }
        }
    }

    public void saveBytes(String dn, String fn, byte[] buffer) throws IOException {
        this.saveBytes(dn, fn, buffer, -1L, -1L);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveBytes(String dn, String fn, byte[] buffer, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        FileOutputStream op;
        block16: {
            File file = this.getFile(dn, fn);
            op = null;
            op = new FileOutputStream(file);
            op.write(buffer);
            if (this.searchMethod == 2) {
                ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                try {
                    ((IndexService.Index)this.indexes.get(dn)).add(fn, bis);
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Index : IO Exception", (Throwable)e);
                    }
                }
                catch (IndexService.BadDocumentException bde) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Index : Bad Document", (Throwable)bde);
                    }
                }
                catch (IndexService.IndexException ie) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block16;
                    LOG.warn((Object)"Index : Index Exception", (Throwable)ie);
                }
            }
        }
        Object var15_13 = null;
        if (op == null) return;
        try {
            op.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cm cannot write doc");
                }
                Object var15_14 = null;
                if (op == null) return;
                try {
                    op.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (op == null) throw throwable;
            try {
                op.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void saveBytes(String dn, String fn, InputStream source) throws IOException {
        this.saveBytes(dn, fn, source, -1L, -1L);
    }

    /*
     * Loose catch block
     */
    public void saveBytes(String dn, String fn, InputStream source, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        block32: {
            IOException e322;
            FileOutputStream op;
            block30: {
                File file;
                block29: {
                    file = this.getFile(dn, fn);
                    op = null;
                    op = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int res;
                        if ((res = source.read(buffer)) == 0) {
                            continue;
                        }
                        if (res == -1) break;
                        op.write(buffer, 0, res);
                    }
                    op.flush();
                    op.close();
                    op = null;
                    source.close();
                    source = new FileInputStream(file);
                    if (this.searchMethod == 2) {
                        try {
                            ((IndexService.Index)this.indexes.get(dn)).add(fn, source);
                        }
                        catch (IOException e2) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : IO Exception", (Throwable)e2);
                            }
                            break block29;
                        }
                        catch (IndexService.BadDocumentException bde) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : Bad Document", (Throwable)bde);
                            }
                            break block29;
                        }
                        catch (IndexService.IndexException ie) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : Index Error", (Throwable)ie);
                            }
                            break block29;
                        }
                    }
                    if (this.searchMethod == 1) {
                        ((CmCache)this.caches.get(dn)).add(fn);
                    }
                }
                this.expirer.scheduleFileExpiration(file, System.currentTimeMillis() + timeoutInMyCache, timeoutForOthers);
                Object var15_14 = null;
                if (source == null) break block30;
                try {
                    source.close();
                    source = null;
                }
                catch (IOException e322) {
                    // empty catch block
                }
            }
            if (op != null) {
                try {
                    op.close();
                    op = null;
                }
                catch (IOException e322) {}
            }
            break block32;
            {
                catch (IOException e4) {
                    IOException e322;
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Cm cannot write doc", (Throwable)e4);
                    }
                    Object var15_15 = null;
                    if (source != null) {
                        try {
                            source.close();
                            source = null;
                        }
                        catch (IOException e322) {
                            // empty catch block
                        }
                    }
                    if (op != null) {
                        try {
                            op.close();
                            op = null;
                        }
                        catch (IOException e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e322;
                Object var15_16 = null;
                if (source != null) {
                    try {
                        source.close();
                        source = null;
                    }
                    catch (IOException e322) {
                        // empty catch block
                    }
                }
                if (op != null) {
                    try {
                        op.close();
                        op = null;
                    }
                    catch (IOException e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void cleanupFolder(String dn) throws IOException {
        if (dn == null) {
            return;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)(" cleaning up " + dn));
        }
        File dir = new File(this.rootDir, dn);
        String[] files = this.getFileNames(dn);
        int i = 0;
        while (files != null && i < files.length) {
            File file = new File(dir, files[i]);
            if (!file.delete() && LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("  failed removing " + files[i]));
            }
            ++i;
        }
    }

    public Enumeration search(String dn, String tag, String value) {
        CmCache cmc;
        String[] files;
        Vector<String> res = new Vector<String>();
        if (this.searchMethod == 2 && value.indexOf("*") == -1) {
            files = this.searchIndex(dn, tag, value);
            if (files == null) {
                return res.elements();
            }
            if (files.length > 0) {
                int i = 0;
                while (i < files.length) {
                    if (null != files[i]) {
                        res.addElement(files[i]);
                    } else if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"There was a null element in the index results");
                    }
                    ++i;
                }
                return res.elements();
            }
        } else if (this.searchMethod == 1 && (cmc = (CmCache)this.caches.get(dn)).containsKey(tag)) {
            return cmc.query(tag, value);
        }
        if ((files = this.getFileNames(dn)) == null) {
            return res.elements();
        }
        int i = 0;
        while (i < files.length) {
            if (this.searchFile(dn, files[i], tag, value)) {
                if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("found a hit " + files[i]));
                }
                res.addElement(files[i]);
            }
            ++i;
        }
        return res.elements();
    }

    File getFile(String dn, String fn) {
        File d = new File(this.rootDir, dn);
        if (!d.exists()) {
            d.mkdirs();
            this.expirer.addDocDir(d);
        }
        return new File(d, fn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StructuredDocument restoreFile(File file) throws IOException {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("restore document from " + file));
        }
        FileInputStream ip = null;
        StructuredDocument doc = null;
        try {
            ip = new FileInputStream(file);
            doc = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), ip);
            Object var5_4 = null;
            if (ip == null) return doc;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ip == null) throw throwable;
            try {
                ((InputStream)ip).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)ip).close();
            return doc;
        }
        catch (IOException e) {}
        return doc;
    }

    private File initDir(String dirName) throws IOException {
        File dir;
        block5: {
            dir = new File(this.rootDir, dirName);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Cm cannot create directory " + dir);
            }
            if (this.searchMethod == 2 && !this.indexes.containsKey(dirName)) {
                try {
                    this.indexes.put(dirName, indexService.getIndex(new File(dir.getAbsolutePath(), this.indexFilename)));
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Creating index " + dirName));
                    }
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled() || !LOG.isEnabledFor(Priority.WARN)) break block5;
                    LOG.warn((Object)("Failed to create index " + e));
                }
            }
        }
        return dir;
    }

    private String[] searchIndex(String dn, String tag, String value) {
        block6: {
            if (this.searchMethod != 2) {
                return null;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Looking for " + tag + " = " + value + " in " + dn + "Rootdir = " + this.rootDir.toString()));
            }
            String query = "//[" + tag + "='" + value + "']";
            try {
                IndexService.Index index = (IndexService.Index)this.indexes.get(dn);
                String[] results = index.query(query);
                return results;
            }
            catch (IndexService.BadQueryException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"bad query expression ", (Throwable)e);
                }
            }
            catch (IndexService.IndexException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                LOG.warn((Object)"bad index", (Throwable)e);
            }
        }
        return null;
    }

    private synchronized void indexFile(String dirname, String name, StructuredDocument doc) {
        block7: {
            if (this.searchMethod != 2) {
                return;
            }
            try {
                ((IndexService.Index)this.indexes.get(dirname)).add(name, doc.getStream());
            }
            catch (IndexService.BadDocumentException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Index : Bad Document", (Throwable)e);
                }
            }
            catch (IndexService.IndexException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Index : Index Exception", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block7;
                LOG.warn((Object)"Index : IO Failure", (Throwable)e);
            }
        }
    }

    private boolean searchFile(String dn, String fn, String tag, String value) {
        boolean startswith = false;
        boolean endswith = false;
        StructuredDocument doc = null;
        try {
            doc = this.restore(dn, fn);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("searchFile failed restoring doc: " + e));
            }
            return false;
        }
        if (doc == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"searchFile failed restoring doc: doc is null");
            }
            return false;
        }
        try {
            Element e = null;
            Enumeration enumeration = doc.getChildren();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"searchFile failed restoring doc: doc has no element");
                }
                return false;
            }
            String uTag = tag.toUpperCase();
            while (enumeration.hasMoreElements()) {
                e = (Element)enumeration.nextElement();
                if (!((String)e.getKey()).toUpperCase().equals(uTag)) continue;
                Object val = e.getValue();
                if (!value.getClass().isInstance(val) || value.length() < 1) continue;
                if (value.charAt(0) == '*') {
                    endswith = true;
                    value = value.substring(1, value.length());
                }
                if (value.charAt(value.length() - 1) == '*') {
                    startswith = true;
                    value = value.substring(0, value.indexOf("*"));
                }
                if (value.length() == 0) {
                    return false;
                }
                String uVal = ((String)val).toUpperCase();
                String uValue = value.toUpperCase();
                if (startswith && !endswith) {
                    return uVal.startsWith(uValue);
                }
                if (endswith && !startswith) {
                    return uVal.endsWith(uValue);
                }
                if (startswith && endswith) {
                    return uVal.indexOf(uValue) >= 0;
                }
                return uVal.equals(uValue);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"searchFile has failed: ", (Throwable)e);
            }
            return false;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        new Thread((Runnable)schedulerService, "SchedulerService").start();
    }

    public static interface ExpirationListener {
        public void expired(String var1, String var2, long var3);
    }
}

