/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WARDirContext
extends BaseDirContext {
    protected ZipFile base = null;
    protected Entry entries = null;

    public WARDirContext() {
    }

    public WARDirContext(Hashtable env) {
        super(env);
    }

    protected WARDirContext(ZipFile base, Entry entries) {
        this.base = base;
        this.entries = entries;
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new CompositeName(name), attrIds);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Entry entry = null;
        entry = name.isEmpty() ? this.entries : this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        ZipEntry zipEntry = entry.getEntry();
        ResourceAttributes attrs = new ResourceAttributes();
        attrs.setCreationDate(new Date(zipEntry.getTime()));
        attrs.setName(entry.getName());
        if (!zipEntry.isDirectory()) {
            attrs.setResourceType("");
        }
        attrs.setContentLength(zipEntry.getSize());
        attrs.setLastModified(new Date(zipEntry.getTime()));
        return attrs;
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.list(this.entries));
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        return new NamingContextEnumeration(this.list(entry));
    }

    protected Vector list(Entry entry) {
        Vector<NamingEntry> entries = new Vector<NamingEntry>();
        Object[] children = entry.getChildren();
        Arrays.sort(children);
        NamingEntry namingEntry = null;
        int i = 0;
        while (i < children.length) {
            ZipEntry current = ((Entry)children[i]).getEntry();
            Object object = null;
            object = current.isDirectory() ? new WARDirContext(this.base, (Entry)children[i]) : new WARResource(current);
            namingEntry = new NamingEntry(((Entry)children[i]).getName(), object, 0);
            entries.addElement(namingEntry);
            ++i;
        }
        return entries;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.list(this.entries));
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        return new NamingContextBindingsEnumeration(this.list(entry));
    }

    protected void loadEntries() {
        try {
            Enumeration<? extends ZipEntry> entryList = this.base.entries();
            this.entries = new Entry("/", new ZipEntry("/"));
            while (entryList.hasMoreElements()) {
                ZipEntry entry = entryList.nextElement();
                String name = this.normalize(entry);
                int pos = name.lastIndexOf(47);
                String entryName = name.substring(pos + 1, name.length());
                CompositeName compositeName = new CompositeName(name.substring(0, pos));
                Entry parent = this.treeLookup(compositeName);
                Entry child = new Entry(entryName, entry);
                if (parent == null) continue;
                parent.addChild(child);
            }
        }
        catch (Exception exception) {}
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        ZipEntry zipEntry = entry.getEntry();
        if (zipEntry.isDirectory()) {
            return new WARDirContext(this.base, entry);
        }
        return new WARResource(entry.getEntry());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected String normalize(ZipEntry entry) {
        String result = "/" + entry.getName();
        if (entry.isDirectory()) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        if (!docBase.endsWith(".war")) {
            throw new IllegalArgumentException(this.sm.getString("warResources.notWar"));
        }
        File base = new File(docBase);
        if (!base.exists() || !base.canRead() || base.isDirectory()) {
            throw new IllegalArgumentException(this.sm.getString("warResources.notWar"));
        }
        try {
            this.base = new ZipFile(base);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.sm.getString("warResources.invalidWar", (Object)e.getMessage()));
        }
        super.setDocBase(docBase);
        this.loadEntries();
    }

    protected Entry treeLookup(Name name) {
        if (name.isEmpty()) {
            return this.entries;
        }
        Entry currentEntry = this.entries;
        int i = 0;
        while (i < name.size()) {
            if (name.get(i).length() != 0 && (currentEntry = currentEntry.getChild(name.get(i))) == null) {
                return null;
            }
            ++i;
        }
        return currentEntry;
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected class Entry
    implements Comparable {
        protected String name = null;
        protected ZipEntry entry = null;
        protected Entry[] children = new Entry[0];

        public Entry(String name, ZipEntry entry) {
            this.name = name;
            this.entry = entry;
        }

        public void addChild(Entry entry) {
            Entry[] newChildren = new Entry[this.children.length + 1];
            int i = 0;
            while (i < this.children.length) {
                newChildren[i] = this.children[i];
                ++i;
            }
            newChildren[this.children.length] = entry;
            this.children = newChildren;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Entry)) {
                return 1;
            }
            return this.name.compareTo(((Entry)o).getName());
        }

        public Entry getChild(String name) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i].name.equals(name)) {
                    return this.children[i];
                }
                ++i;
            }
            return null;
        }

        public Entry[] getChildren() {
            return this.children;
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public String getName() {
            return this.name;
        }
    }

    protected class WARResource
    extends Resource {
        protected ZipEntry entry;

        public WARResource(ZipEntry entry) {
            this.entry = entry;
        }

        public InputStream streamContent() throws IOException {
            try {
                if (this.binaryContent == null) {
                    this.inputStream = WARDirContext.this.base.getInputStream(this.entry);
                }
            }
            catch (ZipException e) {
                throw new IOException(e.getMessage());
            }
            return super.streamContent();
        }
    }
}

