<?xml version="1.0"?> 

<!--

$Id: controller.xsl,v 1.55 2002/02/08 01:05:53 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- if the page we are about to display has only control, we should display the
  page as if ht only had one column.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                extension-element-prefixes="functions timestamp"
                exclude-result-prefixes="layout page"
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes"
                encoding="ISO-8859-1"/>

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.page.title" select="'Welcome to Reptile'"/>

    <!-- the layer parameter defines what page layer we should use. -->
    <xsl:param name="reptile.layer" select="/layout:layout/layout:layer-index/@default"/>

    <xsl:param name="reptile.sequence.name" select="'urn:subscriptions'"/>

    <xsl:template match="/layout:layout">

        <!-- get the number of columns for the layer requested -->
        <xsl:variable name="numColumns" select="./layout:layer-index/layout:layer[@name = $reptile.layer]/@numColumns"/>

        <page:page title="{$reptile.page.title}">

        <!-- FIXME: the problem is here!!! -->
        <table width="100%" 
               border="0" 
               cellpadding="0" 
               cellspacing="0">

        <tr>

        <!-- two page functionality -->
        <td colspan="{$numColumns}" width="100%">
        
        <table bgcolor="white"
               cellpadding="6" 
               cellspacing="0"
               width="100%">

<!--         <td nowrap="true"  -->
<!--             valign="middle"  -->
<!--             class="reptile-layer-item"> -->

<!--             <xsl:call-template name="channel-info"> -->

<!--                 <xsl:with-param name="name"> -->
<!--                      <xsl:value-of select="$reptile.layer"/> -->
<!--                 </xsl:with-param> -->

<!--             </xsl:call-template> -->

<!--         </td> -->

        <td nowrap="nowrap" 
            class="reptile-layer-item"
            align="right">

            <xsl:call-template name="reptile-category-selector"/>

        </td>
            
        <td width="100%" class="reptile-layer-noitem">

        </td>

        <td nowrap="nowrap" 
            class="reptile-page-option"
            align="right">

            <xsl:call-template name="reptile-action-selector"/>

        </td>

        </table>
        
        </td>

        </tr>

        <!--  
        
            Figure out how to display the controls on the page

            - If we only have one control... display it right in the center.  It
              would look wierd to have one control to the right or left all by
              itself. 

            - If we are running with one column, display the content in the center.

        -->

        <xsl:apply-templates select="/layout:layout/layout:layer-index/layout:layer[@numColumns='1'][@name = $reptile.layer]"/> 

        <xsl:apply-templates select="/layout:layout/layout:layer-index/layout:layer[@numColumns='2'][@name = $reptile.layer]"/>

        </table>

        </page:page>        

    </xsl:template>

    <xsl:template match="/layout:layout/layout:layer-index/layout:layer[@numColumns='1']">

       <xsl:comment>
       
       CONROLLER: BEGIN -> One column controller.

       </xsl:comment>

       <tr>

       <td valign="top" 
           align="center"
           width="100%"
           class="reptile-controller-background ">

       <table width="100%" cellspacing="3">

             <!-- Mozilla needs at lest one TD if it is to render this table -->
             <tr><td></td></tr>

             <!-- now selectively apply templates for controls we need -->
             <xsl:apply-templates select="/layout:layout/layout:content/layout:position[@layer=$reptile.layer]"/>

        </table>
        </td>

        </tr>

        <xsl:comment>

        CONROLLER: END -> One column controller.

        </xsl:comment>

     </xsl:template>

     <xsl:template match="/layout:layout/layout:layer-index/layout:layer[@numColumns='2']">

        <xsl:comment>

        CONROLLER: BEGIN -> Two column controller.

        </xsl:comment>

         <tr>

         <td width="50%" 
             valign="top" 
             class="reptile-controller-background">

             <table width="100%" cellspacing="3">

                <xsl:comment>

                CONROLLER: BEGIN -> column one

                </xsl:comment>

                <!-- Mozilla needs at lest one TD if it is to render this table -->
               <tr><td></td></tr>

               <!-- now selectively apply templates for controls we need -->
               <xsl:apply-templates select="/layout:layout/layout:content/layout:position[@column='left'][@layer=$reptile.layer]"/>

               <xsl:comment>
               
               CONROLLER: END -> column one
        
               </xsl:comment>

            </table>

        </td>

        <td width="50%" 
            valign="top" 
            class="reptile-controller-background">

            <table width="100%" cellspacing="3">

               <xsl:comment>
               
               CONROLLER: BEGIN -> column two
        
               </xsl:comment>
               <!-- Mozilla needs at lest one TD if it is to render this table -->
               <tr><td></td></tr>

               <xsl:apply-templates select="/layout:layout/layout:content/layout:position[@column='right'][@layer=$reptile.layer]"/>

               <xsl:comment>
               
               CONROLLER: END -> column two
        
               </xsl:comment>

            </table>

        </td>        
        
        </tr>

       <xsl:comment>
       
       CONROLLER: END -> Two column controller.

       </xsl:comment>

    </xsl:template>

    <xsl:template name="channel-info">

        <xsl:param name="name"/>

        <xsl:value-of select="$name"/>

        <xsl:variable name="channel-count">
            <xsl:value-of select="count( /layout:layout/layout:content/layout:position[@layer = $name ] )"/>
        </xsl:variable>

        <!-- now display the channel count -->
        (<xsl:value-of select="$channel-count"/>)

    </xsl:template>

    <!-- since only the position is matched we have to recreate the whole
    'content' element -->
    <xsl:template match="layout:position">

        <layout:content>

            <xsl:attribute name="location">

                <xsl:value-of select="../@location"/>

            </xsl:attribute>        

            <xsl:attribute name="contentType">

                <xsl:value-of select="../@contentType"/>

            </xsl:attribute>        

            <layout:position>

                <xsl:attribute name="column">

                    <xsl:value-of select="@column"/>

                </xsl:attribute>        

                <xsl:attribute name="layer">

                    <xsl:value-of select="@layer"/>

                </xsl:attribute>        

            </layout:position>

        </layout:content>

    </xsl:template>

    <xsl:template name="reptile-category-selector">

        <table nowrap="nowrap">

            <form type="post">

            <td>

                <select name="reptile.layer" onChange="form.submit()">

                <xsl:for-each select="./layout:layer-index/layout:layer">

                    <xsl:sort select="@name"/>

                    <option value="{@name}">

                        <xsl:if test="@name = $reptile.layer">

                            <xsl:attribute name="selected">selected</xsl:attribute>

                        </xsl:if>

                        <xsl:call-template name="channel-info">

                            <xsl:with-param name="name">
                                 <xsl:value-of select="@name"/>
                            </xsl:with-param>

                        </xsl:call-template>

                    </option>

                </xsl:for-each>

                </select>

            </td>

            <td>
            
            <input name="reptile.sequence.name" 
                   value="{$reptile.sequence.name}"
                   type="hidden"/>

            </td>

            </form>
        
        </table>

    </xsl:template>

    <xsl:template name="reptile-action-selector">

        <div class="reptile-action-selector">

        <table nowrap="nowrap">

            <form type="post">

            <td>

            <b>Action: </b>

            </td>

            <td>

                <select name="reptile.action" onChange="reptileSubmitForm( this, this.form )">

                    <option value="">Choose an action...</option>

                    <option value="MarkAllSubscriptionsRead">Mark all subscriptions read</option>
                    <option value="MarkAllSubscriptionsUnread">Mark all subscriptions unread</option>

                </select>

            </td>

            <td>

            <input name="reptile.sequence.name" 
                   value="{$reptile.sequence.name}"
                   type="hidden"/>

            <input name="reptile.layer" 
                   value="{$reptile.layer}"
                   type="hidden"/>

            </td>
            
            </form>
        
        </table>

        </div>
        
    </xsl:template>

</xsl:stylesheet>

