<?xml version="1.0"?> 

<!--

$Id: page.xsl,v 1.48 2002/02/09 07:31:21 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:channels="xalan://org.openprivacy.reptile.extensions.om.ChannelExtension"
                xmlns:content="xalan://org.openprivacy.reptile.extensions.om.ArticleExtension"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                extension-element-prefixes="timestamp proxy channels content"
                exclude-result-prefixes="sub page error link-producer"
                version="1.0">

    <xsl:include href="resource:/xsl/misc/xhtml/reptile-link-producer.xsl"/>

    <xsl:include href="resource:/xsl/misc/xhtml/reptile-logo-producer.xsl"/>

    <xsl:include href="resource:/xsl/misc/error/mozilla/mozilla-error.xsl"/>

    <xsl:include href="resource:/xsl/option/mozilla-channel-options.xsl"/>

    <xsl:include href="resource:/xsl/misc/xhtml/services.xsl"/>

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <!-- NPTE: we output html here because this is out last step and we want the
    browser to support HTML 4.01-->

    <xsl:output indent="yes" method="html"/>

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.search.criteria" select="''"/>

    <xsl:param name="reptile.layer" select="''"/>

    <xsl:template match="page:page">
    
        <html>

        <head>

            <title>
            <xsl:value-of select="@title"/>        
            </title>

            <!-- NOTE: Mozilla can't handle loading stylesheets from file:// URLs.  -->
            <link title="Style"
                  type="text/css"
                  href="/reptile/style/default.css"
                  rel="stylesheet"/>

            <xsl:call-template name="include-options"/>

        </head>

        <body>

        <table cellpadding="0" 
               width="100%"
               bgcolor="#efefef">

        <td>

            <table>
               
                <td nowrap="nowrap" class="reptile-nav-item">

                    <xsl:call-template name="link-producer:my-subscriptions"/>

                </td>

                <td nowrap="nowrap" class="reptile-nav-item">

                    <xsl:call-template name="link-producer:publish"/>

                </td>

<!--                 <td nowrap="nowrap" class="reptile-nav-item"> -->

<!--                     <xsl:call-template name="link-producer:advanced-search"/> -->

<!--                 </td> -->

<!--                 <td nowrap="nowrap" class="reptile-nav-item"> -->

<!--                     <xsl:call-template name="link-producer:tools"/> -->

<!--                 </td> -->

                <td nowrap="nowrap" class="reptile-nav-item">

                    <xsl:call-template name="link-producer:settings"/>

                </td>

                <td nowrap="nowrap" class="reptile-nav-item">

                    <xsl:call-template name="link-producer:about"/>

                </td>

                <td nowrap="nowrap" class="reptile-nav-item">

                    <xsl:call-template name="link-producer:license"/>

                </td>

                <td nowrap="nowrap" class="reptile-nav-item">

                    <xsl:call-template name="link-producer:logout"/>

                </td>

            </table>
        </td>

        <td width="100%" align="right" class="reptile-page-timestamp" nowrap="nowrap">

            <xsl:value-of select="timestamp:get()"/>

        </td>

        </table>

        <table width="100%">

        <td class="reptile-welcome-message" width="100%">

        <div class="reptile-title">

            <xsl:value-of select="@title"/>

                <xsl:if test="$reptile.layer != ''">

                : <xsl:value-of select="$reptile.layer"/>

                </xsl:if>

        </div>

        </td>        

        <xsl:call-template name="search-form"/>

        </table>

        <xsl:apply-templates/>

        <xsl:call-template name="footer"/>

        </body>

        </html>

    </xsl:template>

    <!-- Generate a search form.  This is a small control at the top of the
    browser.-->

    <xsl:template name="search-form">

        <form method="get" action="{$reptile.home.location}">
        
        <td>

        <b>Search: </b>

        </td>

        <td>
        <select name="reptile.search.provider">
        
            <option value="ArticleSearchProvider">

                <content:count/> articles

            </option>

            <option value="ChannelSearchProvider">

                <channels:count/> channels

            </option>

        </select>
        </td>

        <td>
        
        <input name="reptile.search.criteria" type="text" class="reptile-quick-search">

            <xsl:attribute name="value">

                <xsl:value-of select="$reptile.search.criteria"/>

            </xsl:attribute>

        </input>

        </td>

        <td>
        <input type="hidden" name="reptile.action" value="Search"/>
        <input type="hidden" name="reptile.layer" value="Search Results"/>
        </td>
        
        </form>
            
    </xsl:template>

    <xsl:template name="footer">

        <hr/>

        <table width="100%">

        <td nowrap="true" class="reptile-page-footer">

            Best used with the <a href="http://www.mozilla.org">Mozilla</a> browser.

        </td>

        <td width="100%" align="right" nowrap="true" class="reptile-page-footer">

            Powered by <a href="http://reptile.openprivacy.org">Reptile</a>, an <a
            href="http://www.openprivacy.org">OpenPrivacy</a> enabled technology.
            
        </td>

        </table>

    </xsl:template>

</xsl:stylesheet>
