<?xml version="1.0"?> 

<!--

$Id: mozilla-misc-admin.xsl,v 1.8 2001/12/23 01:53:40 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:sequence-cache="xalan://org.openprivacy.reptile.extensions.admin.SequenceCacheExtension"
                xmlns:templates-cache="xalan://org.openprivacy.reptile.extensions.admin.TemplatesCacheExtension"
                extension-element-prefixes="sequence-cache templates-cache"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.sequence.name" select="''"/>

    <xsl:param name="reptile.action" select="''"/>

    <xsl:param name="reptile.flush-sequence-cache.message" select="''"/>

    <xsl:param name="reptile.flush-templates-cache.message" select="''"/>

    <xsl:param name="reptile.update-content.message" select="''"/>

    <xsl:template match="/bootstrap:bootstrap">

        <control:content>
    
            <dc:title>Misc Admin Options</dc:title>
    
            <control:body>

            <p>This control can be used to perform misc administration features
            within Reptile.</p>
    
            <xsl:call-template name="flush-sequence-cache"/>

            <xsl:call-template name="flush-templates-cache"/>

            <xsl:call-template name="update-content"/>

            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template name="flush-sequence-cache">

        <fieldset>

            <legend>Flush Sequence Cache</legend>

            <form>

            <p>
            Used to flush the 'sequence cache'.  The sequence cache contains all
            XSLT transformer output.  If you suspect that this output may be stale,
            either because you <i>know</i> newer content is available, or you are a
            developer, this will allow you to flush the cache in order to force
            Reptile to regenerate its content.
            </p>

            <fieldset>

            <legend>Stats: </legend>

                <b>Cache Hits: </b> <sequence-cache:hits/>
                <br/>            

                <b>Cache Misses: </b> <sequence-cache:misses/>
                <br/>            

            </fieldset>

            <table width="100%">

            <td class="noticeit">
            
                <xsl:value-of select="$reptile.flush-sequence-cache.message"/>

            </td>
            
            <td align="right">

                <input type="submit" value="Flush sequence cache"/>
                
            </td>
            
            </table>

            <input type="hidden" name="reptile.action" value="FlushSequenceCache"/>

            <input type="hidden" name="reptile.action.next.layer" value="{$reptile.action}"/>
             
            <input type="hidden" name="reptile.action.next.sequence" value="urn:settings"/>

            <!-- message to display to the user -->

            <input type="hidden" name="reptile.flush-sequence-cache.message" value="Sequence cache has been flushed."/>

            </form>

        </fieldset>
    
    </xsl:template>

    <xsl:template name="flush-templates-cache">

        <fieldset>

            <legend>Flush Templates Cache</legend>

            <form>

            <p>
            Used to flush the templates cache'.  This contains pre-compiled XSLT
            templates.  If you modify a stylesheet but its output is not being
            generated correctly you can try flushing the cache.
            </p>

            <fieldset>

            <legend>Stats: </legend>
            
            <b>Current cache size: </b> <templates-cache:size/>

            </fieldset>

            <table width="100%">

            <td class="noticeit">
            
                <xsl:value-of select="$reptile.flush-templates-cache.message"/>

            </td>
            
            <td align="right">

                <input type="submit" value="Flush templates cache"/>
                
            </td>
            
            </table>

            <input type="hidden" name="reptile.action" value="FlushTemplatesCache"/>

            <input type="hidden" name="reptile.action.next.layer" value="{$reptile.action}"/>
             
            <input type="hidden" name="reptile.action.next.sequence" value="urn:settings"/>

            <!-- message to display to the user -->

            <input type="hidden" name="reptile.flush-templates-cache.message" value="Tempates cache has been flushed."/>

            </form>

        </fieldset>
    
    </xsl:template>

    <xsl:template name="update-content">

        <fieldset>

            <legend>Update Proxied Content</legend>

            <form>

            <p>
            This allows you to update content cache in the <a
            href="http://panther.openprivacy.org">Panther</a> remote content
            cache.  This basically contains all the RSS, images, and other XML
            that Reptile fetches from remote sites.  If some of the content
            appears stale you can use this control to updated it.
            </p>

            <table width="100%">

            <td class="noticeit">
            
                <xsl:value-of select="$reptile.update-content.message"/>

            </td>
            
            <td align="right">

                <input type="submit" value="Update RSS content."/>
                
            </td>
            
            </table>

            <input type="hidden" name="reptile.action" value="RunTaskTypes"/>

            <input type="hidden" name="task_type" value="urn:task/type/rss"/>

            <input type="hidden" name="reptile.action.next.layer" value="{$reptile.action}"/>
             
            <input type="hidden" name="reptile.action.next.sequence" value="urn:settings"/>

            <!-- message to display to the user -->

            <input type="hidden" name="reptile.update-content.message" value="RSS content is now being updated."/>

            </form>

        </fieldset>
    
    </xsl:template>

</xsl:stylesheet>

