/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pool;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.factory.FactoryService;
import org.apache.turbine.services.factory.TurbineFactoryService;
import org.apache.turbine.services.pool.PoolService;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.pool.ArrayCtorRecyclable;
import org.apache.turbine.util.pool.BoundedBuffer;
import org.apache.turbine.util.pool.Recyclable;
import org.apache.velocity.runtime.configuration.Configuration;

public class TurbinePoolService
extends TurbineFactoryService
implements PoolService {
    public static final String POOL_CAPACITY = "pool.capacity";
    private int poolCapacity = 128;
    private HashMap poolRepository = new HashMap();

    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        if (conf != null) {
            try {
                int capacity = conf.getInt(POOL_CAPACITY, 128);
                if (capacity <= 0) {
                    throw new IllegalArgumentException("Capacity must be >0");
                }
                this.poolCapacity = capacity;
            }
            catch (Exception x) {
                throw new InitializationException("Failed to initialize TurbinePoolService", x);
            }
        }
        this.setInit(true);
    }

    public Object getInstance(String className) throws TurbineException {
        Object instance = this.pollInstance(className, null, null);
        return instance == null ? this.getFactory().getInstance(className) : instance;
    }

    public Object getInstance(String className, ClassLoader loader) throws TurbineException {
        Object instance = this.pollInstance(className, null, null);
        return instance == null ? this.getFactory().getInstance(className, loader) : instance;
    }

    public Object getInstance(String className, Object[] params, String[] signature) throws TurbineException {
        Object instance = this.pollInstance(className, params, signature);
        return instance == null ? this.getFactory().getInstance(className, params, signature) : instance;
    }

    public Object getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws TurbineException {
        Object instance = this.pollInstance(className, params, signature);
        return instance == null ? this.getFactory().getInstance(className, loader, params, signature) : instance;
    }

    public boolean isLoaderSupported(String className) throws TurbineException {
        return this.getFactory().isLoaderSupported(className);
    }

    public Object getInstance(Class clazz) throws TurbineException {
        Object instance = this.pollInstance(clazz.getName(), null, null);
        return instance == null ? super.getInstance(clazz) : instance;
    }

    public Object getInstance(Class clazz, Object[] params, String[] signature) throws TurbineException {
        Object instance = this.pollInstance(clazz.getName(), params, signature);
        return instance == null ? super.getInstance(clazz, params, signature) : instance;
    }

    public boolean putInstance(Object instance) {
        if (instance != null) {
            HashMap repository = this.poolRepository;
            String className = instance.getClass().getName();
            PoolBuffer pool = (PoolBuffer)repository.get(className);
            if (pool == null) {
                pool = new PoolBuffer(this.getCapacity(className));
                repository = (HashMap)repository.clone();
                repository.put(className, pool);
                this.poolRepository = repository;
                if (instance instanceof ArrayCtorRecyclable) {
                    pool.setArrayCtorRecyclable(true);
                }
            }
            return pool.offer(instance);
        }
        return false;
    }

    public int getCapacity(String className) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        if (pool == null) {
            int capacity = this.poolCapacity;
            Configuration conf = this.getConfiguration();
            if (conf != null) {
                try {
                    capacity = conf.getInt("pool.capacity." + className, this.poolCapacity);
                    if (capacity <= 0) {
                        capacity = this.poolCapacity;
                    }
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            return capacity;
        }
        return pool.capacity();
    }

    public void setCapacity(String className, int capacity) {
        HashMap<String, PoolBuffer> repository = this.poolRepository;
        repository = repository != null ? (HashMap)repository.clone() : new HashMap<String, PoolBuffer>();
        repository.put(className, new PoolBuffer(capacity));
        this.poolRepository = repository;
    }

    public int getSize(String className) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        return pool != null ? pool.size() : 0;
    }

    public void clearPool(String className) {
        HashMap repository = this.poolRepository;
        if (repository.get(className) != null) {
            repository = (HashMap)repository.clone();
            repository.remove(className);
            this.poolRepository = repository;
        }
    }

    public void clearPool() {
        this.poolRepository = new HashMap();
    }

    private Object pollInstance(String className, Object[] params, String[] signature) throws TurbineException {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        return pool != null ? pool.poll(params, signature) : null;
    }

    private FactoryService getFactory() {
        return (FactoryService)TurbineServices.getInstance().getService("FactoryService");
    }

    private class PoolBuffer {
        private BoundedBuffer pool;
        private boolean arrayCtorRecyclable;
        private ArrayList recyclers;

        public void setArrayCtorRecyclable(boolean isArrayCtor) {
            this.arrayCtorRecyclable = isArrayCtor;
        }

        public Object poll(Object[] params, String[] signature) throws TurbineException {
            Object instance;
            block12: {
                instance = this.pool.poll();
                if (instance != null) {
                    if (this.arrayCtorRecyclable) {
                        ((ArrayCtorRecyclable)instance).recycle(params);
                    } else if (instance instanceof Recyclable) {
                        try {
                            if (signature != null && signature.length > 0) {
                                Method recycle = this.getRecycle(signature);
                                if (recycle == null) {
                                    PoolBuffer poolBuffer = this;
                                    synchronized (poolBuffer) {
                                        recycle = this.getRecycle(signature);
                                        if (recycle == null) {
                                            Class<?> clazz = instance.getClass();
                                            recycle = clazz.getMethod("recycle", TurbinePoolService.super.getSignature(clazz, params, signature));
                                            ArrayList cache = this.recyclers != null ? (ArrayList)this.recyclers.clone() : new ArrayList();
                                            cache.add(new Recycler(recycle, signature));
                                            this.recyclers = cache;
                                        }
                                    }
                                }
                                recycle.invoke(instance, params);
                                break block12;
                            }
                            ((Recyclable)instance).recycle();
                        }
                        catch (Exception x) {
                            throw new TurbineException("Recycling failed for " + instance.getClass().getName(), x);
                        }
                    }
                }
            }
            return instance;
        }

        public boolean offer(Object instance) {
            if (instance instanceof Recyclable) {
                try {
                    ((Recyclable)instance).dispose();
                }
                catch (Exception x) {
                    return false;
                }
            }
            return this.pool.offer(instance);
        }

        public int capacity() {
            return this.pool.capacity();
        }

        public int size() {
            return this.pool.size();
        }

        private Method getRecycle(String[] signature) {
            ArrayList cache = this.recyclers;
            if (cache != null) {
                Iterator i = ((AbstractList)cache).iterator();
                while (i.hasNext()) {
                    Method recycle = ((Recycler)i.next()).match(signature);
                    if (recycle == null) continue;
                    return recycle;
                }
            }
            return null;
        }

        public PoolBuffer(int capacity) {
            this.pool = new BoundedBuffer(capacity);
        }

        private class Recycler {
            private final Method recycle;
            private final String[] signature;

            public Method match(String[] sign) {
                if (sign != null && sign.length > 0) {
                    if (this.signature != null && sign.length == this.signature.length) {
                        int i = 0;
                        while (i < this.signature.length) {
                            if (!this.signature[i].equals(sign[i])) {
                                return null;
                            }
                            ++i;
                        }
                        return this.recycle;
                    }
                    return null;
                }
                if (this.signature == null) {
                    return this.recycle;
                }
                return null;
            }

            public Recycler(Method rec, String[] sign) {
                this.recycle = rec;
                this.signature = sign != null && sign.length > 0 ? sign : null;
            }
        }
    }
}

